/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class SliderControl
extends ExtendedButtonControl {
    private final float minValue;
    private final float maxValue;
    private final float valueStep;
    private final String windowTitle;
    private float sliderValue;
    private float denormalizedSlideValue;
    private boolean dragging;
    private Runnable onSlideEvent;

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        super(buttonId, (int)positionData.getFirst(), (int)positionData.getSecond(), (int)dimensions.getFirst(), (int)dimensions.getSecond(), "", new String[0]);
        this.setSliderValue(startValue);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.valueStep = valueStep;
        this.func_238482_a_((ITextComponent)new StringTextComponent(displayString + ": " + this.denormalizedSlideValue));
        this.windowTitle = displayString;
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(int buttonId, Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(buttonId, positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString) {
        this(CraftPresence.GUIS.getNextIndex(), positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Runnable onPushEvent) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString);
        this.setOnClick(onPushEvent);
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Pair<Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, events.getFirst());
        this.setOnHover(events.getSecond());
    }

    public SliderControl(Pair<Integer, Integer> positionData, Pair<Integer, Integer> dimensions, float startValue, float minValue, float maxValue, float valueStep, String displayString, Tuple<Runnable, Runnable, Runnable> events) {
        this(positionData, dimensions, startValue, minValue, maxValue, valueStep, displayString, new Pair<Runnable, Runnable>(events.getFirst(), events.getSecond()));
        this.setOnSlide(events.getThird());
    }

    protected int func_230989_a_(boolean mouseOver) {
        return 0;
    }

    protected void func_230441_a_(@Nonnull MatrixStack matrixStack, @Nonnull Minecraft mc, int mouseX, int mouseY) {
        if (this.field_230694_p_) {
            if (this.dragging) {
                this.sliderValue = (float)(mouseX - (this.getControlPosX() + 4)) / (float)(this.getControlWidth() - 8);
                this.sliderValue = this.clamp(this.sliderValue, 0.0f, 1.0f);
                this.denormalizedSlideValue = this.denormalizeValue(this.sliderValue);
                this.setControlMessage(this.windowTitle + ": " + this.denormalizedSlideValue);
            }
            this.onSlide();
            int hoverValue = (this.field_230692_n_ ? 2 : 1) * 20;
            CraftPresence.GUIS.renderSlider(this.getControlPosX() + (int)(this.sliderValue * (float)(this.getControlWidth() - 8)), this.getControlPosY(), 0, 46 + hoverValue, 4, 20, this.func_230927_p_(), field_230687_i_);
        }
    }

    @Override
    public void func_230982_a_(double mouseX, double mouseY) {
        this.sliderValue = (float)(mouseX - (double)(this.getControlPosX() + 4)) / (float)(this.getControlWidth() - 8);
        this.sliderValue = this.clamp(this.sliderValue, 0.0f, 1.0f);
        this.denormalizedSlideValue = this.denormalizeValue(this.sliderValue);
        this.setControlMessage(this.windowTitle + ": " + this.denormalizedSlideValue);
        this.dragging = true;
    }

    public void setSliderValue(float newValue) {
        if (newValue >= 0.0f && newValue <= 1.0f) {
            this.sliderValue = newValue;
            this.denormalizedSlideValue = this.denormalizeValue(newValue);
        } else {
            this.sliderValue = this.normalizeValue(newValue);
            this.denormalizedSlideValue = newValue;
        }
        this.setControlMessage(this.windowTitle + ": " + this.denormalizedSlideValue);
    }

    public float getSliderValue(boolean useNormal) {
        return useNormal ? this.sliderValue : this.denormalizedSlideValue;
    }

    private float clamp(float num, float min, float max) {
        if (num < min) {
            return min;
        }
        return Math.min(num, max);
    }

    private float normalizeValue(float value) {
        return this.clamp((this.snapToStepClamp(value) - this.minValue) / (this.maxValue - this.minValue), 0.0f, 1.0f);
    }

    private float denormalizeValue(float value) {
        return this.snapToStepClamp(this.minValue + (this.maxValue - this.minValue) * this.clamp(value, 0.0f, 1.0f));
    }

    private float snapToStepClamp(float originalValue) {
        float value = this.snapToStep(originalValue);
        return this.clamp(value, this.minValue, this.maxValue);
    }

    private float snapToStep(float originalValue) {
        float value = originalValue;
        if (this.valueStep > 0.0f) {
            value = this.valueStep * (float)Math.round(value / this.valueStep);
        }
        return value;
    }

    public void func_231000_a__(double mouseX, double mouseY) {
        this.dragging = false;
    }

    public void setOnSlide(Runnable event) {
        this.onSlideEvent = event;
    }

    public void onSlide() {
        if (this.onSlideEvent != null) {
            this.onSlideEvent.run();
        }
    }

    public boolean isDragging() {
        return this.dragging;
    }
}

