/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.util.ResourceLocation;

public class ScrollableListControl
extends ExtendedList<StringEntry> {
    public String currentValue;
    public List<String> itemList;
    public RenderType renderType;
    public boolean visible = true;

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(Minecraft mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.itemList = itemList;
        this.currentValue = currentValue;
        this.renderType = renderType;
        if (renderType == RenderType.ItemData) {
            CraftPresence.TILE_ENTITIES.getEntities();
        }
        this.updateEntries();
    }

    public void setSelected(StringEntry entry) {
        super.func_241215_a_((AbstractList.AbstractListEntry)entry);
        if (entry != null) {
            this.currentValue = entry.displayName;
        }
    }

    protected int func_230965_k_() {
        return this.itemList.size();
    }

    protected void func_230433_a_(@Nonnull MatrixStack matrixStack) {
        if (this.func_230965_k_() != this.func_231039_at__().size()) {
            this.func_230963_j_();
            this.updateEntries();
        }
    }

    public void updateEntries() {
        for (String item : this.itemList) {
            StringEntry dataEntry = new StringEntry(item, this.renderType);
            this.func_230513_b_((AbstractList.AbstractListEntry)dataEntry);
            if (!item.equals(this.currentValue)) continue;
            this.setSelected(dataEntry);
        }
        if (this.func_230958_g_() != null) {
            this.func_230951_c_((AbstractList.AbstractListEntry)((StringEntry)this.func_230958_g_()));
        }
    }

    public FontRenderer getFontRenderer() {
        return this.field_230668_b_.field_71466_p != null ? this.field_230668_b_.field_71466_p : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        None;

    }

    public class StringEntry
    extends ExtendedList.AbstractListEntry<StringEntry> {
        private final RenderType renderType;
        private String displayName;

        public StringEntry(String name) {
            this(name, RenderType.None);
        }

        public StringEntry(String name, RenderType renderType) {
            this.displayName = name;
            this.renderType = renderType;
        }

        public void func_230432_a_(@Nonnull MatrixStack matrices, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int xOffset = xPos;
            if (!CraftPresence.CONFIG.stripExtraGuiElements && (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset || this.renderType == RenderType.ServerData && CraftPresence.SERVER.enabled || this.renderType == RenderType.EntityData && CraftPresence.ENTITIES.enabled || this.renderType == RenderType.ItemData && CraftPresence.TILE_ENTITIES.enabled)) {
                ResourceLocation texture = new ResourceLocation("");
                if (this.renderType == RenderType.ServerData) {
                    ServerData data = CraftPresence.SERVER.getDataFromName(this.displayName);
                    if (data != null) {
                        String assetUrl = "data:image/unknown;base64," + data.func_147409_e();
                        texture = ImageUtils.getTextureFromUrl(this.displayName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
                    }
                } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
                    String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, this.displayName);
                    texture = ImageUtils.getTextureFromUrl(this.displayName, assetUrl);
                } else if (this.renderType == RenderType.EntityData) {
                    if (StringUtils.isValidUuid(this.displayName)) {
                        this.displayName = StringUtils.getFromUuid(this.displayName);
                        texture = ImageUtils.getTextureFromUrl(this.displayName, String.format(CraftPresence.CONFIG.playerSkinEndpoint, this.displayName));
                    }
                } else if (this.renderType == RenderType.ItemData) {
                    texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.getOrDefault(this.displayName, texture);
                }
                if (!ImageUtils.isTextureNull(texture)) {
                    CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0f, 32.0f, 0.0f, texture);
                }
                xOffset += 35;
            }
            ScrollableListControl.this.getFontRenderer().func_238405_a_(matrices, this.displayName, (float)xOffset, (float)yPos + ((float)entryHeight / 2.0f - (float)ScrollableListControl.this.getFontHeight() / 2.0f), 0xFFFFFF);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        private void onPressed() {
            ScrollableListControl.this.setSelected(this);
        }
    }
}

