/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import com.mojang.blaze3d.matrix.MatrixStack;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class ExtendedButtonControl
extends Button {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private FontRenderer currentFontRender = null;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (ITextComponent)new StringTextComponent(buttonText), button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.onPushEvent = onPushEvent;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.onHoverEvent = onHoverEvent;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (ITextComponent)new StringTextComponent(buttonText), button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(CraftPresence.GUIS.getNextIndex(), xPos, yPos, displayString);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_230694_p_) {
            this.field_230692_n_ = CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, this);
            int hoverState = this.func_230989_a_(this.field_230692_n_);
            String backgroundCode = CraftPresence.CONFIG.buttonBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                CraftPresence.GUIS.drawGradientRect(this.func_230927_p_(), this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), backgroundCode, backgroundCode);
            } else {
                ResourceLocation texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                        backgroundCode = backgroundCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                    }
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new ResourceLocation(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new ResourceLocation(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
                CraftPresence.GUIS.renderButton(this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), hoverState, this.func_230927_p_(), texLocation);
            }
            this.func_230441_a_(matrixStack, CraftPresence.instance, mouseX, mouseY);
            int color = !this.field_230693_o_ ? 0xA0A0A0 : (this.field_230692_n_ ? 0xFFFFA0 : 0xE0E0E0);
            ExtendedButtonControl.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.getFontRenderer(), (String)this.getDisplayMessage(), (int)(this.getControlPosX() + this.getControlWidth() / 2), (int)(this.getControlPosY() + (this.getControlHeight() - 8) / 2), (int)color);
        }
    }

    public int getControlWidth() {
        return this.field_230688_j_;
    }

    public int getControlHeight() {
        return this.field_230689_k_;
    }

    public int getControlPosX() {
        return this.field_230690_l_;
    }

    public int getControlPosY() {
        return this.field_230691_m_;
    }

    public FontRenderer getFontRenderer() {
        return this.currentFontRender != null ? this.currentFontRender : GuiUtils.getDefaultFontRenderer();
    }

    public void setCurrentFontRender(FontRenderer currentFontRender) {
        this.currentFontRender = currentFontRender;
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public String[] getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void func_230982_a_(double mouseX, double mouseY) {
        this.onClick();
        super.func_230982_a_(mouseX, mouseY);
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public ITextComponent getControlRawMessage() {
        return this.func_230458_i_();
    }

    public void setControlRawMessage(ITextComponent newMessage) {
        this.func_238482_a_(newMessage);
    }

    public String getDisplayMessage() {
        String result = this.getControlMessage().trim();
        if (result.contains(" ")) {
            String adjusted = result;
            for (String dataPart : result.split(" ")) {
                if (!ModUtils.TRANSLATOR.hasTranslation(dataPart)) continue;
                adjusted = adjusted.replace(dataPart, ModUtils.TRANSLATOR.translate(dataPart, new Object[0]));
            }
            result = adjusted;
        } else if (ModUtils.TRANSLATOR.hasTranslation(this.getControlMessage())) {
            result = ModUtils.TRANSLATOR.translate(result, new Object[0]);
        }
        return result;
    }

    public String getControlMessage() {
        return this.getControlRawMessage().getString();
    }

    public void setControlMessage(String newMessage) {
        this.setControlRawMessage((ITextComponent)new StringTextComponent(newMessage));
    }

    public boolean isControlEnabled() {
        return this.field_230693_o_;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.field_230693_o_ = isEnabled;
    }

    public boolean isControlVisible() {
        return this.field_230694_p_;
    }

    public void setControlVisible(boolean isVisible) {
        this.field_230694_p_ = isVisible;
    }
}

