/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets;

import com.google.common.collect.Maps;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.UrlUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import java.util.Map;
import java.util.Random;

public class DiscordAssetUtils {
    private static final String applicationEndpoint = "https://discord.com/api/oauth2/applications/";
    private static final String assetsEndpoint = "https://cdn.discordapp.com/app-assets/";
    public static boolean syncCompleted = false;
    public static Map<String, DiscordAsset> ASSET_LIST = Maps.newHashMap();
    public static Map<String, DiscordAsset> CUSTOM_ASSET_LIST = Maps.newHashMap();

    public static boolean contains(Map<String, DiscordAsset> list, String key) {
        String formattedKey = StringUtils.isNullOrEmpty(key) ? "" : StringUtils.formatAsIcon(key.replace(" ", "_"));
        return list.containsKey(formattedKey);
    }

    public static boolean contains(String key) {
        return DiscordAssetUtils.contains(ASSET_LIST, key);
    }

    public static DiscordAsset get(Map<String, DiscordAsset> list, String key) {
        String formattedKey = StringUtils.isNullOrEmpty(key) ? "" : StringUtils.formatAsIcon(key.replace(" ", "_"));
        return DiscordAssetUtils.contains(formattedKey) ? list.get(formattedKey) : null;
    }

    public static DiscordAsset get(String key) {
        return DiscordAssetUtils.get(ASSET_LIST, key);
    }

    public static String getKey(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getName() : "";
    }

    public static String getKey(String key) {
        return DiscordAssetUtils.getKey(ASSET_LIST, key);
    }

    public static String getId(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getId() : "";
    }

    public static String getId(String key) {
        return DiscordAssetUtils.getId(ASSET_LIST, key);
    }

    public static DiscordAsset.AssetType getType(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        return asset != null ? asset.getType() : DiscordAsset.AssetType.LARGE;
    }

    public static DiscordAsset.AssetType getType(String key) {
        return DiscordAssetUtils.getType(ASSET_LIST, key);
    }

    public static String getUrl(Map<String, DiscordAsset> list, String key) {
        DiscordAsset asset = DiscordAssetUtils.get(list, key);
        if (asset != null) {
            if (!StringUtils.isNullOrEmpty(asset.getId())) {
                return DiscordAssetUtils.getDiscordAssetUrl(asset.getName());
            }
            return StringUtils.sequentialReplaceAnyCase(asset.getUrl(), CraftPresence.CLIENT.getArgumentsFor(ArgumentType.Text));
        }
        return "";
    }

    public static String getUrl(String key) {
        return DiscordAssetUtils.getUrl(ASSET_LIST, key);
    }

    public static void emptyData() {
        ASSET_LIST.clear();
        CUSTOM_ASSET_LIST.clear();
        DiscordAssetUtils.clearClientData();
    }

    public static void clearClientData() {
        syncCompleted = false;
    }

    public static DiscordAsset getRandomAsset() {
        try {
            Random randomObj = new Random();
            DiscordAsset[] values = ASSET_LIST.values().toArray(new DiscordAsset[0]);
            return values[randomObj.nextInt(values.length)];
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.config.invalid.icon.empty", new Object[0]), new Object[0]);
            ex.printStackTrace();
            return null;
        }
    }

    public static String getRandomAssetName() {
        DiscordAsset randAsset = DiscordAssetUtils.getRandomAsset();
        return randAsset != null ? randAsset.getName() : "";
    }

    public static String getDiscordAssetUrl(String clientId, String keyId, boolean isLocalName) {
        return !StringUtils.isNullOrEmpty(keyId) ? assetsEndpoint + clientId + "/" + (isLocalName ? DiscordAssetUtils.getId(keyId) : keyId) + ".png" : "";
    }

    public static String getDiscordAssetUrl(String clientId, String keyId) {
        return DiscordAssetUtils.getDiscordAssetUrl(clientId, keyId, clientId.equals(CraftPresence.CONFIG.clientId));
    }

    public static String getDiscordAssetUrl(String keyId) {
        return DiscordAssetUtils.getDiscordAssetUrl(CraftPresence.CONFIG.clientId, keyId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DiscordAsset[] loadAssets(String clientId, boolean filterToMain) {
        Object[] objectArray;
        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load", clientId), new Object[0]);
        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.load.credits", new Object[0]), new Object[0]);
        try {
            String url = applicationEndpoint + clientId + "/assets";
            DiscordAsset[] assets = UrlUtils.getJSONFromURL(url, DiscordAsset[].class);
            if (filterToMain) {
                ASSET_LIST = Maps.newHashMap();
                CUSTOM_ASSET_LIST = Maps.newHashMap();
                if (assets != null) {
                    for (DiscordAsset asset : assets) {
                        if (!StringUtils.isNullOrEmpty(asset.getUrl()) && asset.getType() != DiscordAsset.AssetType.CUSTOM) {
                            asset.setUrl(DiscordAssetUtils.getDiscordAssetUrl(clientId, asset.getId(), false));
                        }
                        if (ASSET_LIST.containsKey(asset.getName())) continue;
                        ASSET_LIST.put(asset.getName(), asset);
                    }
                }
                for (String iconData : CraftPresence.CONFIG.dynamicIcons) {
                    String[] part;
                    if (StringUtils.isNullOrEmpty(iconData) || StringUtils.isNullOrEmpty((part = iconData.split(CraftPresence.CONFIG.splitCharacter))[0]) || StringUtils.isNullOrEmpty(part[1])) continue;
                    DiscordAsset asset = new DiscordAsset().setName(part[0]).setUrl(part[1]).setType(DiscordAsset.AssetType.CUSTOM);
                    if (!CUSTOM_ASSET_LIST.containsKey(asset.getName())) {
                        CUSTOM_ASSET_LIST.put(asset.getName(), asset);
                    }
                    if (asset.getName().equalsIgnoreCase("default")) continue;
                    ASSET_LIST.put(asset.getName(), asset);
                }
            }
            objectArray = assets;
        }
        catch (Exception ex) {
            DiscordAsset[] discordAssetArray;
            try {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.discord.assets.load", new Object[0]), new Object[0]);
                ex.printStackTrace();
                discordAssetArray = null;
            }
            catch (Throwable throwable) {
                DiscordAssetUtils.verifyConfigAssets();
                syncCompleted = true;
                ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
                throw throwable;
            }
            DiscordAssetUtils.verifyConfigAssets();
            syncCompleted = true;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
            return discordAssetArray;
        }
        DiscordAssetUtils.verifyConfigAssets();
        syncCompleted = true;
        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.discord.assets.detected", String.valueOf(ASSET_LIST.size())), new Object[0]);
        return objectArray;
    }

    private static void verifyConfigAssets() {
        boolean needsFullUpdate = false;
        for (String property : CraftPresence.CONFIG.properties.stringPropertyNames()) {
            if (!property.equals(CraftPresence.CONFIG.NAME_defaultIcon) && !property.equals(CraftPresence.CONFIG.NAME_defaultDimensionIcon) && !property.equals(CraftPresence.CONFIG.NAME_defaultServerIcon) || DiscordAssetUtils.contains(CraftPresence.CONFIG.properties.getProperty(property))) continue;
            String newAsset = DiscordAssetUtils.contains(CraftPresence.CONFIG.defaultIcon) ? CraftPresence.CONFIG.defaultIcon : DiscordAssetUtils.getRandomAssetName();
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.config.invalid.icon.pre", CraftPresence.CONFIG.properties.getProperty(property), property), new Object[0]);
            CraftPresence.CONFIG.properties.setProperty(property, newAsset);
            needsFullUpdate = true;
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.config.invalid.icon.post", property, newAsset), new Object[0]);
        }
        if (needsFullUpdate) {
            CraftPresence.CONFIG.save("UTF-8");
            CraftPresence.CONFIG.read(false, "UTF-8");
        }
    }
}

