/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.utils.discord;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import external.com.jagrosh.discordipc.IPCClient;
import external.com.jagrosh.discordipc.entities.DiscordBuild;
import external.com.jagrosh.discordipc.entities.RichPresence;
import external.com.jagrosh.discordipc.entities.User;
import external.com.jagrosh.discordipc.entities.pipe.PipeStatus;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.PartyPrivacy;
import forge.com.gitlab.cdagaming.craftpresence.integrations.curse.CurseUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.mcupdater.MCUpdaterUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.multimc.MultiMCUtils;
import forge.com.gitlab.cdagaming.craftpresence.integrations.technic.TechnicUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.FileUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.ModIPCListener;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAsset;
import forge.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DiscordUtils {
    public static final List<String> textModules = Lists.newArrayList((Object[])new String[]{"&MAINMENU&", "&BRAND&", "&MCVERSION&", "&IGN&", "&MODS&", "&PACK&", "&DIMENSION&", "&BIOME&", "&SERVER&", "&SCREEN&", "&TILEENTITY&", "&TARGETENTITY&", "&RIDINGENTITY&"});
    public static final List<String> iconModules = Lists.newArrayList((Object[])new String[]{"&DEFAULT&", "&MAINMENU&", "&PACK&", "&DIMENSION&", "&BIOME&", "&SERVER&"});
    public static final Map<String, Pair<String, String>> validOperators = ImmutableMap.builder().put((Object)"|", new Pair<String, String>("\\|", "&[^&]*&[\\|]&[^&]*&")).build();
    private final Map<ArgumentType, List<Pair<String, String>>> presenceData = Maps.newHashMap();
    private final List<Pair<String, String>> modsArgs = Lists.newArrayList();
    private final List<Pair<String, String>> playerInfoArgs = Lists.newArrayList();
    private final List<Pair<String, String>> packArgs = Lists.newArrayList();
    private final Map<String, String> cachedImageData = Maps.newHashMap();
    public User CURRENT_USER;
    public User REQUESTER_USER;
    public DiscordStatus STATUS = DiscordStatus.Disconnected;
    public String GAME_STATE;
    public String DETAILS;
    public DiscordAsset SMALL_IMAGE_ASSET;
    public String SMALL_IMAGE_KEY;
    public String SMALL_IMAGE_TEXT;
    public DiscordAsset LARGE_IMAGE_ASSET;
    public String LARGE_IMAGE_KEY;
    public String LARGE_IMAGE_TEXT;
    public String CLIENT_ID;
    public DiscordBuild PREFERRED_CLIENT = DiscordBuild.ANY;
    public boolean AUTO_REGISTER;
    public long START_TIMESTAMP;
    public String PARTY_ID;
    public int PARTY_SIZE;
    public int PARTY_MAX;
    public PartyPrivacy PARTY_PRIVACY = PartyPrivacy.Public;
    public String JOIN_SECRET;
    public long END_TIMESTAMP;
    public String MATCH_SECRET;
    public String SPECTATE_SECRET;
    public JsonArray BUTTONS = new JsonArray();
    public byte INSTANCE;
    public IPCClient ipcInstance;
    public boolean awaitingReply = false;
    public List<Pair<String, String>> generalArgs = Lists.newArrayList();
    private Pair<String, String> lastRequestedImageData = new Pair();
    private RichPresence currentPresence;

    public synchronized void setup() {
        Thread shutdownThread = new Thread("CraftPresence-ShutDown-Handler"){

            @Override
            public void run() {
                CraftPresence.closing = true;
                CraftPresence.timerObj.cancel();
                DiscordUtils.this.shutDown();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownThread);
    }

    public synchronized void init(boolean debugMode, boolean verboseMode, boolean updateTimestamp) {
        try {
            if (updateTimestamp) {
                this.updateTimestamp();
            }
            this.ipcInstance = new IPCClient(Long.parseLong(this.CLIENT_ID), debugMode, verboseMode, this.AUTO_REGISTER, this.CLIENT_ID);
            this.ipcInstance.setListener(new ModIPCListener());
            if (this.PREFERRED_CLIENT != DiscordBuild.ANY) {
                this.ipcInstance.connect(this.PREFERRED_CLIENT, DiscordBuild.ANY);
            } else {
                this.ipcInstance.connect(new DiscordBuild[0]);
            }
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_JOIN_REQUEST);
            this.ipcInstance.subscribe(IPCClient.Event.ACTIVITY_SPECTATE);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (String moduleId : textModules) {
            this.initArgument(ArgumentType.Text, moduleId);
        }
        for (String moduleId : iconModules) {
            this.initArgument(ArgumentType.Image, moduleId);
        }
        CommandUtils.isInMainMenu = false;
        this.syncPlaceholders();
    }

    public synchronized void init(boolean debugMode, boolean updateTimestamp) {
        this.init(debugMode, ModUtils.IS_VERBOSE, updateTimestamp);
    }

    public synchronized void init(boolean updateTimestamp) {
        this.init(ModUtils.IS_DEV, updateTimestamp);
    }

    public List<String> createButtonsList() {
        ArrayList result = Lists.newArrayList();
        for (String buttonElement : CraftPresence.CONFIG.buttonMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(buttonElement) || StringUtils.isNullOrEmpty((part = buttonElement.split(CraftPresence.CONFIG.splitCharacter))[0])) continue;
            result.add(part[0]);
        }
        return result;
    }

    public String sanitizePlaceholders(String input) {
        return !StringUtils.isNullOrEmpty(input) ? input.replaceAll("&[^&]*&", "").trim() : "";
    }

    public String parseArgumentOperators(String input, ArgumentType ... typeList) {
        String result = input;
        if (CraftPresence.CONFIG.allowPlaceholderOperators) {
            for (Map.Entry<String, Pair<String, String>> rawEntry : validOperators.entrySet()) {
                Pair<String, String> operatorEntry = rawEntry.getValue();
                Pair<String, List<String>> matches = StringUtils.getMatches(operatorEntry.getSecond(), result);
                if (matches.getSecond().isEmpty()) continue;
                for (String match : matches.getSecond()) {
                    boolean foundMatch = false;
                    String resultMatch = match;
                    block2: for (String splitData : match.split(operatorEntry.getFirst())) {
                        if (foundMatch) break;
                        for (ArgumentType type : typeList) {
                            if (this.getRawArgumentEntries(type, false, splitData).isEmpty()) continue;
                            foundMatch = true;
                            resultMatch = splitData;
                            continue block2;
                        }
                    }
                    result = result.replace(match, foundMatch ? resultMatch : "");
                }
            }
        }
        return StringUtils.sequentialReplaceAnyCase(result, this.getArgumentsFor(typeList));
    }

    public void updateTimestamp() {
        if (CraftPresence.CONFIG.showTime) {
            this.START_TIMESTAMP = System.currentTimeMillis() / 1000L;
        }
    }

    public void syncArgument(String argumentName, String insertString, ArgumentType ... dataTypes) {
        for (ArgumentType dataType : dataTypes) {
            if (StringUtils.isNullOrEmpty(argumentName)) continue;
            this.setArgumentsFor(dataType, new Pair<String, String>(argumentName, insertString));
        }
    }

    public void initArgument(ArgumentType dataType, String ... args) {
        for (String argumentName : args) {
            this.syncArgument(argumentName, "", dataType);
        }
    }

    public void initArgument(String ... args) {
        for (ArgumentType type : ArgumentType.values()) {
            this.initArgument(type, args);
        }
    }

    public List<Pair<String, String>> getArgumentsFor(ArgumentType ... typeList) {
        ArrayList result = Lists.newArrayList();
        for (ArgumentType type : typeList) {
            if (!this.presenceData.containsKey((Object)type)) {
                this.presenceData.put(type, Lists.newArrayList());
            }
            StringUtils.addEntriesNotPresent(result, this.presenceData.get((Object)type));
        }
        return result;
    }

    public void removeArgumentsMatching(ArgumentType type, String ... args) {
        if (this.presenceData.containsKey((Object)type)) {
            ArrayList list = Lists.newArrayList((Iterable)this.presenceData.get((Object)type));
            for (Pair<String, String> entry : this.presenceData.get((Object)type)) {
                for (String format : args) {
                    if (!entry.getFirst().contains(format)) continue;
                    list.remove(entry);
                }
            }
            this.setArgumentsFor(type, list);
        }
    }

    public void removeArgumentsMatching(String ... args) {
        for (ArgumentType type : ArgumentType.values()) {
            this.removeArgumentsMatching(type, args);
        }
    }

    public List<Pair<String, String>> getArgumentsMatching(ArgumentType type, boolean allowNullEntries, String ... args) {
        ArrayList list = Lists.newArrayList();
        if (this.presenceData.containsKey((Object)type)) {
            for (Pair<String, String> entry : this.presenceData.get((Object)type)) {
                boolean isEntryValid = allowNullEntries || !StringUtils.isNullOrEmpty(entry.getSecond());
                for (String format : args) {
                    if (!entry.getFirst().contains(format) || !isEntryValid) continue;
                    list.add(entry);
                }
            }
        }
        return list;
    }

    public List<Pair<String, String>> getArgumentsMatching(ArgumentType type, String ... args) {
        return this.getArgumentsMatching(type, true, args);
    }

    public List<Pair<String, String>> getArgumentsMatching(boolean allowNullEntries, String ... args) {
        ArrayList results = Lists.newArrayList();
        for (ArgumentType type : ArgumentType.values()) {
            StringUtils.addEntriesNotPresent(results, this.getArgumentsMatching(type, allowNullEntries, args));
        }
        return results;
    }

    public List<Pair<String, String>> getArgumentsMatching(String ... args) {
        return this.getArgumentsMatching(true, args);
    }

    public List<String> getArgumentEntries(ArgumentType type, boolean formatToLower, boolean allowNullEntries, String ... args) {
        List<Pair<String, String>> list = this.getArgumentsMatching(type, allowNullEntries, args);
        ArrayList result = Lists.newArrayList();
        for (Pair<String, String> entry : list) {
            result.add(formatToLower ? entry.getFirst().toLowerCase() : entry.getFirst());
        }
        return result;
    }

    public List<String> getArgumentEntries(ArgumentType type, boolean formatToLower, String ... args) {
        return this.getArgumentEntries(type, formatToLower, true, args);
    }

    public List<String> getRawArgumentEntries(ArgumentType type, boolean allowNullEntries, String ... args) {
        return this.getArgumentEntries(type, false, allowNullEntries, args);
    }

    public List<String> getRawArgumentEntries(ArgumentType type, String ... args) {
        return this.getRawArgumentEntries(type, true, args);
    }

    public boolean hasArgumentsMatching(ArgumentType type, boolean allowNullEntries, String ... args) {
        return !this.getArgumentsMatching(type, allowNullEntries, args).isEmpty();
    }

    public boolean hasArgumentsMatching(ArgumentType type, String ... args) {
        return this.hasArgumentsMatching(type, true, args);
    }

    public void setArgumentsFor(ArgumentType type, List<Pair<String, String>> data) {
        this.presenceData.put(type, data);
    }

    public void setArgumentsFor(ArgumentType type, Pair<String, String> data) {
        List<Pair<String, String>> list = this.getArgumentsFor(type);
        StringUtils.removeIf(list, e -> ((String)e.getFirst()).equalsIgnoreCase((String)data.getFirst()));
        list.add(data);
        this.setArgumentsFor(type, list);
    }

    private void syncPackArguments() {
        this.packArgs.clear();
        String foundPackName = "";
        String foundPackIcon = "";
        if (ModUtils.BRAND.contains("vivecraft")) {
            CraftPresence.packFound = true;
            foundPackName = CraftPresence.CONFIG.vivecraftMessage;
            foundPackIcon = "vivecraft";
        } else if (!StringUtils.isNullOrEmpty(CurseUtils.INSTANCE_NAME)) {
            foundPackIcon = foundPackName = CurseUtils.INSTANCE_NAME;
        } else if (!StringUtils.isNullOrEmpty(MultiMCUtils.INSTANCE_NAME)) {
            foundPackName = MultiMCUtils.INSTANCE_NAME;
            foundPackIcon = MultiMCUtils.ICON_KEY;
        } else if (MCUpdaterUtils.instance != null && !StringUtils.isNullOrEmpty(MCUpdaterUtils.instance.getPackName())) {
            foundPackIcon = foundPackName = MCUpdaterUtils.instance.getPackName();
        } else if (!StringUtils.isNullOrEmpty(TechnicUtils.PACK_NAME)) {
            foundPackName = TechnicUtils.PACK_NAME;
            foundPackIcon = TechnicUtils.ICON_NAME;
        } else if (!StringUtils.isNullOrEmpty(CraftPresence.CONFIG.fallbackPackPlaceholderMessage)) {
            foundPackIcon = foundPackName = CraftPresence.CONFIG.fallbackPackPlaceholderMessage;
        }
        this.packArgs.add(new Pair<String, String>("&NAME&", !StringUtils.isNullOrEmpty(foundPackName) ? foundPackName : ""));
        for (Pair<String, String> argumentData : this.packArgs) {
            this.syncArgument("&PACK:" + argumentData.getFirst().substring(1), argumentData.getSecond(), ArgumentType.Text);
        }
        this.syncArgument("&PACK&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.packPlaceholderMessage, this.packArgs), ArgumentType.Text);
        this.syncArgument("&PACK&", !StringUtils.isNullOrEmpty(foundPackIcon) ? StringUtils.formatAsIcon(foundPackIcon) : "", ArgumentType.Image);
    }

    public List<Pair<String, String>> generateArgumentList(boolean allowNullEntries, Map<ArgumentType, List<String>> argumentData) {
        ArrayList results = Lists.newArrayList();
        for (Map.Entry<ArgumentType, List<String>> entry : argumentData.entrySet()) {
            StringUtils.addEntriesNotPresent(results, data -> StringUtils.filter(Lists.newArrayList((Iterable)results), e -> ((String)e.getFirst()).equalsIgnoreCase((String)data.getFirst())).isEmpty(), this.convertToArgumentList(entry.getKey(), allowNullEntries, entry.getValue()));
        }
        return results;
    }

    public List<Pair<String, String>> generateArgumentList(Map<ArgumentType, List<String>> argumentData) {
        return this.generateArgumentList(true, argumentData);
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, boolean addExtraData, List<Pair<String, String>> args) {
        StringBuilder finalString = new StringBuilder(String.format("%s%s:", ModUtils.TRANSLATOR.translate(String.format("%s.placeholders.title", "craftpresence"), new Object[0]), !StringUtils.isNullOrEmpty(argumentFormat) ? " (" + argumentFormat.toLowerCase() + ")" : ""));
        if (args != null && !args.isEmpty()) {
            for (Pair<String, String> argData : args) {
                String placeholderName;
                String translationName = placeholderName = argData.getFirst();
                if (!StringUtils.isNullOrEmpty(argumentFormat)) {
                    if (!StringUtils.isNullOrEmpty(subArgumentFormat)) {
                        placeholderName = placeholderName.replaceAll(subArgumentFormat, argumentFormat.substring(0, 1));
                    }
                    translationName = (argumentFormat + "." + placeholderName).replaceAll(argumentFormat.substring(0, 1), "");
                } else {
                    translationName = translationName.replaceAll("[^a-zA-Z0-9]", "");
                }
                finalString.append(String.format("\\n - %s = %s", placeholderName.toLowerCase(), ModUtils.TRANSLATOR.translate(String.format("%s.placeholders.%s.description", "craftpresence", translationName.replaceAll(":", ".")), new Object[0])));
                if (!addExtraData || StringUtils.isNullOrEmpty(argData.getSecond())) continue;
                String tagValue = argData.getSecond();
                finalString.append(String.format("\\n ==> %s \"%s\"", ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]), tagValue.length() >= 128 ? "<...>" : tagValue));
            }
        } else {
            finalString.append("\\n - N/A");
        }
        return finalString.toString();
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, List<Pair<String, String>> args) {
        return this.generateArgumentMessage(argumentFormat, subArgumentFormat, CraftPresence.CONFIG.allowPlaceholderPreviews, args);
    }

    public String generateArgumentMessage(String argumentFormat, List<Pair<String, String>> args) {
        return this.generateArgumentMessage(argumentFormat, (String)null, args);
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, Map<ArgumentType, List<String>> args) {
        return this.generateArgumentMessage(argumentFormat, subArgumentFormat, this.generateArgumentList(args));
    }

    public String generateArgumentMessage(String argumentFormat, Map<ArgumentType, List<String>> args) {
        return this.generateArgumentMessage(argumentFormat, null, args);
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, ArgumentType type, boolean allowNullEntries, String ... args) {
        return this.generateArgumentMessage(argumentFormat, subArgumentFormat, this.convertToArgumentList(type, allowNullEntries, args));
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, ArgumentType type, String ... args) {
        return this.generateArgumentMessage(argumentFormat, subArgumentFormat, type, true, args);
    }

    public String generateArgumentMessage(String argumentFormat, ArgumentType type, boolean allowNullEntries, String ... args) {
        return this.generateArgumentMessage(argumentFormat, null, type, allowNullEntries, args);
    }

    public String generateArgumentMessage(String argumentFormat, ArgumentType type, String ... args) {
        return this.generateArgumentMessage(argumentFormat, type, true, args);
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, ArgumentType type, boolean allowNullEntries, List<String> args) {
        return this.generateArgumentMessage(argumentFormat, subArgumentFormat, this.convertToArgumentList(type, allowNullEntries, args));
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, ArgumentType type, List<String> args) {
        return this.generateArgumentMessage(argumentFormat, subArgumentFormat, type, true, args);
    }

    public String generateArgumentMessage(String argumentFormat, ArgumentType type, boolean allowNullEntries, List<String> args) {
        return this.generateArgumentMessage(argumentFormat, null, type, allowNullEntries, args);
    }

    public String generateArgumentMessage(String argumentFormat, ArgumentType type, List<String> args) {
        return this.generateArgumentMessage(argumentFormat, type, true, args);
    }

    public List<Pair<String, String>> convertToArgumentList(ArgumentType type, boolean allowNullEntries, String ... args) {
        ArrayList result = Lists.newArrayList();
        List<Pair<String, String>> existingArgs = this.getArgumentsMatching(type, allowNullEntries, args);
        for (String argumentName : args) {
            if (!existingArgs.isEmpty()) {
                for (Pair<String, String> entry : existingArgs) {
                    if (!entry.getFirst().contains(argumentName)) continue;
                    result.add(entry);
                }
                continue;
            }
            result.add(new Pair<String, String>(argumentName, ""));
        }
        return result;
    }

    public List<Pair<String, String>> convertToArgumentList(ArgumentType type, String ... args) {
        return this.convertToArgumentList(type, true, args);
    }

    public List<Pair<String, String>> convertToArgumentList(ArgumentType type, boolean allowNullEntries, List<String> args) {
        return this.convertToArgumentList(type, allowNullEntries, args.toArray(new String[0]));
    }

    public List<Pair<String, String>> convertToArgumentList(ArgumentType type, List<String> args) {
        return this.convertToArgumentList(type, true, args);
    }

    public void syncPlaceholders() {
        this.generalArgs.clear();
        this.modsArgs.clear();
        this.playerInfoArgs.clear();
        this.modsArgs.add(new Pair<String, String>("&MODCOUNT&", Integer.toString(FileUtils.getModCount())));
        this.playerInfoArgs.add(new Pair<String, String>("&NAME&", CraftPresence.session.func_111285_a()));
        String uniqueId = CraftPresence.session.func_148255_b();
        this.playerInfoArgs.add(new Pair<String, String>("&UUID&", StringUtils.getFromUuid(uniqueId, true)));
        this.playerInfoArgs.add(new Pair<String, String>("&UUID_FULL&", StringUtils.getFromUuid(uniqueId, false)));
        this.generalArgs.add(new Pair<String, String>("&MCVERSION&", ModUtils.TRANSLATOR.translate("craftpresence.defaults.state.mc.version", ModUtils.MCVersion)));
        this.generalArgs.add(new Pair<String, String>("&BRAND&", ModUtils.BRAND));
        this.generalArgs.add(new Pair<String, String>("&MODS&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.modsPlaceholderMessage, this.modsArgs)));
        this.generalArgs.add(new Pair<String, String>("&IGN&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.outerPlayerPlaceholderMessage, this.playerInfoArgs)));
        for (Pair<String, String> generalArgument : this.generalArgs) {
            this.syncArgument(generalArgument.getFirst(), generalArgument.getSecond(), ArgumentType.Text);
        }
        for (Pair<String, String> argumentData : this.modsArgs) {
            this.syncArgument("&MODS:" + argumentData.getFirst().substring(1), argumentData.getSecond(), ArgumentType.Text);
        }
        for (Pair<String, String> argumentData : this.playerInfoArgs) {
            this.syncArgument("&IGN:" + argumentData.getFirst().substring(1), argumentData.getSecond(), ArgumentType.Text);
        }
        this.syncArgument("&DEFAULT&", CraftPresence.CONFIG.defaultIcon, ArgumentType.Image);
        this.syncPackArguments();
    }

    public void updatePresence(RichPresence presence) {
        if (!(presence == null || this.currentPresence != null && presence.toJson().toString().equals(this.currentPresence.toJson().toString()) || this.ipcInstance.getStatus() != PipeStatus.CONNECTED)) {
            this.ipcInstance.sendRichPresence(presence);
            this.currentPresence = presence;
        }
    }

    public String imageOf(boolean allowNull, boolean showLogging, String ... evalStrings) {
        String result;
        if (DiscordAssetUtils.syncCompleted && !StringUtils.isNullOrEmpty(evalStrings[0])) {
            String primaryKey = evalStrings[0];
            if (!this.cachedImageData.containsKey(primaryKey)) {
                String defaultIcon;
                String finalKey = defaultIcon = allowNull ? "" : (DiscordAssetUtils.contains(CraftPresence.CONFIG.defaultIcon) ? CraftPresence.CONFIG.defaultIcon : DiscordAssetUtils.getRandomAssetName());
                int i = 0;
                while (i < evalStrings.length) {
                    String evalString = evalStrings[i];
                    if (DiscordAssetUtils.contains(evalString)) {
                        if (showLogging && !evalString.equals(primaryKey)) {
                            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.fallback", primaryKey, evalString), new Object[0]);
                        }
                        finalKey = evalString;
                        break;
                    }
                    if (i++ < evalStrings.length) {
                        if (!showLogging) continue;
                        ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.fallback", evalString, evalStrings[i]), new Object[0]);
                        if (!evalString.equals(primaryKey)) continue;
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.request", evalString), new Object[0]);
                        continue;
                    }
                    if (showLogging) {
                        ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.default", primaryKey, defaultIcon), new Object[0]);
                    }
                    finalKey = defaultIcon;
                }
                this.cachedImageData.put(primaryKey, finalKey);
                result = finalKey;
            } else {
                result = this.cachedImageData.get(primaryKey);
                if ((StringUtils.isNullOrEmpty(this.lastRequestedImageData.getFirst()) || !this.lastRequestedImageData.getFirst().equals(primaryKey)) && showLogging && !result.equals(primaryKey)) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.error.discord.assets.cached", primaryKey, result), new Object[0]);
                    ModUtils.LOG.info(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.discord.assets.request", primaryKey), new Object[0]);
                }
            }
            this.lastRequestedImageData.setFirst(primaryKey);
            this.lastRequestedImageData.setSecond(result);
        } else {
            result = "";
        }
        return result;
    }

    public String imageOf(String argumentName, boolean allowNull, String ... evalStrings) {
        return this.imageOf(allowNull, this.isImageInUse(argumentName) || this.isImageInUse(evalStrings), evalStrings);
    }

    public String imageOf(boolean allowNull, String ... evalStrings) {
        return this.imageOf(allowNull, true, evalStrings);
    }

    public boolean isImageInUse(String ... evalStrings) {
        for (String evalString : evalStrings) {
            if (!CraftPresence.CONFIG.largeImageKey.contains(evalString) && !CraftPresence.CONFIG.smallImageKey.contains(evalString)) continue;
            return true;
        }
        return false;
    }

    public void clearPartyData(boolean clearRequesterData, boolean updateRPC) {
        if (clearRequesterData) {
            this.awaitingReply = false;
            this.REQUESTER_USER = null;
            CraftPresence.SYSTEM.TIMER = 0;
        }
        this.JOIN_SECRET = null;
        this.PARTY_ID = null;
        this.PARTY_SIZE = 0;
        this.PARTY_MAX = 0;
        if (updateRPC) {
            this.updatePresence(this.buildRichPresence());
        }
    }

    public void clearPresenceData(Tuple<Boolean, Boolean, Boolean> partyClearArgs) {
        this.GAME_STATE = "";
        this.DETAILS = "";
        this.LARGE_IMAGE_ASSET = null;
        this.LARGE_IMAGE_KEY = "";
        this.LARGE_IMAGE_TEXT = "";
        this.SMALL_IMAGE_ASSET = null;
        this.SMALL_IMAGE_KEY = "";
        this.SMALL_IMAGE_TEXT = "";
        this.BUTTONS = new JsonArray();
        if (partyClearArgs.getFirst().booleanValue()) {
            this.clearPartyData(partyClearArgs.getSecond(), partyClearArgs.getThird());
        }
    }

    public synchronized void shutDown() {
        if (CraftPresence.SYSTEM.HAS_LOADED) {
            try {
                this.ipcInstance.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            this.STATUS = DiscordStatus.Disconnected;
            this.currentPresence = null;
            this.clearPresenceData(new Tuple<Boolean, Boolean, Boolean>(true, true, false));
            this.CURRENT_USER = null;
            this.lastRequestedImageData = new Pair();
            this.cachedImageData.clear();
            CraftPresence.DIMENSIONS.clearClientData();
            CraftPresence.TILE_ENTITIES.clearClientData();
            CraftPresence.ENTITIES.clearClientData();
            CraftPresence.BIOMES.clearClientData();
            CraftPresence.SERVER.clearClientData();
            CraftPresence.GUIS.clearClientData();
            CraftPresence.SYSTEM.HAS_LOADED = false;
            ModUtils.LOG.info(ModUtils.TRANSLATOR.translate("craftpresence.logger.info.shutdown", new Object[0]), new Object[0]);
        }
    }

    public RichPresence buildRichPresence() {
        this.DETAILS = StringUtils.formatWord(this.parseArgumentOperators(CraftPresence.CONFIG.detailsMessage, ArgumentType.Text), !CraftPresence.CONFIG.formatWords, true, 1);
        this.GAME_STATE = StringUtils.formatWord(this.parseArgumentOperators(CraftPresence.CONFIG.gameStateMessage, ArgumentType.Text), !CraftPresence.CONFIG.formatWords, true, 1);
        this.LARGE_IMAGE_ASSET = DiscordAssetUtils.get(this.parseArgumentOperators(CraftPresence.CONFIG.largeImageKey, ArgumentType.Image));
        this.SMALL_IMAGE_ASSET = DiscordAssetUtils.get(this.parseArgumentOperators(CraftPresence.CONFIG.smallImageKey, ArgumentType.Image));
        String string = this.LARGE_IMAGE_ASSET != null ? (this.LARGE_IMAGE_ASSET.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.parseArgumentOperators(this.LARGE_IMAGE_ASSET.getUrl(), ArgumentType.Text) : this.LARGE_IMAGE_ASSET.getName()) : (this.LARGE_IMAGE_KEY = "");
        this.SMALL_IMAGE_KEY = this.SMALL_IMAGE_ASSET != null ? (this.SMALL_IMAGE_ASSET.getType().equals((Object)DiscordAsset.AssetType.CUSTOM) ? this.parseArgumentOperators(this.SMALL_IMAGE_ASSET.getUrl(), ArgumentType.Text) : this.SMALL_IMAGE_ASSET.getName()) : "";
        this.LARGE_IMAGE_TEXT = StringUtils.formatWord(this.parseArgumentOperators(CraftPresence.CONFIG.largeImageMessage, ArgumentType.Text), !CraftPresence.CONFIG.formatWords, true, 1);
        this.SMALL_IMAGE_TEXT = StringUtils.formatWord(this.parseArgumentOperators(CraftPresence.CONFIG.smallImageMessage, ArgumentType.Text), !CraftPresence.CONFIG.formatWords, true, 1);
        this.BUTTONS = new JsonArray();
        for (String buttonElement : CraftPresence.CONFIG.buttonMessages) {
            if (StringUtils.isNullOrEmpty(buttonElement)) continue;
            String[] part = buttonElement.split(CraftPresence.CONFIG.splitCharacter);
            JsonObject buttonObj = new JsonObject();
            if (part.length != 3 || StringUtils.isNullOrEmpty(part[0]) || part[0].equalsIgnoreCase("default") || StringUtils.isNullOrEmpty(part[1])) continue;
            String label = StringUtils.formatWord(this.parseArgumentOperators(part[1], ArgumentType.Text), !CraftPresence.CONFIG.formatWords, true, 1);
            String url = !StringUtils.isNullOrEmpty(part[2]) ? this.parseArgumentOperators(part[2], ArgumentType.Text) : "";
            label = this.sanitizePlaceholders(label);
            url = this.sanitizePlaceholders(url);
            if (StringUtils.isNullOrEmpty(label) || StringUtils.isNullOrEmpty(url)) continue;
            buttonObj.addProperty("label", label);
            buttonObj.addProperty("url", url);
            this.BUTTONS.add((JsonElement)buttonObj);
        }
        this.GAME_STATE = this.sanitizePlaceholders(this.GAME_STATE);
        this.DETAILS = this.sanitizePlaceholders(this.DETAILS);
        this.LARGE_IMAGE_KEY = this.sanitizePlaceholders(this.LARGE_IMAGE_KEY);
        this.LARGE_IMAGE_TEXT = this.sanitizePlaceholders(this.LARGE_IMAGE_TEXT);
        this.SMALL_IMAGE_KEY = this.sanitizePlaceholders(this.SMALL_IMAGE_KEY);
        this.SMALL_IMAGE_TEXT = this.sanitizePlaceholders(this.SMALL_IMAGE_TEXT);
        RichPresence newRPCData = new RichPresence.Builder().setState(this.GAME_STATE).setDetails(this.DETAILS).setStartTimestamp(this.START_TIMESTAMP).setEndTimestamp(this.END_TIMESTAMP).setLargeImage(this.LARGE_IMAGE_KEY, this.LARGE_IMAGE_TEXT).setSmallImage(this.SMALL_IMAGE_KEY, this.SMALL_IMAGE_TEXT).setParty(this.PARTY_ID, this.PARTY_SIZE, this.PARTY_MAX, this.PARTY_PRIVACY.ordinal()).setMatchSecret(this.MATCH_SECRET).setJoinSecret(this.JOIN_SECRET).setSpectateSecret(this.SPECTATE_SECRET).setButtons(this.BUTTONS).build();
        this.GAME_STATE = StringUtils.getConvertedString(this.GAME_STATE, "UTF-8", false);
        this.DETAILS = StringUtils.getConvertedString(this.DETAILS, "UTF-8", false);
        this.LARGE_IMAGE_KEY = StringUtils.getConvertedString(this.LARGE_IMAGE_KEY, "UTF-8", false);
        this.SMALL_IMAGE_KEY = StringUtils.getConvertedString(this.SMALL_IMAGE_KEY, "UTF-8", false);
        this.LARGE_IMAGE_TEXT = StringUtils.getConvertedString(this.LARGE_IMAGE_TEXT, "UTF-8", false);
        this.SMALL_IMAGE_TEXT = StringUtils.getConvertedString(this.SMALL_IMAGE_TEXT, "UTF-8", false);
        return newRPCData;
    }
}

