/*
 * Decompiled with CFR 0.152.
 */
package forge.com.gitlab.cdagaming.craftpresence.config.gui;

import com.google.common.collect.Lists;
import forge.com.gitlab.cdagaming.craftpresence.CraftPresence;
import forge.com.gitlab.cdagaming.craftpresence.ModUtils;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.AboutGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.AccessibilitySettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.AdvancedSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.BiomeSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.DimensionSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.GeneralSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.PresenceSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.ServerSettingsGui;
import forge.com.gitlab.cdagaming.craftpresence.config.gui.StatusMessagesGui;
import forge.com.gitlab.cdagaming.craftpresence.impl.Pair;
import forge.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import forge.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import forge.com.gitlab.cdagaming.craftpresence.utils.commands.CommandsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedButtonControl;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.impl.ControlsGui;
import forge.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.ExtendedScreen;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;

public class MainGui
extends ExtendedScreen {
    private ExtendedButtonControl biomeSet;
    private ExtendedButtonControl dimensionSet;
    private ExtendedButtonControl serverSet;
    private ExtendedButtonControl controlsButton;
    private ExtendedButtonControl proceedButton;
    private ExtendedButtonControl commandGUIButton;

    public MainGui(Screen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void initializeUi() {
        KeyUtils.FilterMode controlMode;
        CraftPresence.GUIS.configGUIOpened = true;
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(1), 180, 20, "gui.config.title.general", () -> CraftPresence.GUIS.openScreen(new GeneralSettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.general", new Object[0])), this, true), new String[0]));
        this.biomeSet = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(1), 180, 20, "gui.config.title.biome_messages", () -> CraftPresence.GUIS.openScreen(new BiomeSettingsGui(this.currentScreen)), () -> {
            if (!this.biomeSet.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_biome_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.biome_messages.biome_messages", CraftPresence.BIOMES.generateArgumentMessage(new ArgumentType[0]))), this, true);
            }
        }, new String[0]));
        this.dimensionSet = this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(2), 180, 20, "gui.config.title.dimension_messages", () -> CraftPresence.GUIS.openScreen(new DimensionSettingsGui(this.currentScreen)), () -> {
            if (!this.dimensionSet.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_dimension_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.dimension_messages.dimension_messages", CraftPresence.DIMENSIONS.generateArgumentMessage(new ArgumentType[0]))), this, true);
            }
        }, new String[0]));
        this.serverSet = this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(2), 180, 20, "gui.config.title.server_messages", () -> CraftPresence.GUIS.openScreen(new ServerSettingsGui(this.currentScreen)), () -> {
            if (!this.serverSet.isControlEnabled()) {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.message.hover.access", ModUtils.TRANSLATOR.translate("gui.config.name.general.detect_world_data", new Object[0]))), this, true);
            } else {
                CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.server_messages.server_messages", CraftPresence.SERVER.generateArgumentMessage(new ArgumentType[0]))), this, true);
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(3), 180, 20, "gui.config.title.status_messages", () -> CraftPresence.GUIS.openScreen(new StatusMessagesGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.status_messages", new Object[0])), this, true), new String[0]));
        this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(3), 180, 20, "gui.config.title.advanced", () -> CraftPresence.GUIS.openScreen(new AdvancedSettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.advanced", new Object[0])), this, true), new String[0]));
        this.addControl(new ExtendedButtonControl(calc1, CraftPresence.GUIS.getButtonY(4), 180, 20, "gui.config.title.accessibility", () -> CraftPresence.GUIS.openScreen(new AccessibilitySettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title.accessibility", new Object[0])), this, true), new String[0]));
        this.addControl(new ExtendedButtonControl(calc2, CraftPresence.GUIS.getButtonY(4), 180, 20, "gui.config.title.presence_settings", () -> CraftPresence.GUIS.openScreen(new PresenceSettingsGui(this.currentScreen)), () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.presence_settings", new Object[0])), this, true), new String[0]));
        ArrayList controlInfo = Lists.newArrayList((Object[])new String[]{"key.craftpresence.category"});
        KeyUtils.FilterMode finalControlMode = controlMode = KeyUtils.FilterMode.Category;
        this.controlsButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 55, 180, 20, "gui.config.message.button.controls", () -> CraftPresence.GUIS.openScreen(new ControlsGui(this.currentScreen, finalControlMode, controlInfo)), new String[0]));
        this.proceedButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() / 2 - 90, this.getScreenHeight() - 30, 180, 20, "gui.config.message.button.back", () -> {
            if (CraftPresence.CONFIG.hasChanged) {
                CraftPresence.CONFIG.updateConfig(false);
                CraftPresence.CONFIG.read(false, "UTF-8");
                if (CraftPresence.CONFIG.hasClientPropertiesChanged) {
                    CommandUtils.rebootRPC(CraftPresence.CONFIG.flushClientProperties);
                    CraftPresence.CONFIG.hasClientPropertiesChanged = false;
                }
                CommandUtils.reloadData(true);
                CraftPresence.CONFIG.flushClientProperties = false;
                CraftPresence.CONFIG.hasChanged = false;
            }
            CraftPresence.GUIS.configGUIOpened = false;
            if (this.field_230706_i_.field_71439_g != null) {
                this.field_230706_i_.field_71439_g.func_71053_j();
            } else {
                CraftPresence.GUIS.openScreen(this.parentScreen);
            }
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 105, this.getScreenHeight() - 55, 95, 20, "gui.config.message.button.about", () -> CraftPresence.GUIS.openScreen(new AboutGui(this.currentScreen)), new String[0]));
        this.commandGUIButton = this.addControl(new ExtendedButtonControl(this.getScreenWidth() - 105, this.getScreenHeight() - 30, 95, 20, "gui.config.message.button.commands", () -> CraftPresence.GUIS.openScreen(new CommandsGui(this.currentScreen)), new String[0]));
        this.addControl(new ExtendedButtonControl(10, this.getScreenHeight() - 30, 95, 20, "gui.config.message.button.reset", () -> {
            CraftPresence.CONFIG.setupInitialValues();
            CraftPresence.CONFIG.hasChanged = true;
            CraftPresence.CONFIG.hasClientPropertiesChanged = true;
            CraftPresence.CONFIG.flushClientProperties = true;
            this.syncRenderStates();
        }, new String[0]));
        this.addControl(new ExtendedButtonControl(10, this.getScreenHeight() - 55, 95, 20, "gui.config.message.button.sync.config", () -> {
            List<Pair<String, Object>> currentConfigDataMappings = CraftPresence.CONFIG.configDataMappings;
            CraftPresence.CONFIG.read(false, "UTF-8");
            if (!CraftPresence.CONFIG.configDataMappings.equals(currentConfigDataMappings)) {
                CraftPresence.CONFIG.hasChanged = true;
                CraftPresence.CONFIG.hasClientPropertiesChanged = true;
                CraftPresence.CONFIG.flushClientProperties = true;
                this.syncRenderStates();
            }
        }, () -> CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.button.sync.config", new Object[0])), this, true), new String[0]));
        super.initializeUi();
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        String releaseNotice = ModUtils.TRANSLATOR.translate("gui.config.message.tentative", ModUtils.VERSION_ID + " - " + StringUtils.formatWord(ModUtils.VERSION_LABEL));
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 15.0f, 0xFFFFFF);
        if (!ModUtils.VERSION_TYPE.equalsIgnoreCase("release")) {
            this.renderString(releaseNotice, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(releaseNotice) / 2.0f, this.getScreenHeight() - 85, 0xFFFFFF);
        }
        this.syncRenderStates();
    }

    @Override
    public void postRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title", new Object[0]);
        if (CraftPresence.GUIS.isMouseOver(this.getMouseX(), this.getMouseY(), (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 15.0, this.getStringWidth(mainTitle), this.getFontHeight())) {
            CraftPresence.GUIS.drawMultiLineString(StringUtils.splitTextByNewLine(ModUtils.TRANSLATOR.translate("gui.config.comment.title", ModUtils.VERSION_ID, 2)), this, true);
        }
    }

    @Override
    public boolean func_231046_a_(int keyCode, int mouseX, int mouseY) {
        if (keyCode == 256) {
            if (CraftPresence.CONFIG.hasChanged || CraftPresence.CONFIG.hasClientPropertiesChanged || CraftPresence.CONFIG.flushClientProperties) {
                CraftPresence.CONFIG.setupInitialValues();
                CraftPresence.CONFIG.read(false, "UTF-8");
                CraftPresence.CONFIG.hasChanged = false;
                CraftPresence.CONFIG.hasClientPropertiesChanged = false;
                CraftPresence.CONFIG.flushClientProperties = false;
            }
            CraftPresence.GUIS.configGUIOpened = false;
        }
        return super.func_231046_a_(keyCode, mouseX, mouseY);
    }

    private void syncRenderStates() {
        this.biomeSet.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectBiomeData : this.biomeSet.isControlEnabled());
        this.dimensionSet.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectDimensionData : this.dimensionSet.isControlEnabled());
        this.serverSet.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectWorldData : this.serverSet.isControlEnabled());
        this.commandGUIButton.setControlEnabled(!CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.enableCommands : this.commandGUIButton.isControlEnabled());
        this.controlsButton.setControlEnabled(CraftPresence.KEYBINDINGS.areKeysRegistered());
        this.proceedButton.setControlMessage(CraftPresence.CONFIG.hasChanged ? "gui.config.message.button.save" : "gui.config.message.button.back");
    }
}

