/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.PartyPrivacy;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_412;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_634;
import net.minecraft.class_640;
import net.minecraft.class_641;
import net.minecraft.class_642;

public class ServerUtils {
    private final String argumentFormat = "&SERVER&";
    private final String subArgumentFormat = "&SERVER:";
    private final List<Pair<String, String>> serverArgs = Lists.newArrayList();
    private final List<Pair<String, String>> iconArgs = Lists.newArrayList();
    private final List<Pair<String, String>> playerDataArgs = Lists.newArrayList();
    private final List<Pair<String, String>> playerAmountArgs = Lists.newArrayList();
    private final List<Pair<String, String>> worldDataArgs = Lists.newArrayList();
    private final List<Pair<String, String>> coordinateArgs = Lists.newArrayList();
    private final List<Pair<String, String>> healthArgs = Lists.newArrayList();
    private final Map<String, List<Pair<String, String>>> subArgumentData = Maps.newHashMap();
    public boolean isInUse = false;
    public boolean enabled = false;
    public List<class_640> currentPlayerList = Lists.newArrayList();
    public List<String> knownAddresses = Lists.newArrayList();
    public Map<String, class_642> knownServerData = Maps.newHashMap();
    private String currentServer_IP;
    private String currentServer_Name;
    private String currentServer_MOTD;
    private String currentServerMessage = "";
    private String currentServerIcon = "";
    private String timeString;
    private String dayString;
    private String currentDifficulty;
    private String currentWorldName;
    private int currentPlayers;
    private int maxPlayers;
    private int serverIndex;
    private Tuple<Double, Double, Double> currentCoordinates = new Tuple<Double, Double, Double>(0.0, 0.0, 0.0);
    private Pair<Double, Double> currentHealth = new Pair<Double, Double>(0.0, 0.0);
    private class_642 currentServerData;
    private class_642 requestedServerData;
    private class_634 currentConnection;
    private boolean queuedForUpdate = false;
    private boolean joinInProgress = false;
    private boolean isOnLAN = false;

    private void emptyData() {
        this.currentPlayerList.clear();
        this.knownAddresses.clear();
        this.knownServerData.clear();
        this.clearClientData();
    }

    public void clearClientData() {
        this.currentServer_IP = null;
        this.currentServer_MOTD = null;
        this.currentServer_Name = null;
        this.currentServerData = null;
        this.currentConnection = null;
        this.currentCoordinates = new Tuple<Double, Double, Double>(0.0, 0.0, 0.0);
        this.currentHealth = new Pair<Double, Double>(0.0, 0.0);
        this.currentDifficulty = null;
        this.currentWorldName = null;
        this.currentServerMessage = "";
        this.currentServerIcon = "";
        this.timeString = null;
        this.dayString = null;
        this.currentPlayers = 0;
        this.maxPlayers = 0;
        this.serverArgs.clear();
        this.iconArgs.clear();
        this.playerDataArgs.clear();
        this.playerAmountArgs.clear();
        this.worldDataArgs.clear();
        this.coordinateArgs.clear();
        this.healthArgs.clear();
        this.queuedForUpdate = false;
        this.isOnLAN = false;
        this.isInUse = false;
        if (!this.joinInProgress) {
            this.requestedServerData = null;
        }
        for (String entry : this.subArgumentData.keySet()) {
            CraftPresence.CLIENT.removeArgumentsMatching(entry);
        }
        this.subArgumentData.clear();
        CraftPresence.CLIENT.initArgument("&SERVER&");
        CraftPresence.CLIENT.clearPartyData(true, false);
    }

    public void onTick() {
        boolean needsUpdate;
        this.joinInProgress = CraftPresence.CLIENT.STATUS == DiscordStatus.JoinGame || CraftPresence.CLIENT.STATUS == DiscordStatus.SpectateGame;
        this.enabled = !CraftPresence.CONFIG.hasChanged ? CraftPresence.CONFIG.detectWorldData : this.enabled;
        boolean bl = needsUpdate = this.enabled && this.knownAddresses.isEmpty();
        if (needsUpdate) {
            this.getServerAddresses();
        }
        if (this.enabled) {
            if (CraftPresence.player != null && !this.joinInProgress) {
                this.isInUse = true;
                this.updateServerData();
            } else if (this.isInUse) {
                this.clearClientData();
            }
        } else if (this.isInUse) {
            this.emptyData();
        }
        if (this.joinInProgress && this.requestedServerData != null) {
            CraftPresence.instance.execute(() -> this.joinServer(this.requestedServerData));
        }
    }

    private void updateServerData() {
        class_642 newServerData = CraftPresence.instance.method_1558();
        class_634 newConnection = CraftPresence.instance.method_1562();
        if (!this.joinInProgress) {
            String newServer_MOTD;
            int newMaxPlayers;
            int newCurrentPlayers;
            ArrayList newPlayerList = newConnection != null ? Lists.newArrayList((Iterable)newConnection.method_2880()) : Lists.newArrayList();
            int n = newCurrentPlayers = newConnection != null ? newConnection.method_2880().size() : 1;
            if (newServerData != null) {
                try {
                    newMaxPlayers = StringUtils.getValidInteger(StringUtils.stripColors(newServerData.field_3753.getString()).split("/")[1]).getSecond();
                    if (newMaxPlayers < newCurrentPlayers) {
                        newMaxPlayers = newCurrentPlayers + 1;
                    }
                }
                catch (Exception ex) {
                    newMaxPlayers = newCurrentPlayers + 1;
                }
            } else {
                newMaxPlayers = newCurrentPlayers + 1;
            }
            boolean newLANStatus = CraftPresence.instance.method_1542() && newCurrentPlayers > 1 || newServerData != null && newServerData.method_2994();
            boolean isMotdValid = newServerData != null && newServerData.field_3757 != null && !StringUtils.isNullOrEmpty(newServerData.field_3757.getString());
            String newServer_IP = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.field_3761) ? newServerData.field_3761 : "127.0.0.1";
            String newServer_Name = newServerData != null && !StringUtils.isNullOrEmpty(newServerData.field_3752) ? newServerData.field_3752 : CraftPresence.CONFIG.defaultServerName;
            String string = newServer_MOTD = !this.isOnLAN && !CraftPresence.instance.method_1542() && newServerData != null && isMotdValid && !newServerData.field_3757.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_connect", new Object[0])) && !newServerData.field_3757.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.cannot_resolve", new Object[0])) && !newServerData.field_3757.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.polling", new Object[0])) && !newServerData.field_3757.getString().equalsIgnoreCase(ModUtils.TRANSLATOR.translate("craftpresence.multiplayer.status.pinging", new Object[0])) ? StringUtils.stripColors(newServerData.field_3757.getString()) : CraftPresence.CONFIG.defaultServerMotd;
            if (newLANStatus != this.isOnLAN || newServerData != null && !newServerData.equals(this.currentServerData) || newServerData == null && this.currentServerData != null || newConnection != null && !newConnection.equals(this.currentConnection) || !newServer_IP.equals(this.currentServer_IP) || !StringUtils.isNullOrEmpty(newServer_MOTD) && !newServer_MOTD.equals(this.currentServer_MOTD) || !StringUtils.isNullOrEmpty(newServer_Name) && !newServer_Name.equals(this.currentServer_Name)) {
                this.currentServer_IP = newServer_IP;
                this.currentServer_MOTD = newServer_MOTD;
                this.currentServer_Name = newServer_Name;
                this.currentServerData = newServerData;
                this.currentConnection = newConnection;
                this.isOnLAN = newLANStatus;
                this.queuedForUpdate = true;
                if (!StringUtils.isNullOrEmpty(this.currentServer_IP) && !this.knownAddresses.contains(this.currentServer_IP.contains(":") ? this.currentServer_IP : StringUtils.formatAddress(this.currentServer_IP, false))) {
                    this.knownAddresses.add(this.currentServer_IP.contains(":") ? this.currentServer_IP : StringUtils.formatAddress(this.currentServer_IP, false));
                }
                class_641 serverList = new class_641(CraftPresence.instance);
                serverList.method_2981();
                if (serverList.method_2984() != this.serverIndex || CraftPresence.CONFIG.serverMessages.length != this.serverIndex) {
                    this.getServerAddresses();
                }
            }
            List<String> matchingArgs = CraftPresence.CLIENT.getArgumentEntries(ArgumentType.Text, true, "&SERVER:");
            if (!StringUtils.isNullOrEmpty(this.currentServerMessage) || !matchingArgs.isEmpty()) {
                String item = "&playerinfo&";
                String subItem = "&SERVER:" + item.substring(1);
                if (this.currentServerMessage.toLowerCase().contains(item) || matchingArgs.contains(subItem.toLowerCase())) {
                    if (CraftPresence.CONFIG.innerPlayerPlaceholderMessage.toLowerCase().contains("&coords&")) {
                        double newX = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.method_23317() : 0.0, CraftPresence.CONFIG.roundSize);
                        double newY = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.method_23318() : 0.0, CraftPresence.CONFIG.roundSize);
                        double newZ = StringUtils.roundDouble(CraftPresence.player != null ? CraftPresence.player.method_23321() : 0.0, CraftPresence.CONFIG.roundSize);
                        Tuple<Double, Double, Double> newCoordinates = new Tuple<Double, Double, Double>(newX, newY, newZ);
                        if (!newCoordinates.equals(this.currentCoordinates)) {
                            this.currentCoordinates = newCoordinates;
                            this.queuedForUpdate = true;
                        }
                    }
                    if (CraftPresence.CONFIG.innerPlayerPlaceholderMessage.toLowerCase().contains("&health&")) {
                        Pair<Double, Double> newHealth;
                        Pair<Double, Double> pair = newHealth = CraftPresence.player != null ? new Pair<Double, Double>(StringUtils.roundDouble(CraftPresence.player.method_6032(), 0), StringUtils.roundDouble(CraftPresence.player.method_6063(), 0)) : new Pair<Double, Double>(0.0, 0.0);
                        if (!newHealth.equals(this.currentHealth)) {
                            this.currentHealth = newHealth;
                            this.queuedForUpdate = true;
                        }
                    }
                }
                item = "&worldinfo&";
                subItem = "&SERVER:" + item.substring(1);
                if (this.currentServerMessage.toLowerCase().contains(item) || matchingArgs.contains(subItem.toLowerCase())) {
                    if (CraftPresence.CONFIG.worldPlaceholderMessage.toLowerCase().contains("&difficulty&")) {
                        String newDifficulty;
                        String string2 = CraftPresence.player != null ? (CraftPresence.player.field_6002.method_8401().method_152() ? ModUtils.TRANSLATOR.translate("craftpresence.defaults.mode.hardcore", new Object[0]) : CraftPresence.player.field_6002.method_8407().name()) : (newDifficulty = "");
                        if (!newDifficulty.equals(this.currentDifficulty)) {
                            this.currentDifficulty = newDifficulty;
                            this.queuedForUpdate = true;
                        }
                    }
                    if (CraftPresence.CONFIG.worldPlaceholderMessage.toLowerCase().contains("&worldname&")) {
                        String newWorldName;
                        String primaryWorldName = CraftPresence.instance.method_1576() != null ? CraftPresence.instance.method_1576().method_27728().method_150() : "";
                        String secondaryWorldName = CraftPresence.player != null && CraftPresence.player.field_6002 != null && CraftPresence.player.field_6002.method_8503() != null ? CraftPresence.player.field_6002.method_8503().method_27728().method_150() : ModUtils.TRANSLATOR.translate("craftpresence.defaults.world_name", new Object[0]);
                        String string3 = newWorldName = !StringUtils.isNullOrEmpty(primaryWorldName) ? primaryWorldName : secondaryWorldName;
                        if (!newWorldName.equals(this.currentWorldName)) {
                            this.currentWorldName = newWorldName;
                            this.queuedForUpdate = true;
                        }
                    }
                    if (CraftPresence.CONFIG.worldPlaceholderMessage.toLowerCase().contains("&worldtime&")) {
                        String newGameTime;
                        String string4 = newGameTime = CraftPresence.player != null ? this.getTimeString(CraftPresence.player.field_6002.method_8532()) : null;
                        if (!StringUtils.isNullOrEmpty(newGameTime) && !newGameTime.equals(this.timeString)) {
                            this.timeString = newGameTime;
                            this.queuedForUpdate = true;
                        }
                    }
                    if (CraftPresence.CONFIG.worldPlaceholderMessage.toLowerCase().contains("&worldday&")) {
                        String newGameDay;
                        String string5 = newGameDay = CraftPresence.player != null ? String.format("%d", CraftPresence.player.field_6002.method_8532() / 24000L) : null;
                        if (!StringUtils.isNullOrEmpty(newGameDay) && !newGameDay.equals(this.dayString)) {
                            this.dayString = newGameDay;
                            this.queuedForUpdate = true;
                        }
                    }
                }
                item = "&players&";
                subItem = "&SERVER:" + item.substring(1);
                if ((this.currentServerMessage.toLowerCase().contains(item) || matchingArgs.contains(subItem.toLowerCase()) || CraftPresence.CONFIG.enableJoinRequest) && (newCurrentPlayers != this.currentPlayers || newMaxPlayers != this.maxPlayers)) {
                    this.currentPlayers = newCurrentPlayers;
                    this.maxPlayers = newMaxPlayers;
                    this.queuedForUpdate = true;
                }
            }
            if (!newPlayerList.equals(this.currentPlayerList)) {
                this.currentPlayerList = newPlayerList;
                if (CraftPresence.ENTITIES.enabled) {
                    CraftPresence.ENTITIES.getEntities();
                }
            }
        }
        if (this.queuedForUpdate) {
            this.updateServerPresence();
        }
    }

    private String getTimeString(long worldTime) {
        long remainingTicks;
        long hour = 0L;
        long minute = 0L;
        long dayLength = 24000L;
        for (remainingTicks = worldTime % dayLength; remainingTicks >= 1000L; remainingTicks -= 1000L) {
            if (++hour <= 24L) continue;
            hour -= 24L;
        }
        remainingTicks *= 3L;
        while (remainingTicks >= 50L) {
            remainingTicks -= 50L;
            ++minute;
        }
        String formattedHour = String.valueOf(hour).length() == 1 ? String.format("%02d", hour) : String.valueOf(hour);
        String formattedMinute = String.valueOf(minute).length() == 1 ? String.format("%02d", minute) : String.valueOf(minute);
        return formattedHour + ":" + formattedMinute;
    }

    private String makeSecret() {
        String formattedKey = CraftPresence.CLIENT.CLIENT_ID + "";
        boolean containsServerName = false;
        boolean containsServerIP = false;
        if (!StringUtils.isNullOrEmpty(this.currentServer_Name)) {
            formattedKey = formattedKey + "-" + this.currentServer_Name.toLowerCase();
            containsServerName = true;
        }
        if (!StringUtils.isNullOrEmpty(this.currentServer_IP)) {
            formattedKey = formattedKey + "-" + this.currentServer_IP.toLowerCase();
            containsServerIP = true;
        }
        formattedKey = formattedKey + ";" + containsServerName + ";" + containsServerIP;
        return formattedKey;
    }

    public void verifyAndJoin(String secret) {
        boolean isValidSecret;
        String[] boolParts = secret.split(";");
        String[] stringParts = boolParts[0].split("-");
        boolean containsValidClientID = StringUtils.elementExists(stringParts, 0) && stringParts[0].length() >= 18 && StringUtils.getValidLong(stringParts[0]).getFirst() != false;
        boolean containsServerName = StringUtils.elementExists(boolParts, 1) && StringUtils.elementExists(stringParts, 1) && Boolean.parseBoolean(boolParts[1]);
        boolean containsServerIP = StringUtils.elementExists(boolParts, 2) && StringUtils.elementExists(stringParts, 2) && Boolean.parseBoolean(boolParts[2]);
        String serverName = containsServerName ? stringParts[1] : CraftPresence.CONFIG.defaultServerName;
        String serverIP = containsServerIP ? stringParts[2] : "";
        boolean bl = isValidSecret = boolParts.length <= 4 && stringParts.length <= 3 && containsValidClientID;
        if (isValidSecret) {
            if (CraftPresence.CONFIG.enableJoinRequest) {
                this.requestedServerData = new class_642(serverName, serverIP, false);
            } else {
                ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.warning.config.disabled.enable_join_request", new Object[0]), new Object[0]);
            }
        } else {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.discord.join", secret), new Object[0]);
        }
    }

    private void joinServer(class_642 serverData) {
        try {
            if (CraftPresence.player != null) {
                CraftPresence.player.field_6002.method_8525();
                CraftPresence.instance.method_18096(null);
            }
            CraftPresence.instance.method_1507((class_437)new class_412((class_437)(CraftPresence.instance.field_1755 != null ? CraftPresence.instance.field_1755 : new class_442()), CraftPresence.instance, serverData));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            this.requestedServerData = null;
        }
    }

    public void updateServerPresence() {
        this.serverArgs.clear();
        this.iconArgs.clear();
        this.playerDataArgs.clear();
        this.worldDataArgs.clear();
        this.coordinateArgs.clear();
        this.healthArgs.clear();
        for (String string : this.subArgumentData.keySet()) {
            CraftPresence.CLIENT.removeArgumentsMatching(string);
        }
        this.subArgumentData.clear();
        this.coordinateArgs.add(new Pair<String, String>("&xPosition&", this.currentCoordinates.getFirst().toString()));
        this.coordinateArgs.add(new Pair<String, String>("&yPosition&", this.currentCoordinates.getSecond().toString()));
        this.coordinateArgs.add(new Pair<String, String>("&zPosition&", this.currentCoordinates.getThird().toString()));
        this.healthArgs.add(new Pair<String, String>("&CURRENT&", this.currentHealth.getFirst().toString()));
        this.healthArgs.add(new Pair<String, String>("&MAX&", this.currentHealth.getSecond().toString()));
        this.playerDataArgs.add(new Pair<String, String>("&COORDS&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.playerCoordinatePlaceholderMessage, this.coordinateArgs)));
        this.playerDataArgs.add(new Pair<String, String>("&HEALTH&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.playerHealthPlaceholderMessage, this.healthArgs)));
        this.worldDataArgs.add(new Pair<String, String>("&DIFFICULTY&", !StringUtils.isNullOrEmpty(this.currentDifficulty) ? this.currentDifficulty : ""));
        this.worldDataArgs.add(new Pair<String, String>("&WORLDNAME&", !StringUtils.isNullOrEmpty(this.currentWorldName) ? this.currentWorldName : ""));
        this.worldDataArgs.add(new Pair<String, String>("&WORLDTIME&", !StringUtils.isNullOrEmpty(this.timeString) ? this.timeString : ""));
        this.worldDataArgs.add(new Pair<String, String>("&WORLDDAY&", !StringUtils.isNullOrEmpty(this.dayString) ? this.dayString : ""));
        this.serverArgs.add(new Pair<String, String>("&PLAYERINFO&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.innerPlayerPlaceholderMessage, this.playerDataArgs)));
        this.serverArgs.add(new Pair<String, String>("&WORLDINFO&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.worldPlaceholderMessage, this.worldDataArgs)));
        this.iconArgs.add(new Pair<String, String>("&ICON&", CraftPresence.CONFIG.defaultServerIcon));
        if (!CraftPresence.instance.method_1542() && this.currentServerData != null) {
            this.playerAmountArgs.clear();
            this.playerAmountArgs.add(new Pair<String, String>("&CURRENT&", Integer.toString(this.currentPlayers)));
            this.playerAmountArgs.add(new Pair<String, String>("&MAX&", Integer.toString(this.maxPlayers)));
            this.serverArgs.add(new Pair<String, String>("&IP&", StringUtils.formatAddress(this.currentServer_IP, false)));
            this.serverArgs.add(new Pair<String, String>("&NAME&", this.currentServer_Name));
            this.serverArgs.add(new Pair<String, String>("&MOTD&", this.currentServer_MOTD));
            this.serverArgs.add(new Pair<String, String>("&PLAYERS&", StringUtils.sequentialReplaceAnyCase(CraftPresence.CONFIG.playerAmountPlaceholderMessage, this.playerAmountArgs)));
            if (this.isOnLAN) {
                String alternateServerIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 2, CraftPresence.CONFIG.splitCharacter, this.currentServer_Name);
                String string = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, StringUtils.formatAddress(this.currentServer_IP, false), 0, 2, CraftPresence.CONFIG.splitCharacter, alternateServerIcon);
                String formattedServerIconKey = StringUtils.formatAsIcon(string.replace(" ", "_"));
                this.currentServerIcon = StringUtils.sequentialReplaceAnyCase(formattedServerIconKey, this.iconArgs);
                this.currentServerMessage = CraftPresence.CONFIG.lanMessage;
            } else {
                String defaultServerMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, "default", 0, 1, CraftPresence.CONFIG.splitCharacter, null);
                String string = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 1, CraftPresence.CONFIG.splitCharacter, defaultServerMessage);
                String alternateServerIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, this.currentServer_Name, 0, 2, CraftPresence.CONFIG.splitCharacter, this.currentServer_Name);
                this.currentServerMessage = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, StringUtils.formatAddress(this.currentServer_IP, false), 0, 1, CraftPresence.CONFIG.splitCharacter, string);
                String primaryServerIcon = StringUtils.getConfigPart(CraftPresence.CONFIG.serverMessages, StringUtils.formatAddress(this.currentServer_IP, false), 0, 2, CraftPresence.CONFIG.splitCharacter, alternateServerIcon);
                String formattedServerIconKey = StringUtils.formatAsIcon(primaryServerIcon.replace(" ", "_"));
                this.currentServerIcon = StringUtils.sequentialReplaceAnyCase(formattedServerIconKey, this.iconArgs);
                if (CraftPresence.CONFIG.enableJoinRequest) {
                    CraftPresence.CLIENT.PARTY_ID = !StringUtils.isNullOrEmpty(this.currentServer_Name) && !this.currentServer_Name.equalsIgnoreCase(CraftPresence.CONFIG.defaultServerName) ? "Join Server: " + this.currentServer_Name : "Join Server: " + this.currentServer_IP;
                    CraftPresence.CLIENT.JOIN_SECRET = this.makeSecret();
                    CraftPresence.CLIENT.PARTY_SIZE = this.currentPlayers;
                    CraftPresence.CLIENT.PARTY_MAX = this.maxPlayers;
                    CraftPresence.CLIENT.PARTY_PRIVACY = PartyPrivacy.from(CraftPresence.CONFIG.partyPrivacyLevel % 2);
                }
            }
        } else if (CraftPresence.instance.method_1542()) {
            this.currentServerMessage = CraftPresence.CONFIG.singlePlayerMessage;
            this.currentServerIcon = "";
        }
        this.subArgumentData.put("&SERVER:", this.serverArgs);
        this.subArgumentData.put("&SERVER:PLAYERINFO:", this.playerDataArgs);
        this.subArgumentData.put("&SERVER:PLAYERINFO:COORDS:", this.coordinateArgs);
        this.subArgumentData.put("&SERVER:PLAYERINFO:HEALTH:", this.healthArgs);
        this.subArgumentData.put("&SERVER:PLAYERS:", this.playerAmountArgs);
        this.subArgumentData.put("&SERVER:WORLDINFO:", this.worldDataArgs);
        for (Map.Entry entry : this.subArgumentData.entrySet()) {
            if (StringUtils.isNullOrEmpty((String)entry.getKey()) || ((List)entry.getValue()).isEmpty()) continue;
            for (Pair argumentData : (List)entry.getValue()) {
                CraftPresence.CLIENT.syncArgument((String)entry.getKey() + ((String)argumentData.getFirst()).substring(1), (String)argumentData.getSecond(), ArgumentType.Text);
            }
        }
        if (!CraftPresence.CLIENT.generalArgs.isEmpty()) {
            StringUtils.addEntriesNotPresent(this.serverArgs, CraftPresence.CLIENT.generalArgs);
        }
        CraftPresence.CLIENT.syncArgument("&SERVER&", StringUtils.sequentialReplaceAnyCase(this.currentServerMessage, this.serverArgs), ArgumentType.Text);
        if (!StringUtils.isNullOrEmpty(this.currentServerIcon)) {
            CraftPresence.CLIENT.syncArgument("&SERVER&", CraftPresence.CLIENT.imageOf("&SERVER&", true, this.currentServerIcon, CraftPresence.CONFIG.defaultServerIcon), ArgumentType.Image);
        } else {
            CraftPresence.CLIENT.initArgument(ArgumentType.Image, "&SERVER&");
        }
        this.queuedForUpdate = false;
    }

    public void getServerAddresses() {
        block5: {
            try {
                class_641 serverList = new class_641(CraftPresence.instance);
                serverList.method_2981();
                this.serverIndex = serverList.method_2984();
                for (int currentIndex = 0; currentIndex < this.serverIndex; ++currentIndex) {
                    class_642 data = serverList.method_2982(currentIndex);
                    if (!StringUtils.isNullOrEmpty(data.field_3761) && !this.knownAddresses.contains(data.field_3761.contains(":") ? StringUtils.formatAddress(data.field_3761, false) : data.field_3761)) {
                        this.knownAddresses.add(data.field_3761.contains(":") ? StringUtils.formatAddress(data.field_3761, false) : data.field_3761);
                    }
                    if (StringUtils.isNullOrEmpty(data.field_3761) || this.knownServerData.containsKey(data.field_3761)) continue;
                    this.knownServerData.put(data.field_3761, data);
                }
            }
            catch (Exception ex) {
                if (!ModUtils.IS_VERBOSE) break block5;
                ex.printStackTrace();
            }
        }
        for (String serverMessage : CraftPresence.CONFIG.serverMessages) {
            String[] part;
            if (StringUtils.isNullOrEmpty(serverMessage) || StringUtils.isNullOrEmpty((part = serverMessage.split(CraftPresence.CONFIG.splitCharacter))[0]) || this.knownAddresses.contains(part[0])) continue;
            this.knownAddresses.add(part[0]);
        }
    }

    public class_642 getDataFromName(String serverAddress) {
        return this.knownServerData.getOrDefault(serverAddress, null);
    }

    public String generateArgumentMessage(String argumentFormat, String subArgumentFormat, ArgumentType ... types) {
        types = types != null && types.length > 0 ? types : ArgumentType.values();
        HashMap argumentData = Maps.newHashMap();
        for (ArgumentType type : types) {
            ArrayList queuedEntries = Lists.newArrayList();
            if (type == ArgumentType.Image) {
                queuedEntries.add(subArgumentFormat + "ICON&");
            } else if (type == ArgumentType.Text) {
                if (subArgumentFormat.endsWith("PLAYERINFO:")) {
                    queuedEntries.add(subArgumentFormat + "COORDS&");
                    queuedEntries.add(subArgumentFormat + "HEALTH&");
                } else if (subArgumentFormat.endsWith("PLAYERINFO:COORDS:")) {
                    queuedEntries.add(subArgumentFormat + "xPosition&");
                    queuedEntries.add(subArgumentFormat + "yPosition&");
                    queuedEntries.add(subArgumentFormat + "zPosition&");
                } else if (subArgumentFormat.endsWith("PLAYERINFO:HEALTH:")) {
                    queuedEntries.add(subArgumentFormat + "CURRENT&");
                    queuedEntries.add(subArgumentFormat + "MAX&");
                } else if (subArgumentFormat.endsWith("PLAYERS:")) {
                    queuedEntries.add(subArgumentFormat + "CURRENT&");
                    queuedEntries.add(subArgumentFormat + "MAX&");
                } else if (subArgumentFormat.endsWith("WORLDINFO:")) {
                    queuedEntries.add(subArgumentFormat + "DIFFICULTY&");
                    queuedEntries.add(subArgumentFormat + "WORLDNAME&");
                    queuedEntries.add(subArgumentFormat + "WORLDTIME&");
                    queuedEntries.add(subArgumentFormat + "WORLDDAY&");
                } else {
                    queuedEntries.add(subArgumentFormat + "PLAYERINFO&");
                    queuedEntries.add(subArgumentFormat + "WORLDINFO&");
                    queuedEntries.add(subArgumentFormat + "IP&");
                    queuedEntries.add(subArgumentFormat + "NAME&");
                    queuedEntries.add(subArgumentFormat + "MOTD&");
                    queuedEntries.add(subArgumentFormat + "PLAYERS&");
                }
            }
            argumentData.put(type, queuedEntries);
        }
        return CraftPresence.CLIENT.generateArgumentMessage(argumentFormat, subArgumentFormat, argumentData);
    }

    public String generateArgumentMessage(ArgumentType ... types) {
        return this.generateArgumentMessage("&SERVER&", "&SERVER:", types);
    }
}

