/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.impl;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.DataConsumer;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.impl.PairConsumer;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import fabric.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.ExtendedTextControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls.SliderControl;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.integrations.PaginatedScreen;
import java.awt.Color;
import java.io.File;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class ColorEditorGui
extends PaginatedScreen {
    private final String configValueName;
    private final PairConsumer<Integer, ColorEditorGui> onAdjustEntry;
    private final DataConsumer<ColorEditorGui> onInit;
    public String currentNormalHexValue;
    public String startingHexValue;
    public String currentNormalTexturePath;
    public String startingTexturePath;
    public boolean usingExternalTexture = false;
    private String currentConvertedHexValue;
    private int currentRed;
    private int currentGreen;
    private int currentBlue;
    private int currentAlpha;
    private ExtendedTextControl hexText;
    private SliderControl redText;
    private SliderControl greenText;
    private SliderControl blueText;
    private SliderControl alphaText;
    private String currentConvertedTexturePath;
    private ExtendedTextControl textureText;
    private boolean isModified = false;
    private class_2960 currentTexture;

    public ColorEditorGui(class_437 parentScreen, String configValueName, PairConsumer<Integer, ColorEditorGui> onAdjustEntry, DataConsumer<ColorEditorGui> onInit) {
        super(parentScreen);
        this.configValueName = configValueName;
        this.onAdjustEntry = onAdjustEntry;
        this.onInit = onInit;
    }

    @Override
    public void initializeUi() {
        int calc1 = this.getScreenWidth() / 2 - 183;
        int calc2 = this.getScreenWidth() / 2 + 3;
        String redTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.red", new Object[0]);
        String greenTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.green", new Object[0]);
        String blueTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.blue", new Object[0]);
        String alphaTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.color.value.alpha", new Object[0]);
        this.hexText = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20), this.startPage);
        this.hexText.setControlMaxLength(10);
        this.redText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, CraftPresence.GUIS.getButtonY(2)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, redTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)), this.startPage);
        this.greenText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc2, CraftPresence.GUIS.getButtonY(2)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, greenTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)), this.startPage);
        this.blueText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc1, CraftPresence.GUIS.getButtonY(3)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, blueTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)), this.startPage);
        this.alphaText = this.addControl(new SliderControl(new Pair<Integer, Integer>(calc2, CraftPresence.GUIS.getButtonY(3)), new Pair<Integer, Integer>(180, 20), 1.0f, 0.0f, 255.0f, 1.0f, alphaTitle, new Tuple<Runnable, Runnable, Runnable>(this::syncValues, () -> {}, this::syncValues)), this.startPage);
        this.textureText = this.addControl(new ExtendedTextControl(this.getFontRenderer(), calc2, CraftPresence.GUIS.getButtonY(1), 180, 20, this::syncValues), this.startPage + 1);
        this.textureText.setControlMaxLength(Short.MAX_VALUE);
        this.initValues();
        this.syncValues();
        super.initializeUi();
        this.backButton.setOnClick(() -> {
            this.syncValues();
            if (this.isModified && this.onAdjustEntry != null) {
                this.onAdjustEntry.accept(this.currentPage, this);
            }
            CraftPresence.GUIS.openScreen(this.parentScreen);
        });
        this.setOnPageChange(() -> {
            this.initValues();
            this.syncValues();
        });
    }

    @Override
    public void preRender() {
        String mainTitle = ModUtils.TRANSLATOR.translate("gui.config.title.editor.color", this.configValueName);
        String previewTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.preview", new Object[0]);
        this.renderString(mainTitle, (float)this.getScreenWidth() / 2.0f - (float)this.getStringWidth(mainTitle) / 2.0f, 10.0f, 0xFFFFFF);
        this.renderString(previewTitle, this.getScreenWidth() - 90, (float)this.getScreenHeight() - 29.5f, 0xFFFFFF);
        double tooltipX = this.getScreenWidth() - 45;
        double tooltipY = this.getScreenHeight() - 45;
        double tooltipHeight = 40.0;
        double tooltipTextWidth = 40.0;
        String borderColor = "#000000";
        String borderColorEnd = "#000000";
        super.preRender();
        if (this.currentPage == this.startPage) {
            String hexCodeTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.hex_code", new Object[0]);
            this.renderString(hexCodeTitle, (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
            this.backButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.hexText.getControlMessage()));
            CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0, this.getScreenWidth() - 2, this.getScreenHeight() - 2, this.currentConvertedHexValue, this.currentConvertedHexValue);
        }
        if (this.currentPage == this.startPage + 1) {
            String textureTitle = ModUtils.TRANSLATOR.translate("gui.config.message.editor.texture_path", new Object[0]);
            this.renderString(textureTitle, (float)this.getScreenWidth() / 2.0f - 130.0f, CraftPresence.GUIS.getButtonY(1, 5), 0xFFFFFF);
            this.backButton.setControlEnabled(!StringUtils.isNullOrEmpty(this.textureText.getControlMessage()));
            if (this.currentTexture == null) {
                this.currentTexture = new class_2960("");
            }
            float widthDivider = 32.0f;
            float heightDivider = 32.0f;
            if (this.usingExternalTexture) {
                String formattedConvertedName = this.currentConvertedTexturePath.replaceFirst("file://", "");
                String[] urlBits = formattedConvertedName.split("/");
                String textureName = urlBits[urlBits.length - 1].trim();
                this.currentTexture = ImageUtils.getTextureFromUrl(textureName, this.currentConvertedTexturePath.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                widthDivider = 44.0f;
                heightDivider = 43.0f;
            }
            CraftPresence.GUIS.drawTextureRect(0.0, this.getScreenWidth() - 47, this.getScreenHeight() - 47, 44.0f, 44.0f, 0.0f, widthDivider, heightDivider, false, this.currentTexture);
        }
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0 + 1.0, tooltipX - 3.0 + 1.0, tooltipY + tooltipHeight + 3.0 - 1.0, borderColor, borderColorEnd);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX + tooltipTextWidth + 2.0, tooltipY - 3.0 + 1.0, tooltipX + tooltipTextWidth + 3.0, tooltipY + tooltipHeight + 3.0 - 1.0, borderColor, borderColorEnd);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY - 3.0, tooltipX + tooltipTextWidth + 3.0, tooltipY - 3.0 + 1.0, borderColor, borderColor);
        CraftPresence.GUIS.drawGradientRect(300.0f, tooltipX - 3.0, tooltipY + tooltipHeight + 2.0, tooltipX + tooltipTextWidth + 3.0, tooltipY + tooltipHeight + 3.0, borderColorEnd, borderColorEnd);
        this.backButton.setControlMessage(this.isModified ? "gui.config.message.button.save" : "gui.config.message.button.back");
    }

    private void initValues() {
        if (this.onInit != null) {
            this.onInit.accept(this);
            if (StringUtils.isNullOrEmpty(this.hexText.getControlMessage()) && !StringUtils.isNullOrEmpty(this.startingHexValue)) {
                this.hexText.setControlMessage(this.startingHexValue);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedTexturePath = null;
                this.currentTexture = new class_2960("");
                this.currentPage = this.startPage;
            } else if (StringUtils.isNullOrEmpty(this.textureText.getControlMessage()) && !StringUtils.isNullOrEmpty(this.startingTexturePath)) {
                this.textureText.setControlMessage(this.startingTexturePath);
                this.currentNormalHexValue = null;
                this.currentConvertedHexValue = null;
                this.currentConvertedTexturePath = null;
                this.currentTexture = new class_2960("");
                this.currentPage = this.startPage + 1;
            }
        }
    }

    private void syncValues() {
        if (this.currentPage == this.startPage) {
            Color localColor;
            Integer localValue = null;
            if (!StringUtils.isNullOrEmpty(this.hexText.getControlMessage())) {
                if (this.hexText.getControlMessage().startsWith("#") || this.hexText.getControlMessage().length() == 6) {
                    localValue = StringUtils.getColorFromHex(this.hexText.getControlMessage()).getRGB();
                } else if (this.hexText.getControlMessage().startsWith("0x")) {
                    try {
                        localColor = new Color(Long.decode(this.hexText.getControlMessage()).intValue(), true);
                        localValue = localColor.getRGB();
                    }
                    catch (Exception exception) {}
                } else if (StringUtils.getValidInteger(this.hexText.getControlMessage()).getFirst().booleanValue()) {
                    localValue = Integer.decode(this.hexText.getControlMessage());
                }
            }
            if (localValue != null && !Integer.toString(localValue).equals(this.currentConvertedHexValue)) {
                this.currentAlpha = localValue >> 24 & 0xFF;
                this.currentRed = localValue >> 16 & 0xFF;
                this.currentGreen = localValue >> 8 & 0xFF;
                this.currentBlue = localValue & 0xFF;
                this.alphaText.setSliderValue(this.currentAlpha);
                this.redText.setSliderValue(this.currentRed);
                this.greenText.setSliderValue(this.currentGreen);
                this.blueText.setSliderValue(this.currentBlue);
                this.currentNormalHexValue = this.hexText.getControlMessage();
                this.currentConvertedHexValue = Integer.toString(localValue);
            } else {
                boolean isAlphaDifferent;
                boolean isRedDifferent = this.redText.isDragging() && this.redText.getSliderValue(false) != (float)this.currentRed;
                boolean isGreenDifferent = this.greenText.isDragging() && this.greenText.getSliderValue(false) != (float)this.currentGreen;
                boolean isBlueDifferent = this.blueText.isDragging() && this.blueText.getSliderValue(false) != (float)this.currentBlue;
                boolean bl = isAlphaDifferent = this.alphaText.isDragging() && this.alphaText.getSliderValue(false) != (float)this.currentAlpha;
                if (isRedDifferent || isGreenDifferent || isBlueDifferent || isAlphaDifferent) {
                    this.currentRed = (int)this.redText.getSliderValue(false) & 0xFF;
                    this.currentGreen = (int)this.greenText.getSliderValue(false) & 0xFF;
                    this.currentBlue = (int)this.blueText.getSliderValue(false) & 0xFF;
                    this.currentAlpha = (int)this.alphaText.getSliderValue(false) & 0xFF;
                    localColor = new Color(this.currentRed, this.currentGreen, this.currentBlue, this.currentAlpha);
                    this.currentNormalHexValue = StringUtils.getHexFromColor(localColor);
                    this.hexText.setControlMessage(this.currentNormalHexValue);
                    this.currentConvertedHexValue = Long.toString(Long.decode(this.currentNormalHexValue).intValue());
                }
            }
            boolean bl = this.isModified = !this.hexText.getControlMessage().equals(this.startingHexValue);
        }
        if (this.currentPage == this.startPage + 1) {
            if (!StringUtils.isNullOrEmpty(this.textureText.getControlMessage())) {
                this.usingExternalTexture = ImageUtils.isExternalImage(this.textureText.getControlMessage());
                if (!this.usingExternalTexture) {
                    if (this.textureText.getControlMessage().contains(CraftPresence.CONFIG.splitCharacter)) {
                        this.textureText.setControlMessage(this.textureText.getControlMessage().replace(CraftPresence.CONFIG.splitCharacter, ":"));
                    }
                    this.currentNormalTexturePath = this.textureText.getControlMessage().contains(":") && !this.textureText.getControlMessage().startsWith(":") ? this.textureText.getControlMessage() : (this.textureText.getControlMessage().startsWith(":") ? this.textureText.getControlMessage().substring(1) : "minecraft:" + this.textureText.getControlMessage());
                } else {
                    this.currentNormalTexturePath = this.textureText.getControlMessage();
                }
                this.currentConvertedTexturePath = this.currentNormalTexturePath.trim();
                if (!this.usingExternalTexture) {
                    if (this.currentConvertedTexturePath.contains(":")) {
                        String[] splitInput = this.currentConvertedTexturePath.split(":", 2);
                        this.currentTexture = new class_2960(splitInput[0], splitInput[1]);
                    } else {
                        this.currentTexture = new class_2960(this.currentConvertedTexturePath);
                    }
                } else {
                    String formattedConvertedName = this.currentConvertedTexturePath.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    this.currentTexture = ImageUtils.getTextureFromUrl(textureName, this.currentConvertedTexturePath.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
            } else {
                this.currentTexture = new class_2960("");
            }
            this.isModified = !StringUtils.isNullOrEmpty(this.startingTexturePath) && !this.textureText.getControlMessage().equals(this.startingTexturePath.replace(CraftPresence.CONFIG.splitCharacter, ":"));
        }
    }
}

