/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Pair;
import fabric.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.assets.DiscordAssetUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_642;

public class ScrollableListControl
extends class_4280<StringEntry> {
    public String currentValue;
    public List<String> itemList;
    public RenderType renderType;
    public boolean visible = true;

    public ScrollableListControl(class_310 mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue) {
        this(mc, width, height, topIn, bottomIn, slotHeightIn, itemList, currentValue, RenderType.None);
    }

    public ScrollableListControl(class_310 mc, int width, int height, int topIn, int bottomIn, int slotHeightIn, List<String> itemList, String currentValue, RenderType renderType) {
        super(mc, width, height, topIn, bottomIn, slotHeightIn);
        this.itemList = itemList;
        this.currentValue = currentValue;
        this.renderType = renderType;
        if (renderType == RenderType.ItemData) {
            CraftPresence.TILE_ENTITIES.getEntities();
        }
        this.updateEntries();
    }

    public void setSelected(StringEntry entry) {
        super.method_25313((class_350.class_351)entry);
        if (entry != null) {
            this.currentValue = entry.displayName;
        }
    }

    protected int method_25340() {
        return this.itemList.size();
    }

    protected void method_25325(@Nonnull class_4587 matrixStack) {
        if (this.method_25340() != this.method_25396().size()) {
            this.method_25339();
            this.updateEntries();
        }
    }

    public void updateEntries() {
        for (String item : this.itemList) {
            StringEntry dataEntry = new StringEntry(item, this.renderType);
            this.method_25321((class_350.class_351)dataEntry);
            if (!item.equals(this.currentValue)) continue;
            this.setSelected(dataEntry);
        }
        if (this.method_25334() != null) {
            this.method_25324((class_350.class_351)((StringEntry)this.method_25334()));
        }
    }

    public class_327 getFontRenderer() {
        return this.field_22740.field_1772 != null ? this.field_22740.field_1772 : GuiUtils.getDefaultFontRenderer();
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean value) {
        this.visible = value;
    }

    public static enum RenderType {
        DiscordAsset,
        CustomDiscordAsset,
        ServerData,
        EntityData,
        ItemData,
        None;

    }

    public class StringEntry
    extends class_4280.class_4281<StringEntry> {
        private final RenderType renderType;
        private String displayName;

        public StringEntry(String name) {
            this(name, RenderType.None);
        }

        public StringEntry(String name, RenderType renderType) {
            this.displayName = name;
            this.renderType = renderType;
        }

        public void method_25343(@Nonnull class_4587 matrices, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            int xOffset = xPos;
            if (!CraftPresence.CONFIG.stripExtraGuiElements && (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset || this.renderType == RenderType.ServerData && CraftPresence.SERVER.enabled || this.renderType == RenderType.EntityData && CraftPresence.ENTITIES.enabled || this.renderType == RenderType.ItemData && CraftPresence.TILE_ENTITIES.enabled)) {
                class_2960 texture = new class_2960("");
                if (this.renderType == RenderType.ServerData) {
                    class_642 data = CraftPresence.SERVER.getDataFromName(this.displayName);
                    if (data != null) {
                        String assetUrl = "data:image/unknown;base64," + data.method_2991();
                        texture = ImageUtils.getTextureFromUrl(this.displayName, new Pair<ImageUtils.InputType, Object>(ImageUtils.InputType.ByteStream, assetUrl));
                    }
                } else if (this.renderType == RenderType.DiscordAsset || this.renderType == RenderType.CustomDiscordAsset) {
                    String assetUrl = DiscordAssetUtils.getUrl(this.renderType == RenderType.CustomDiscordAsset ? DiscordAssetUtils.CUSTOM_ASSET_LIST : DiscordAssetUtils.ASSET_LIST, this.displayName);
                    texture = ImageUtils.getTextureFromUrl(this.displayName, assetUrl);
                } else if (this.renderType == RenderType.EntityData) {
                    if (StringUtils.isValidUuid(this.displayName)) {
                        this.displayName = StringUtils.getFromUuid(this.displayName);
                        texture = ImageUtils.getTextureFromUrl(this.displayName, String.format(CraftPresence.CONFIG.playerSkinEndpoint, this.displayName));
                    }
                } else if (this.renderType == RenderType.ItemData) {
                    texture = CraftPresence.TILE_ENTITIES.TILE_ENTITY_RESOURCES.getOrDefault(this.displayName, texture);
                }
                if (!ImageUtils.isTextureNull(texture)) {
                    CraftPresence.GUIS.drawTextureRect(0.0, xOffset, (double)yPos + 4.5, 32.0f, 32.0f, 0.0f, texture);
                }
                xOffset += 35;
            }
            ScrollableListControl.this.getFontRenderer().method_1720(matrices, this.displayName, (float)xOffset, (float)yPos + ((float)entryHeight / 2.0f - (float)ScrollableListControl.this.getFontHeight() / 2.0f), 0xFFFFFF);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (button == 0) {
                this.onPressed();
                return true;
            }
            return false;
        }

        private void onPressed() {
            ScrollableListControl.this.setSelected(this);
        }
    }
}

