/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils.gui.controls;

import fabric.com.gitlab.cdagaming.craftpresence.CraftPresence;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.ImageUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import java.io.File;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_4185;
import net.minecraft.class_4587;

public class ExtendedButtonControl
extends class_4185 {
    private String[] optionalArgs;
    private Runnable onPushEvent = null;
    private Runnable onHoverEvent = null;
    private class_327 currentFontRender = null;

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (class_2561)new class_2585(buttonText), button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.onPushEvent = onPushEvent;
    }

    public ExtendedButtonControl(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(buttonId, x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.onHoverEvent = onHoverEvent;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, String ... optionalArgs) {
        super(x, y, widthIn, heightIn, (class_2561)new class_2585(buttonText), button -> {});
        this.optionalArgs = optionalArgs;
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, optionalArgs);
        this.setOnClick(onPushEvent);
    }

    public ExtendedButtonControl(int x, int y, int widthIn, int heightIn, String buttonText, Runnable onPushEvent, Runnable onHoverEvent, String ... optionalArgs) {
        this(x, y, widthIn, heightIn, buttonText, onPushEvent, optionalArgs);
        this.setOnHover(onHoverEvent);
    }

    public ExtendedButtonControl(int id, int xPos, int yPos, String displayString) {
        this(xPos, yPos, 200, 20, displayString, new String[0]);
    }

    public ExtendedButtonControl(int xPos, int yPos, String displayString) {
        this(CraftPresence.GUIS.getNextIndex(), xPos, yPos, displayString);
    }

    public void method_25394(@Nonnull class_4587 matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.field_22764) {
            this.field_22762 = CraftPresence.GUIS.isMouseOver((double)mouseX, (double)mouseY, this);
            int hoverState = this.method_25356(this.field_22762);
            String backgroundCode = CraftPresence.CONFIG.buttonBackgroundColor;
            if (StringUtils.isValidColorCode(backgroundCode)) {
                CraftPresence.GUIS.drawGradientRect(this.method_25305(), this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), backgroundCode, backgroundCode);
            } else {
                class_2960 texLocation;
                boolean usingExternalTexture = ImageUtils.isExternalImage(backgroundCode);
                if (!usingExternalTexture) {
                    if (backgroundCode.contains(CraftPresence.CONFIG.splitCharacter)) {
                        backgroundCode = backgroundCode.replace(CraftPresence.CONFIG.splitCharacter, ":");
                    }
                    if (backgroundCode.contains(":")) {
                        String[] splitInput = backgroundCode.split(":", 2);
                        texLocation = new class_2960(splitInput[0], splitInput[1]);
                    } else {
                        texLocation = new class_2960(backgroundCode);
                    }
                } else {
                    String formattedConvertedName = backgroundCode.replaceFirst("file://", "");
                    String[] urlBits = formattedConvertedName.trim().split("/");
                    String textureName = urlBits[urlBits.length - 1].trim();
                    texLocation = ImageUtils.getTextureFromUrl(textureName, backgroundCode.toLowerCase().startsWith("file://") ? new File(formattedConvertedName) : formattedConvertedName);
                }
                CraftPresence.GUIS.renderButton(this.getControlPosX(), this.getControlPosY(), this.getControlWidth(), this.getControlHeight(), hoverState, this.method_25305(), texLocation);
            }
            this.method_25353(matrixStack, CraftPresence.instance, mouseX, mouseY);
            int color = !this.field_22763 ? 0xA0A0A0 : (this.field_22762 ? 0xFFFFA0 : 0xE0E0E0);
            ExtendedButtonControl.method_25300((class_4587)matrixStack, (class_327)this.getFontRenderer(), (String)this.getDisplayMessage(), (int)(this.getControlPosX() + this.getControlWidth() / 2), (int)(this.getControlPosY() + (this.getControlHeight() - 8) / 2), (int)color);
        }
    }

    public int getControlWidth() {
        return this.field_22758;
    }

    public int getControlHeight() {
        return this.field_22759;
    }

    public int getControlPosX() {
        return this.field_22760;
    }

    public int getControlPosY() {
        return this.field_22761;
    }

    public class_327 getFontRenderer() {
        return this.currentFontRender != null ? this.currentFontRender : GuiUtils.getDefaultFontRenderer();
    }

    public void setCurrentFontRender(class_327 currentFontRender) {
        this.currentFontRender = currentFontRender;
    }

    public int getFontHeight() {
        Objects.requireNonNull(this.getFontRenderer());
        return 9;
    }

    public String[] getOptionalArgs() {
        return this.optionalArgs;
    }

    public void setOnClick(Runnable event) {
        this.onPushEvent = event;
    }

    public void onClick() {
        if (this.onPushEvent != null) {
            this.onPushEvent.run();
        }
    }

    public void method_25348(double mouseX, double mouseY) {
        this.onClick();
        super.method_25348(mouseX, mouseY);
    }

    public void setOnHover(Runnable event) {
        this.onHoverEvent = event;
    }

    public void onHover() {
        if (this.onHoverEvent != null) {
            this.onHoverEvent.run();
        }
    }

    public class_2561 getControlRawMessage() {
        return this.method_25369();
    }

    public void setControlRawMessage(class_2561 newMessage) {
        this.method_25355(newMessage);
    }

    public String getDisplayMessage() {
        String result = this.getControlMessage().trim();
        if (result.contains(" ")) {
            String adjusted = result;
            for (String dataPart : result.split(" ")) {
                if (!ModUtils.TRANSLATOR.hasTranslation(dataPart)) continue;
                adjusted = adjusted.replace(dataPart, ModUtils.TRANSLATOR.translate(dataPart, new Object[0]));
            }
            result = adjusted;
        } else if (ModUtils.TRANSLATOR.hasTranslation(this.getControlMessage())) {
            result = ModUtils.TRANSLATOR.translate(result, new Object[0]);
        }
        return result;
    }

    public String getControlMessage() {
        return this.getControlRawMessage().getString();
    }

    public void setControlMessage(String newMessage) {
        this.setControlRawMessage((class_2561)new class_2585(newMessage));
    }

    public boolean isControlEnabled() {
        return this.field_22763;
    }

    public void setControlEnabled(boolean isEnabled) {
        this.field_22763 = isEnabled;
    }

    public boolean isControlVisible() {
        return this.field_22764;
    }

    public void setControlVisible(boolean isVisible) {
        this.field_22764 = isVisible;
    }
}

