/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;

public class UrlUtils {
    private static final String USER_AGENT = "craftpresence/" + ModUtils.MCVersion;
    private static final String OS_NAME = System.getProperty("os.name");
    private static final float JAVA_SPEC = Float.parseFloat(System.getProperty("java.specification.version"));
    private static final Gson GSON = new GsonBuilder().create();

    public static String getURLText(URL url, String encoding) throws Exception {
        return UrlUtils.getString(UrlUtils.getURLReader(url, encoding));
    }

    private static String getString(BufferedReader urlReader) throws Exception {
        String inputLine;
        StringBuilder response = new StringBuilder();
        while (!StringUtils.isNullOrEmpty(inputLine = urlReader.readLine())) {
            response.append(inputLine);
        }
        urlReader.close();
        return response.toString();
    }

    public static String getURLText(String url, String encoding) throws Exception {
        return UrlUtils.getString(UrlUtils.getURLReader(url, encoding));
    }

    public static BufferedReader getURLReader(String url, String encoding) throws Exception {
        return UrlUtils.getURLReader(new URL(url), encoding);
    }

    public static BufferedReader getURLReader(URL url, String encoding) throws Exception {
        return new BufferedReader(UrlUtils.getURLStreamReader(url, encoding));
    }

    public static InputStream getURLStream(URL url) throws Exception {
        if ((double)JAVA_SPEC < 1.8) {
            System.setProperty("https.protocols", "TLSv1.2");
        }
        URLConnection connection = url.openConnection();
        connection.addRequestProperty("User-Agent", USER_AGENT);
        return connection.getInputStream();
    }

    public static InputStreamReader getURLStreamReader(URL url, String encoding) throws Exception {
        return new InputStreamReader(UrlUtils.getURLStream(url), Charset.forName(encoding));
    }

    public static <T> T getJSONFromURL(String url, Class<T> targetClass) throws Exception {
        return UrlUtils.getJSONFromURL(new URL(url), targetClass);
    }

    public static <T> T getJSONFromURL(URL url, Class<T> targetClass) throws Exception {
        return (T)GSON.fromJson((Reader)UrlUtils.getURLStreamReader(url, "UTF-8"), targetClass);
    }

    public static void openUrl(String targetUrl) {
        try {
            UrlUtils.openUrl(new URI(targetUrl));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void openUrl(URL targetUrl) {
        try {
            UrlUtils.openUrl(targetUrl.toURI());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void openUrl(URI targetUrl) {
        block8: {
            try {
                Class<?> d = Class.forName("java.awt.Desktop");
                d.getDeclaredMethod("browse", URI.class).invoke(d.getDeclaredMethod("getDesktop", new Class[0]).invoke(null, new Object[0]), targetUrl);
            }
            catch (Exception ignored) {
                try {
                    if (OS_NAME.contains("Win")) {
                        Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + targetUrl.toString());
                    } else if (OS_NAME.startsWith("Mac")) {
                        Class.forName("com.apple.eio.FileManager").getDeclaredMethod("openURL", String.class).invoke(null, targetUrl.toString());
                    } else {
                        Runtime.getRuntime().exec("xdg-open " + targetUrl.toString());
                    }
                }
                catch (Exception ex) {
                    ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.web", targetUrl.toString()), new Object[0]);
                    if (!ModUtils.IS_VERBOSE) break block8;
                    ex.printStackTrace();
                }
            }
        }
    }
}

