/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.gitlab.cdagaming.craftpresence;

import external.com.jagrosh.discordipc.IPCClient;
import fabric.com.gitlab.cdagaming.craftpresence.ModUtils;
import fabric.com.gitlab.cdagaming.craftpresence.config.ConfigUtils;
import fabric.com.gitlab.cdagaming.craftpresence.impl.Tuple;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.ArgumentType;
import fabric.com.gitlab.cdagaming.craftpresence.impl.discord.DiscordStatus;
import fabric.com.gitlab.cdagaming.craftpresence.utils.CommandUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.KeyUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.StringUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.SystemUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.discord.DiscordUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.EntityUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.entity.TileEntityUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.gui.GuiUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.server.ServerUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.world.BiomeUtils;
import fabric.com.gitlab.cdagaming.craftpresence.utils.world.DimensionUtils;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_320;

public class CraftPresence {
    public static boolean packFound = false;
    public static boolean closing = false;
    public static Timer timerObj = new Timer(CraftPresence.class.getSimpleName());
    public static class_310 instance;
    public static class_320 session;
    public static class_1657 player;
    public static ConfigUtils CONFIG;
    public static SystemUtils SYSTEM;
    public static KeyUtils KEYBINDINGS;
    public static DiscordUtils CLIENT;
    public static ServerUtils SERVER;
    public static BiomeUtils BIOMES;
    public static DimensionUtils DIMENSIONS;
    public static EntityUtils ENTITIES;
    public static TileEntityUtils TILE_ENTITIES;
    public static GuiUtils GUIS;
    public static boolean isDevStatusOverridden;
    public static boolean isVerboseStatusOverridden;
    private boolean initialized = false;

    public CraftPresence() {
        this.scheduleTick();
    }

    private void init() {
        ModUtils.LOG.debugWarn(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.warning.debug_mode", new Object[0]), new Object[0]);
        ModUtils.LOG.debugInfo(ModUtils.TRANSLATOR.translate(true, "craftpresence.logger.info.os", CraftPresence.SYSTEM.OS_NAME, CraftPresence.SYSTEM.OS_ARCH, CraftPresence.SYSTEM.IS_64_BIT), new Object[0]);
        ModUtils.UPDATER.checkForUpdates(() -> {
            if (ModUtils.UPDATER.isInvalidVersion) {
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_ID", "v" + ModUtils.UPDATER.targetVersion, -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_TYPE", ModUtils.UPDATER.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("VERSION_LABEL", ModUtils.UPDATER.currentState.getDisplayName(), -17));
                StringUtils.updateField(ModUtils.class, null, new Tuple<String, String, Integer>("NAME", CraftPresence.class.getSimpleName(), -17));
                ModUtils.UPDATER.currentVersion = ModUtils.UPDATER.targetVersion;
                ModUtils.UPDATER.isInvalidVersion = false;
            }
        });
        SYSTEM = new SystemUtils();
        CONFIG = new ConfigUtils(ModUtils.configDir + File.separator + "craftpresence" + ".properties");
        CONFIG.initialize();
        CommandUtils.init();
        if (!ModUtils.IS_DEV) {
            ModUtils.IS_DEV = CraftPresence.CONFIG.debugMode || ModUtils.IS_VERBOSE;
        } else {
            isDevStatusOverridden = true;
        }
        if (!ModUtils.IS_VERBOSE) {
            ModUtils.IS_VERBOSE = CraftPresence.CONFIG.verboseMode;
        } else {
            isVerboseStatusOverridden = true;
        }
        try {
            CraftPresence.CLIENT.CLIENT_ID = CraftPresence.CONFIG.clientId;
            CraftPresence.CLIENT.AUTO_REGISTER = CraftPresence.CONFIG.autoRegister;
            CLIENT.setup();
            CLIENT.init(true);
        }
        catch (Exception ex) {
            ModUtils.LOG.error(ModUtils.TRANSLATOR.translate("craftpresence.logger.error.load", new Object[0]), new Object[0]);
            ex.printStackTrace();
        }
        finally {
            this.initialized = true;
        }
    }

    private void scheduleTick() {
        if (!closing) {
            timerObj.schedule(new TimerTask(){

                @Override
                public void run() {
                    CraftPresence.this.clientTick();
                }
            }, 50L);
        }
    }

    private void clientTick() {
        if (!closing) {
            instance = class_310.method_1551();
            if (this.initialized) {
                session = instance.method_1548();
                player = CraftPresence.instance.field_1724;
                ModUtils.IS_DEV = !isDevStatusOverridden ? CraftPresence.CONFIG.debugMode : ModUtils.IS_DEV;
                ModUtils.IS_VERBOSE = !isVerboseStatusOverridden ? CraftPresence.CONFIG.verboseMode : ModUtils.IS_VERBOSE;
                CommandUtils.reloadData(false);
                if (!CraftPresence.CONFIG.hasChanged) {
                    if (!CraftPresence.SYSTEM.HAS_LOADED) {
                        CommandUtils.setLoadingPresence();
                    } else if (!(CommandUtils.isInMainMenu || CraftPresence.DIMENSIONS.isInUse || CraftPresence.BIOMES.isInUse || CraftPresence.TILE_ENTITIES.isInUse || CraftPresence.ENTITIES.isInUse || CraftPresence.SERVER.isInUse)) {
                        CommandUtils.setMainMenuPresence();
                    } else if (player != null && (CommandUtils.isLoadingGame || CommandUtils.isInMainMenu)) {
                        CommandUtils.isInMainMenu = false;
                        CommandUtils.isLoadingGame = false;
                        CLIENT.initArgument(ArgumentType.Text, "&MAINMENU&");
                        CLIENT.initArgument(ArgumentType.Image, "&MAINMENU&");
                    }
                    if (CraftPresence.SYSTEM.HAS_LOADED) {
                        if (CraftPresence.CLIENT.awaitingReply && CraftPresence.SYSTEM.TIMER == 0) {
                            StringUtils.sendMessageToPlayer((class_1297)player, ModUtils.TRANSLATOR.translate("craftpresence.command.request.ignored", CraftPresence.CLIENT.REQUESTER_USER.getName()));
                            CraftPresence.CLIENT.ipcInstance.respondToJoinRequest(CraftPresence.CLIENT.REQUESTER_USER, IPCClient.ApprovalMode.DENY);
                            CraftPresence.CLIENT.awaitingReply = false;
                            CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                        } else if (!CraftPresence.CLIENT.awaitingReply && CraftPresence.CLIENT.REQUESTER_USER != null) {
                            CraftPresence.CLIENT.REQUESTER_USER = null;
                            CraftPresence.CLIENT.STATUS = DiscordStatus.Ready;
                        }
                    }
                }
            } else if (instance != null && (session = instance.method_1548()) != null) {
                this.init();
            }
            this.scheduleTick();
        }
    }

    static {
        SYSTEM = new SystemUtils();
        KEYBINDINGS = new KeyUtils();
        CLIENT = new DiscordUtils();
        SERVER = new ServerUtils();
        BIOMES = new BiomeUtils();
        DIMENSIONS = new DimensionUtils();
        ENTITIES = new EntityUtils();
        TILE_ENTITIES = new TileEntityUtils();
        GUIS = new GuiUtils();
        isDevStatusOverridden = false;
        isVerboseStatusOverridden = false;
    }
}

