/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.packet;

import java.io.File;
import java.nio.file.Files;
import java.util.HashSet;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.packet.PacketHatFragment;
import me.ichun.mods.hats.common.packet.PacketHatsListResponse;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketHatsList
extends AbstractPacket {
    public HashSet<String> hatNames = new HashSet();
    public boolean requested;

    public PacketHatsList() {
    }

    public PacketHatsList(HashSet<String> heads, boolean requested) {
        this.hatNames = heads;
        this.requested = requested;
    }

    public void writeTo(PacketBuffer buf) {
        buf.writeInt(this.hatNames.size());
        this.hatNames.forEach(arg_0 -> ((PacketBuffer)buf).func_180714_a(arg_0));
        buf.writeBoolean(this.requested);
    }

    public void readFrom(PacketBuffer buf) {
        int count = buf.readInt();
        for (int i = 0; i < count; ++i) {
            this.hatNames.add(this.readString(buf));
        }
        this.requested = buf.readBoolean();
    }

    public void process(NetworkEvent.Context context) {
        context.enqueueWork(() -> {
            if (this.requested) {
                for (String s : this.hatNames) {
                    HatInfo info = HatResourceHandler.getInfoFromFullName(s);
                    if (info == null || info.project.saveFile == null) continue;
                    try {
                        int maxFile = 31000;
                        String origin = "Server";
                        String md5 = IOUtil.getMD5Checksum((File)info.project.saveFile);
                        byte[] data = Files.readAllBytes(info.project.saveFile.toPath());
                        String fileName = info.project.saveFile.getName();
                        int fileSize = data.length;
                        int packetsToSend = (int)Math.ceil((float)fileSize / 31000.0f);
                        int packetCount = 0;
                        int offset = 0;
                        while (fileSize > 0) {
                            int index;
                            byte[] fileBytes = new byte[Math.min(fileSize, 31000)];
                            for (index = 0; index < fileBytes.length; ++index) {
                                fileBytes[index] = data[index + offset];
                            }
                            Hats.channel.sendTo((AbstractPacket)new PacketHatFragment(fileName, packetsToSend, packetCount, fileBytes, origin, md5), context.getSender());
                            ++packetCount;
                            fileSize -= fileBytes.length;
                            offset += index;
                        }
                    }
                    catch (Exception e) {
                        Hats.LOGGER.error("Error creating hat as packet fragment: {}", (Object)s);
                        e.printStackTrace();
                    }
                }
            } else {
                HashSet<String> ourHatNames = HatResourceHandler.compileHatNames();
                this.hatNames.removeIf(ourHatNames::remove);
                Hats.channel.sendTo((AbstractPacket)new PacketHatsListResponse(this.hatNames, ourHatNames), context.getSender());
            }
        });
    }
}

