/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Collectors;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.command.HatInfosArgument;
import me.ichun.mods.hats.common.entity.EntityHat;
import me.ichun.mods.hats.common.hats.HatHandler;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.packet.PacketEntityHatDetails;
import me.ichun.mods.hats.common.packet.PacketRehatify;
import me.ichun.mods.hats.common.packet.PacketUpdateHats;
import me.ichun.mods.hats.common.world.HatsSavedData;
import me.ichun.mods.ichunutil.common.head.HeadHandler;
import me.ichun.mods.ichunutil.common.iChunUtil;
import me.ichun.mods.ichunutil.common.network.AbstractPacket;
import me.ichun.mods.ichunutil.common.util.IOUtil;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.NBTCompoundTagArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.network.PacketDistributor;

public class CommandHats {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"hats").requires(p -> p.func_197034_c(2))).then(Commands.func_197057_a((String)"setHat").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"silent").then(Commands.func_197056_a((String)"names", (ArgumentType)HatInfosArgument.multi()).executes(context -> CommandHats.setHat((CommandSource)context.getSource(), (Collection<? extends Entity>)EntityArgument.func_197097_b((CommandContext)context, (String)"targets"), HatInfosArgument.getHatInfos(context, "names"), true)))).then(Commands.func_197056_a((String)"nbt", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> CommandHats.setHat((CommandSource)context.getSource(), (Collection<? extends Entity>)EntityArgument.func_197097_b((CommandContext)context, (String)"targets"), NBTCompoundTagArgument.func_218042_a((CommandContext)context, (String)"nbt"), true))))).then(Commands.func_197056_a((String)"names", (ArgumentType)HatInfosArgument.multi()).executes(context -> CommandHats.setHat((CommandSource)context.getSource(), (Collection<? extends Entity>)EntityArgument.func_197097_b((CommandContext)context, (String)"targets"), HatInfosArgument.getHatInfos(context, "names"), false)))).then(Commands.func_197056_a((String)"nbt", (ArgumentType)NBTCompoundTagArgument.func_218043_a()).executes(context -> CommandHats.setHat((CommandSource)context.getSource(), (Collection<? extends Entity>)EntityArgument.func_197097_b((CommandContext)context, (String)"targets"), NBTCompoundTagArgument.func_218042_a((CommandContext)context, (String)"nbt"), false)))))).then(Commands.func_197057_a((String)"getHat").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197086_a()).executes(context -> CommandHats.getHat((CommandSource)context.getSource(), EntityArgument.func_197088_a((CommandContext)context, (String)"target")))))).then(Commands.func_197057_a((String)"addCount").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"names", (ArgumentType)HatInfosArgument.single()).then(Commands.func_197056_a((String)"count", (ArgumentType)IntegerArgumentType.integer((int)-999999999, (int)999999999)).executes(context -> CommandHats.addCount((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), HatInfosArgument.getHatInfos(context, "names"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))))))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).then(Commands.func_197056_a((String)"names", (ArgumentType)HatInfosArgument.single()).executes(context -> CommandHats.remove((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player"), HatInfosArgument.getHatInfos(context, "names"))))))).then(Commands.func_197057_a((String)"clear").then(Commands.func_197056_a((String)"player", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> CommandHats.clear((CommandSource)context.getSource(), EntityArgument.func_197089_d((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reextract").then(Commands.func_197057_a((String)"heads").executes(context -> {
            try {
                InputStream in = iChunUtil.class.getResourceAsStream("/heads.zip");
                if (in != null) {
                    int i = IOUtil.extractFiles((Path)HeadHandler.getHeadsDir(), (InputStream)in, (boolean)true);
                    HeadHandler.loadHeadInfos();
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.reextract.success", new Object[]{i}), true);
                } else {
                    iChunUtil.LOGGER.error("Error extracting heads.zip. InputStream was null.");
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.reextract.failed"), true);
                }
            }
            catch (Throwable e) {
                Hats.LOGGER.error("Error reextracting heads.");
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.reextract.failed"), true);
                e.printStackTrace();
            }
            return 1;
        }))).then(Commands.func_197057_a((String)"hats").executes(context -> {
            try {
                InputStream in = Hats.class.getResourceAsStream("/hats.zip");
                if (in != null) {
                    int i = IOUtil.extractFiles((Path)HatResourceHandler.getHatsDir(), (InputStream)in, (boolean)true);
                    HatResourceHandler.loadAllHats();
                    HatHandler.allocateHatPools();
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.reextract.success", new Object[]{i}), true);
                } else {
                    Hats.LOGGER.error("Error reextracting hats. InputStream was null.");
                    ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.reextract.failed"), true);
                }
            }
            catch (Throwable e) {
                Hats.LOGGER.error("Error reextracting hats.");
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.reextract.failed"), true);
                e.printStackTrace();
            }
            return 1;
        }))));
    }

    private static HatsSavedData.HatPart getAsPart(ArrayList<HatInfo> hatInfos, int count) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 1; i < hatInfos.size(); ++i) {
            names.add(hatInfos.get((int)i).name);
        }
        return hatInfos.get(0).getFromList(names, count);
    }

    private static int setHat(CommandSource source, Collection<? extends Entity> targets, ArrayList<HatInfo> hatInfos, boolean silent) {
        return CommandHats.setHat(source, targets, CommandHats.getAsPart(hatInfos, 1), silent);
    }

    private static int setHat(CommandSource source, Collection<? extends Entity> targets, CompoundNBT nbt, boolean silent) {
        HatsSavedData.HatPart newPart = new HatsSavedData.HatPart();
        newPart.read(nbt);
        if (HatResourceHandler.HATS.containsKey(newPart.name)) {
            newPart.count = 1;
            newPart.isShowing = true;
        }
        return CommandHats.setHat(source, targets, newPart, silent);
    }

    private static int setHat(CommandSource source, Collection<? extends Entity> targets, HatsSavedData.HatPart newPart, boolean silent) {
        ArrayList entities = targets.stream().filter(e -> e instanceof LivingEntity).collect(Collectors.toCollection(ArrayList::new));
        for (Entity entity : entities) {
            HashMap<Integer, HatsSavedData.HatPart> entIdToHat = new HashMap<Integer, HatsSavedData.HatPart>();
            HatsSavedData.HatPart part = HatHandler.getHatPart((LivingEntity)entity);
            part.copy(newPart);
            entIdToHat.put(entity.func_145782_y(), part);
            if (!silent) {
                Hats.channel.sendTo((AbstractPacket)new PacketRehatify(entity.func_145782_y()), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
            }
            Hats.channel.sendTo((AbstractPacket)new PacketEntityHatDetails(entIdToHat), PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> entity));
        }
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.setHat.success", new Object[]{entities.size()}), true);
        return entities.size();
    }

    private static int getHat(CommandSource source, Entity entity) {
        if (entity instanceof LivingEntity || entity instanceof EntityHat) {
            CompoundNBT nbt = (entity instanceof EntityHat ? ((EntityHat)entity).hatPart : HatHandler.getHatPart((LivingEntity)entity)).write(new CompoundNBT());
            String nbtS = nbt.toString();
            StringTextComponent nbtStr = new StringTextComponent(nbtS);
            ClickEvent click = new ClickEvent(ClickEvent.Action.COPY_TO_CLIPBOARD, nbtS);
            nbtStr.func_230530_a_(nbtStr.func_150256_b().func_240715_a_(click).setUnderlined(Boolean.valueOf(true)));
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.getHat.value").func_230529_a_((ITextComponent)nbtStr), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.getHat.fail"), true);
        }
        return 1;
    }

    private static int addCount(CommandSource source, ServerPlayerEntity player, ArrayList<HatInfo> hatInfos, int count) {
        HatsSavedData.HatPart hatPart = CommandHats.getAsPart(hatInfos, count);
        if (hatInfos.size() > 1) {
            hatPart.count = 0;
        }
        HatHandler.addHat(player, hatPart);
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.addCount.success", new Object[]{hatInfos.get((int)(hatInfos.size() - 1)).name, player.func_200200_C_()}), true);
        return 1;
    }

    private static int remove(CommandSource source, ServerPlayerEntity player, ArrayList<HatInfo> hatInfos) {
        boolean flag = false;
        HatsSavedData.HatPart hatPart = CommandHats.getAsPart(hatInfos, 0);
        ArrayList<HatsSavedData.HatPart> playerInventory = HatHandler.getPlayerInventory((PlayerEntity)player);
        if (hatInfos.size() > 1) {
            for (HatsSavedData.HatPart part2 : playerInventory) {
                if (!part2.remove(new HatsSavedData.HatPart(hatInfos.get((int)(hatInfos.size() - 1)).name))) continue;
                flag = true;
                break;
            }
        } else if (playerInventory.removeIf(part -> hatPart.name.equals(part.name))) {
            flag = true;
        }
        if (flag) {
            HatHandler.markSaveDirty();
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.remove.success", new Object[]{hatInfos.get((int)(hatInfos.size() - 1)).name, player.func_200200_C_()}), true);
            Hats.channel.sendTo((AbstractPacket)new PacketUpdateHats(HatHandler.getPlayerHatsNBT((PlayerEntity)player), true), player);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.remove.fail", new Object[]{hatInfos.get((int)(hatInfos.size() - 1)).name, player.func_200200_C_()}), true);
        }
        return 1;
    }

    private static int clear(CommandSource source, ServerPlayerEntity player) {
        ArrayList<HatsSavedData.HatPart> playerInventory = HatHandler.getPlayerInventory((PlayerEntity)player);
        playerInventory.clear();
        HatHandler.markSaveDirty();
        source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.hats.clear.success", new Object[]{player.func_200200_C_()}), true);
        Hats.channel.sendTo((AbstractPacket)new PacketUpdateHats(HatHandler.getPlayerHatsNBT((PlayerEntity)player), true), player);
        return 1;
    }
}

