/*
 * Decompiled with CFR 0.152.
 */
package me.ichun.mods.hats.client.toast;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import me.ichun.mods.hats.common.Hats;
import me.ichun.mods.hats.common.hats.HatInfo;
import me.ichun.mods.hats.common.hats.HatResourceHandler;
import me.ichun.mods.hats.common.world.HatsSavedData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.gui.toasts.ToastGui;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class NewHatPartToast
implements IToast {
    private final HatsSavedData.HatPart hatDetails;
    private final ITextComponent title;
    private final List<ITextComponent> subtitles;
    private long firstDrawTime;
    private boolean newDisplay;

    public NewHatPartToast(HatsSavedData.HatPart hatDetails, boolean newHat, ArrayList<String> names) {
        this.hatDetails = hatDetails;
        String type = I18n.func_135052_a((String)(newHat ? "hats.toast.unlock.hat" : "hats.toast.unlock.accessory"), (Object[])new Object[0]);
        int template = Hats.configClient.hatUnlockString == 0 ? new Random().nextInt(5) + 1 : Hats.configClient.hatUnlockString;
        this.title = new TranslationTextComponent("hats.toast.unlock.template" + template, new Object[]{type});
        this.subtitles = new ArrayList<ITextComponent>();
        for (String name : names) {
            this.subtitles.add((ITextComponent)new StringTextComponent(name));
        }
    }

    public int func_238540_d_() {
        return 32 + Math.max(0, this.subtitles.size() - 1) * 12;
    }

    public IToast.Visibility func_230444_a_(MatrixStack stack, ToastGui toastGui, long delta) {
        if (this.newDisplay) {
            this.firstDrawTime = delta;
            this.newDisplay = false;
        }
        toastGui.func_192989_b().func_110434_K().func_110577_a(field_193654_a);
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        int i = this.func_230445_a_();
        int height = this.func_238540_d_();
        if (i == 160 && this.subtitles.size() <= 1) {
            toastGui.func_238474_b_(stack, 0, 0, 0, 0, i, height);
        } else {
            int k = this.func_238540_d_();
            int l = 28;
            int i1 = Math.min(4, k - 28);
            this.func_238533_a_(stack, toastGui, i, 0, 0, 28);
            for (int j1 = 28; j1 < k - i1; j1 += 10) {
                this.func_238533_a_(stack, toastGui, i, 16, j1, Math.min(10, k - j1 - i1));
            }
            this.func_238533_a_(stack, toastGui, i, 32 - i1, k - i1, i1);
        }
        HatInfo hatInfo = HatResourceHandler.getInfoAndSetToPart(this.hatDetails);
        if (hatInfo != null) {
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            stack.func_227860_a_();
            stack.func_227861_a_(15.0, (double)((float)height / 2.0f + 5.0f), 150.0);
            stack.func_227862_a_(16.0f, 16.0f, 16.0f);
            stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(-15.0f));
            stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(225.0f - (float)(delta - this.firstDrawTime) / 10.0f));
            IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            hatInfo.render(stack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0, OverlayTexture.field_229196_a_, false);
            irendertypebuffer$impl.func_228461_a_();
            stack.func_227865_b_();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableDepthTest();
        }
        float spacing = 28.0f;
        toastGui.func_192989_b().field_71466_p.func_243248_b(stack, this.title, spacing, 7.0f, -256);
        for (int k1 = 0; k1 < this.subtitles.size(); ++k1) {
            toastGui.func_192989_b().field_71466_p.func_243248_b(stack, this.subtitles.get(k1), spacing, (float)(18 + k1 * 12), -1);
        }
        return delta - this.firstDrawTime < 5000L ? IToast.Visibility.SHOW : IToast.Visibility.HIDE;
    }

    private void func_238533_a_(MatrixStack stack, ToastGui toastGui, int p_238533_3_, int p_238533_4_, int p_238533_5_, int p_238533_6_) {
        int texturePos = 0;
        int i = p_238533_4_ == 0 ? 20 : 5;
        int j = Math.min(60, p_238533_3_ - i);
        toastGui.func_238474_b_(stack, 0, p_238533_5_, 0, texturePos + p_238533_4_, i, p_238533_6_);
        for (int k = i; k < p_238533_3_ - j; k += 64) {
            toastGui.func_238474_b_(stack, k, p_238533_5_, 32, texturePos + p_238533_4_, Math.min(64, p_238533_3_ - k - j), p_238533_6_);
        }
        toastGui.func_238474_b_(stack, p_238533_3_ - j, p_238533_5_, 160 - j, texturePos + p_238533_4_, j, p_238533_6_);
    }
}

