/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.network;

import com.fuzs.puzzleslib_em.PuzzlesLib;
import com.fuzs.puzzleslib_em.network.message.Message;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class NetworkHandler {
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    private static final SimpleChannel MAIN_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("puzzleslibem", "main_channel"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
    private static final AtomicInteger DISCRIMINATOR = new AtomicInteger();

    public void registerMessage(Supplier<Message> supplier, LogicalSide executionSide) {
        MAIN_CHANNEL.registerMessage(DISCRIMINATOR.getAndIncrement(), supplier.get().getClass(), Message::write, buf -> ((Message)supplier.get()).getMessage((PacketBuffer)buf), (message, context) -> {
            NetworkEvent.Context ctx = (NetworkEvent.Context)context.get();
            assert (executionSide == ctx.getDirection().getReceptionSide()) : "Unable to handle " + message.getClass().getSimpleName() + " message: Received at wrong side";
            PlayerEntity player = PuzzlesLib.getProxy().getPlayer((PlayerEntity)ctx.getSender());
            ctx.enqueueWork(() -> message.process(player));
            ctx.setPacketHandled(true);
        });
    }

    public void sendToServer(Message message) {
        MAIN_CHANNEL.sendToServer((Object)message);
    }

    public void sendTo(Message message, ServerPlayerEntity player) {
        MAIN_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public void sendToAll(Message message) {
        MAIN_CHANNEL.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public void sendToAllNear(Message message, World world, BlockPos pos) {
        this.sendToAllNearExcept(message, world, pos, null);
    }

    public void sendToAllNearExcept(Message message, World world, BlockPos pos, @Nullable ServerPlayerEntity exclude) {
        PacketDistributor.TargetPoint targetPoint = new PacketDistributor.TargetPoint(exclude, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 64.0, world.func_234923_W_());
        MAIN_CHANNEL.send(PacketDistributor.NEAR.with(() -> targetPoint), (Object)message);
    }

    public void sendToDimension(Message message, World world) {
        this.sendToDimension(message, (RegistryKey<World>)world.func_234923_W_());
    }

    public void sendToDimension(Message message, RegistryKey<World> dimension) {
        MAIN_CHANNEL.send(PacketDistributor.DIMENSION.with(() -> dimension), (Object)message);
    }
}

