/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.puzzleslib_em.config;

import com.fuzs.puzzleslib_em.PuzzlesLib;
import com.fuzs.puzzleslib_em.config.ConfigBuilder;
import com.fuzs.puzzleslib_em.config.ConfigValueData;
import com.fuzs.puzzleslib_em.util.INamespaceLocator;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ConfigManager
implements INamespaceLocator {
    private static ConfigManager instance;
    private final Map<String, ConfigBuilder> configBuilders = Maps.newHashMap();
    private final Map<String, ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> configData = Maps.newHashMap();
    private final Multimap<ModConfig.Type, Runnable> configListeners = HashMultimap.create();

    private ConfigManager() {
    }

    public void load(String ... path) {
        if (path.length > 0) {
            this.getBuilder().moveToFolder(path);
        }
        this.getBuilder().registerConfigs(ModLoadingContext.get());
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onModConfig);
    }

    public void onModConfig(ModConfig.ModConfigEvent evt) {
        String modid = evt.getConfig().getModId();
        ModConfig.Type type = evt.getConfig().getType();
        if (this.getBuilder(modid).isSpecNotValid(type)) {
            PuzzlesLib.LOGGER.error("Unable to get values from " + type.extension() + " config for " + modid + " during " + (evt instanceof ModConfig.Loading ? "loading" : "reloading") + " phase: Config spec not present");
        } else if (this.syncAll(modid, type) && evt instanceof ModConfig.Reloading) {
            PuzzlesLib.LOGGER.info("Reloading " + type.extension() + " config for mod " + modid);
        }
    }

    public void syncAll(ModConfig.Type type) {
        if (this.syncAll(null, type)) {
            PuzzlesLib.LOGGER.info("Reloading " + type.extension() + " config for all mods");
        }
    }

    private boolean syncAll(@Nullable String modid, ModConfig.Type type) {
        List<ConfigValueData> typeData = this.getConfigData(modid).filter(configValue -> configValue.getType() == type).collect(Collectors.toList());
        if (!typeData.isEmpty()) {
            typeData.forEach(ConfigValueData::sync);
            this.configListeners.get((Object)type).forEach(Runnable::run);
            return true;
        }
        return false;
    }

    private Stream<ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> getConfigData(@Nullable String modid) {
        return this.configData.values().stream().filter(entry -> modid == null || entry.getModId().equals(modid));
    }

    public Object getValue(String ... paths) {
        return this.getValue(String.join((CharSequence)".", paths));
    }

    public Object getValue(String path) {
        return this.getConfigDataAtPath(path).map(ConfigValueData::getValue).orElse(null);
    }

    public Optional<ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> getConfigDataAtPath(String ... paths) {
        return this.getConfigDataAtPath(String.join((CharSequence)".", paths));
    }

    public Optional<ConfigValueData<? extends ForgeConfigSpec.ConfigValue<?>, ?, ?>> getConfigDataAtPath(String path) {
        Optional<ConfigValueData<ForgeConfigSpec.ConfigValue<?>, ?, ?>> optional = Optional.ofNullable(this.configData.get(path));
        if (optional.isPresent()) {
            return optional;
        }
        PuzzlesLib.LOGGER.error("Unable to get config value for path \"" + path + "\": No config value found for path");
        return Optional.empty();
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerCommonEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.COMMON, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerClientEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.CLIENT, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerServerEntry(S entry, Consumer<T> action) {
        this.registerEntry(ModConfig.Type.SERVER, entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T> void registerEntry(S entry, Consumer<T> action) {
        this.registerEntry(entry, action, Function.identity());
    }

    public <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void registerEntry(S entry, Consumer<R> action, Function<T, R> transformer) {
        ModConfig.Type activeType = this.getBuilder().getActiveType();
        if (activeType == null) {
            PuzzlesLib.LOGGER.error("Unable to register config entry: Active builder is null");
        } else if (this.getBuilder().isSpecNotBuilt(activeType)) {
            this.registerEntry(activeType, entry, action, transformer);
        } else {
            PuzzlesLib.LOGGER.error("Unable to register config entry: Config spec already built");
        }
    }

    private <S extends ForgeConfigSpec.ConfigValue<T>, T, R> void registerEntry(ModConfig.Type type, S entry, Consumer<R> action, Function<T, R> transformer) {
        this.configData.put(String.join((CharSequence)".", entry.getPath()), new ConfigValueData<S, T, R>(type, entry, action, transformer, this.getActiveNamespace()));
    }

    public void addListener(Runnable listener, ModConfig.Type type) {
        this.configListeners.put((Object)type, (Object)listener);
    }

    public static String getConfigName(String modId, ModConfig.Type type) {
        return String.format("%s-%s.toml", modId, type.extension());
    }

    public static String getConfigNameInFolder(String modId, ModConfig.Type type) {
        return modId + File.separator + ConfigManager.getConfigName(modId, type);
    }

    @SafeVarargs
    public static <T extends IForgeRegistryEntry<T>> List<String> getKeyList(T ... entries) {
        return Stream.of(entries).map(IForgeRegistryEntry::getRegistryName).filter(Objects::nonNull).map(ResourceLocation::toString).collect(Collectors.toList());
    }

    private ConfigBuilder getBuilder() {
        return this.getBuilder(this.getActiveNamespace());
    }

    private ConfigBuilder getBuilder(String modid) {
        return this.configBuilders.computeIfAbsent(modid, key -> new ConfigBuilder());
    }

    public static ConfigManager get() {
        if (instance == null) {
            instance = new ConfigManager();
        }
        return instance;
    }

    public static ConfigBuilder builder() {
        return ConfigManager.get().getBuilder();
    }
}

