/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.easymagic.element;

import com.fuzs.easymagic.network.message.SAnvilRepairMessage;
import com.fuzs.puzzleslib_em.PuzzlesLib;
import com.fuzs.puzzleslib_em.element.AbstractElement;
import com.fuzs.puzzleslib_em.element.side.ICommonElement;
import javax.annotation.Nullable;
import net.minecraft.block.AnvilBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.item.Item;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.Property;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;

public class AnvilTweaksElement
extends AbstractElement
implements ICommonElement {
    public static final Tags.IOptionalNamedTag<Item> ANVIL_REPAIR_MATERIALS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("easymagic", "anvil_repair_materials"));
    public static final Tags.IOptionalNamedTag<Item> ANVIL_REPAIR_CHANCE_MATERIALS = ItemTags.createOptional((ResourceLocation)new ResourceLocation("easymagic", "anvil_repair_chance_materials"));
    private boolean repairWithBlock;
    private boolean repairWithIngot;
    private int ingotRepairChance;

    @Override
    public String getDescription() {
        return "Some convenient tweaks for working with anvils.";
    }

    @Override
    public void setupCommon() {
        this.addListener(this::onRightClickBlock);
    }

    @Override
    public void initCommon() {
        PuzzlesLib.getNetworkHandler().registerMessage(SAnvilRepairMessage::new, LogicalSide.CLIENT);
    }

    @Override
    public void setupCommonConfig(ForgeConfigSpec.Builder builder) {
        AnvilTweaksElement.addToConfig(builder.comment("Using an iron block on a chipped or damaged anvil repairs it fully.").define("Iron Block Repairs Anvil", true), v -> {
            this.repairWithBlock = v;
        });
        AnvilTweaksElement.addToConfig(builder.comment("Using an iron ingot on a chipped or damaged anvil has a chance to repair it by one stage.").define("Iron Ingot Repairs Anvil", true), v -> {
            this.repairWithIngot = v;
        });
        AnvilTweaksElement.addToConfig(builder.comment("Chance one out of set value an attempt at repairing an anvil will be successful.").defineInRange("Anvil Repair Chance", 5, 1, Integer.MAX_VALUE), v -> {
            this.ingotRepairChance = v;
        });
    }

    private void onRightClickBlock(PlayerInteractEvent.RightClickBlock evt) {
        BlockPos blockPos;
        World world;
        BlockState blockState;
        boolean isRepairMaterial = evt.getItemStack().func_77973_b().func_206844_a(ANVIL_REPAIR_MATERIALS);
        boolean isRepairChanceMaterial = evt.getItemStack().func_77973_b().func_206844_a(ANVIL_REPAIR_CHANCE_MATERIALS);
        if (evt.getSide().isServer() && (this.repairWithBlock && isRepairMaterial || this.repairWithIngot && isRepairChanceMaterial) && (blockState = AnvilTweaksElement.repair((world = evt.getWorld()).func_180495_p(blockPos = evt.getPos()))) != null) {
            if (isRepairMaterial && blockState.func_203425_a(Blocks.field_196717_eY)) {
                blockState = AnvilTweaksElement.repair(blockState);
            }
            evt.setUseBlock(Event.Result.DENY);
            evt.setUseItem(Event.Result.DENY);
            if (!evt.getPlayer().field_71075_bZ.field_75098_d) {
                evt.getItemStack().func_190918_g(1);
            }
            if (isRepairMaterial || world.func_201674_k().nextInt(this.ingotRepairChance) == 0) {
                world.func_180501_a(blockPos, blockState, 2);
                SAnvilRepairMessage message = new SAnvilRepairMessage(blockPos, blockState);
                PuzzlesLib.getNetworkHandler().sendToAllNear(message, world, blockPos);
            } else if (world instanceof ServerWorld) {
                double randomOffset = 0.33;
                double posX = (double)blockPos.func_177958_n() + 0.5;
                double posY = (double)blockPos.func_177956_o() + 0.5;
                double posZ = (double)blockPos.func_177952_p() + 0.5;
                ((ServerWorld)world).func_195598_a((IParticleData)ParticleTypes.field_197601_L, posX, posY, posZ, 20, randomOffset, randomOffset, randomOffset, 0.0);
            }
        }
    }

    @Nullable
    private static BlockState repair(BlockState state) {
        if (state.func_203425_a(Blocks.field_196718_eZ)) {
            return (BlockState)Blocks.field_196717_eY.func_176223_P().func_206870_a((Property)AnvilBlock.field_176506_a, state.func_177229_b((Property)AnvilBlock.field_176506_a));
        }
        return state.func_203425_a(Blocks.field_196717_eY) ? (BlockState)Blocks.field_150467_bQ.func_176223_P().func_206870_a((Property)AnvilBlock.field_176506_a, state.func_177229_b((Property)AnvilBlock.field_176506_a)) : null;
    }
}

