/*
 * Decompiled with CFR 0.152.
 */
package com.fuzs.easymagic.client.renderer.tileentity;

import com.fuzs.easymagic.EasyMagic;
import com.fuzs.easymagic.client.element.EasyEnchantingExtension;
import com.fuzs.easymagic.element.EasyEnchantingElement;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.EnchantmentTableTileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.EnchantingTableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.World;

public class EnchantmentInventoryTileEntityRenderer
extends EnchantmentTableTileEntityRenderer {
    public EnchantmentInventoryTileEntityRenderer(TileEntityRendererDispatcher tileEntityRendererDispatcher) {
        super(tileEntityRendererDispatcher);
    }

    public void func_225616_a_(EnchantingTableTileEntity tileEntityIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        super.func_225616_a_(tileEntityIn, partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
        EasyEnchantingElement element = (EasyEnchantingElement)EasyMagic.EASY_ENCHANTING;
        if (!element.itemsStay) {
            return;
        }
        ItemStack itemToEnchant = ((IInventory)tileEntityIn).func_70301_a(0);
        ItemStack catalystItem = ((IInventory)tileEntityIn).func_70301_a(1);
        int catalystCount = Math.min(catalystItem.func_190916_E(), 3);
        switch (((EasyEnchantingExtension)element.extension).renderContentsType) {
            case FLAT: {
                List<ItemStack> flatItems = this.getInventoryItemList(itemToEnchant, catalystItem, catalystCount);
                this.renderFlatItemList(flatItems, tileEntityIn.func_174877_v(), matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn);
                break;
            }
            case FLOATING: {
                List<ItemStack> floatingItems = this.getInventoryItemList(itemToEnchant, catalystItem, catalystCount);
                this.renderHoveringItemList(floatingItems, (float)tileEntityIn.field_195522_a + partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, false);
                break;
            }
            case FANCY_FLOATING: {
                List<ItemStack> fancyFloatingItems = this.getInventoryItemList(ItemStack.field_190927_a, catalystItem, catalystCount);
                this.renderHoveringItem(itemToEnchant, tileEntityIn.func_145831_w(), (float)tileEntityIn.field_195522_a + partialTicks, matrixStackIn, bufferIn, combinedLightIn);
                this.renderHoveringItemList(fancyFloatingItems, (float)tileEntityIn.field_195522_a + partialTicks, matrixStackIn, bufferIn, combinedLightIn, combinedOverlayIn, true);
            }
        }
    }

    private List<ItemStack> getInventoryItemList(ItemStack itemToEnchant, ItemStack catalystItem, int catalystCount) {
        ArrayList<ItemStack> inventoryItems = new ArrayList<ItemStack>(4);
        inventoryItems.add(itemToEnchant);
        for (int i = 0; i < catalystCount; ++i) {
            inventoryItems.add(catalystItem);
        }
        inventoryItems.removeIf(ItemStack::func_190926_b);
        return inventoryItems;
    }

    private void renderFlatItemList(List<ItemStack> inventoryItems, BlockPos pos, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        int randomDirection = Math.abs(pos.func_177958_n() + pos.func_177952_p()) % 4;
        for (int i = 0; i < inventoryItems.size(); ++i) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 0.76171875, 0.5);
            Direction direction = Direction.func_176731_b((int)((i + randomDirection) % 4));
            float horizontalAngle = -direction.func_185119_l();
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(horizontalAngle));
            matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStackIn.func_227861_a_(-0.3125, -0.3125, 0.0);
            matrixStackIn.func_227862_a_(0.375f, 0.375f, 0.375f);
            ItemStack renderStack = inventoryItems.get(i);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(renderStack, ItemCameraTransforms.TransformType.FIXED, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderHoveringItemList(List<ItemStack> inventoryItems, float age, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn, boolean rotateItems) {
        float itemRenderAngle = 360.0f / (float)inventoryItems.size();
        for (int i = 0; i < inventoryItems.size(); ++i) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(0.5, 1.0, 0.5);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)i * itemRenderAngle + age));
            matrixStackIn.func_227861_a_(0.75, 0.0, 0.25);
            matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(rotateItems ? age % 360.0f : 90.0f));
            matrixStackIn.func_227861_a_(0.0, 0.075 * Math.sin(((double)age + (double)i * 10.0) / 5.0), 0.0);
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(inventoryItems.get(i), ItemCameraTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, matrixStackIn, bufferIn);
            matrixStackIn.func_227865_b_();
        }
    }

    private void renderHoveringItem(ItemStack itemToEnchant, @Nullable World worldIn, float age, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn) {
        matrixStackIn.func_227860_a_();
        matrixStackIn.func_227861_a_(0.5, 1.0, 0.5);
        IBakedModel model = Minecraft.func_71410_x().func_175599_af().func_184393_a(itemToEnchant, worldIn, null);
        float hoverOffset = MathHelper.func_76126_a((float)(age / 10.0f)) * 0.1f + 0.1f;
        float modelYScale = model.func_177552_f().func_181688_b((ItemCameraTransforms.TransformType)ItemCameraTransforms.TransformType.GROUND).field_178363_d.func_195900_b();
        matrixStackIn.func_227861_a_(0.0, (double)(hoverOffset + 0.25f * modelYScale), 0.0);
        matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(age / 20.0f));
        Minecraft.func_71410_x().func_175599_af().func_229111_a_(itemToEnchant, ItemCameraTransforms.TransformType.GROUND, false, matrixStackIn, bufferIn, combinedLightIn, OverlayTexture.field_229196_a_, model);
        matrixStackIn.func_227865_b_();
    }
}

