/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class NBTFilter
implements Predicate<CompoundNBT> {
    private final String key;
    private final Predicate<INBT> test;

    public NBTFilter(String key, Predicate<? extends INBT> test) {
        this.key = key;
        this.test = test;
    }

    public NBTFilter(String key, String value) {
        this(key, (? extends INBT tag) -> tag.func_150285_a_().equals(value));
    }

    @Override
    public boolean test(CompoundNBT tag) {
        return tag.func_74764_b(this.key) && this.test.test(tag.func_74781_a(this.key));
    }

    public static NBTFilter fromJson(JsonObject json) {
        String key = json.get("key").getAsString();
        JsonElement test = json.get("test");
        if (test.isJsonObject()) {
            return new NBTFilter(key, NBTFilter.fromJson(test.getAsJsonObject()));
        }
        return new NBTFilter(key, test.getAsString());
    }
}

