/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.plant;

import com.google.common.collect.Maps;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGene;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AgriGenomeRenderer
implements IRenderUtilities {
    private static final AgriGenomeRenderer INSTANCE = new AgriGenomeRenderer();
    private static final float PI = (float)Math.PI;
    public static final float RADIANS_PER_GENE = 0.5235988f;
    public static final int POINTS_PER_GENE = 10;
    public static final float THICKNESS_ACTIVE = 2.5f;
    public static final float THICKNESS_INACTIVE = 1.5f;
    public static final Vector3f COLOR_INACTIVE = new Vector3f(0.15f, 0.15f, 0.15f);
    public static final Style STYLE_GENE = Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true)).setUnderlined(Boolean.valueOf(true));
    public static final IReorderingProcessor TEXT_SEPARATOR = new StringTextComponent(" - ").func_240703_c_(Style.field_240709_b_.func_240713_a_(Boolean.valueOf(true))).func_241878_f();
    private final Map<IAgriGene<?>, Tuple<Style, Style>> textFormats = Maps.newIdentityHashMap();

    public static AgriGenomeRenderer getInstance() {
        return INSTANCE;
    }

    private AgriGenomeRenderer() {
    }

    public void renderDoubleHelix(List<IAgriGenePair<?>> genePairs, MatrixStack transforms, int index, float transition, float radius, float height, float alpha, boolean color) {
        IRenderTypeBuffer.Impl buffer = this.getRenderTypeBuffer();
        this.renderDoubleHelix(genePairs, transforms, (IRenderTypeBuffer)buffer, index, transition, radius, height, alpha, color);
        LineRenderType.finish(buffer);
    }

    public void renderDoubleHelix(List<IAgriGenePair<?>> genePairs, MatrixStack transforms, IRenderTypeBuffer buffer, int index, float transition, float radius, float height, float alpha, boolean color) {
        int count = genePairs.size();
        if (count == 0 || radius == 0.0f || height == 0.0f) {
            return;
        }
        int points = 10 * count;
        float heightStep = (height + 0.0f) / (float)points;
        float angleStep = -0.05235988f;
        float angleOffset = 0.2617994f;
        float rotation = ((float)index + transition) * 0.5235988f;
        transforms.func_227860_a_();
        transforms.func_227863_a_(new Quaternion(Vector3f.field_229181_d_, rotation, false));
        Matrix4f matrix = transforms.func_227866_c_().func_227870_a_();
        this.drawHelix(genePairs, index, radius, angleOffset, heightStep, angleStep, points, buffer, matrix, true, alpha, color);
        this.drawHelix(genePairs, index, radius, (float)Math.PI + angleOffset, heightStep, angleStep, points, buffer, matrix, false, alpha, color);
        this.drawSpokes(genePairs, index, radius, angleOffset, (float)Math.PI + angleOffset, heightStep, angleStep, buffer, matrix, alpha, color);
        transforms.func_227865_b_();
    }

    public void renderTextOverlay(MatrixStack transforms, IAgriGenePair<?> genePair) {
        FontRenderer fontRenderer = this.getFontRenderer();
        Tuple<Style, Style> textFormats = this.getTextFormats(genePair.getGene());
        int blackColor = STYLE_GENE.func_240711_a_() == null ? 0 : STYLE_GENE.func_240711_a_().func_240742_a_();
        int domColor = ((Style)textFormats.func_76341_a()).func_240711_a_() == null ? 0 : ((Style)textFormats.func_76341_a()).func_240711_a_().func_240742_a_();
        int recColor = ((Style)textFormats.func_76340_b()).func_240711_a_() == null ? 0 : ((Style)textFormats.func_76340_b()).func_240711_a_().func_240742_a_();
        IReorderingProcessor geneText = genePair.getGene().getGeneDescription().func_240703_c_(STYLE_GENE).func_241878_f();
        IReorderingProcessor domText = genePair.getDominant().getTooltip().func_241878_f();
        IReorderingProcessor recText = genePair.getRecessive().getTooltip().func_241878_f();
        float y1 = 0.0f;
        float x1 = ((float)(-fontRenderer.func_243245_a(geneText)) + 0.0f) / 2.0f;
        fontRenderer.getClass();
        float y2 = y1 + 1.5f * 9.0f;
        float x2 = ((float)(-fontRenderer.func_243245_a(TEXT_SEPARATOR)) + 0.0f) / 2.0f;
        float delta = 1.0f;
        float dx_d = delta + (float)fontRenderer.func_243245_a(domText);
        float dx_r = delta + (float)fontRenderer.func_243245_a(TEXT_SEPARATOR);
        this.getFontRenderer().func_238422_b_(transforms, geneText, x1, y1, blackColor);
        this.getFontRenderer().func_238422_b_(transforms, TEXT_SEPARATOR, x2, y2, blackColor);
        this.getFontRenderer().func_238422_b_(transforms, domText, x2 - dx_d, y2, blackColor);
        this.getFontRenderer().func_238422_b_(transforms, recText, x2 + dx_r, y2, blackColor);
    }

    protected void drawHelix(List<IAgriGenePair<?>> genePairs, int active, float radius, float phase, float dHeight, float dAngle, int points, IRenderTypeBuffer buffer, Matrix4f matrix, boolean dominant, float alpha, boolean color) {
        float x_1 = radius * MathHelper.func_76134_b((float)(-phase));
        float y_1 = dHeight * (float)points;
        float z_1 = radius * MathHelper.func_76126_a((float)(-phase));
        for (int i = 0; i < points; ++i) {
            float f;
            int index = i / 10;
            int partial = i % 10;
            IAgriGene<?> gene = genePairs.get(index).getGene();
            Vector3f colorVec = this.getColor(gene, index == active, dominant, color);
            float r = colorVec.func_195899_a();
            float g = colorVec.func_195900_b();
            float b = colorVec.func_195902_c();
            float w = this.getLineWidth(index == active);
            if (partial < 5) {
                int prevIndex = index - 1 < 0 ? index : index - 1;
                IAgriGene<?> prevGene = genePairs.get(prevIndex).getGene();
                Vector3f prevColor = this.getColor(prevGene, prevIndex == active, dominant, color);
                float prevWidth = this.getLineWidth(prevIndex == active);
                f = ((float)partial + 5.0f) / 10.0f;
                r = MathHelper.func_219799_g((float)f, (float)prevColor.func_195899_a(), (float)r);
                g = MathHelper.func_219799_g((float)f, (float)prevColor.func_195900_b(), (float)g);
                b = MathHelper.func_219799_g((float)f, (float)prevColor.func_195902_c(), (float)b);
                w = MathHelper.func_219799_g((float)f, (float)prevWidth, (float)w);
            } else if (partial > 5) {
                int nextIndex = index + 1 >= genePairs.size() ? index : index + 1;
                IAgriGene<?> nextGene = genePairs.get(nextIndex).getGene();
                Vector3f nextColor = this.getColor(nextGene, nextIndex == active, dominant, color);
                float nextWidth = this.getLineWidth(nextIndex == active);
                f = ((float)partial - 5.0f) / 10.0f;
                r = MathHelper.func_219799_g((float)f, (float)r, (float)nextColor.func_195899_a());
                g = MathHelper.func_219799_g((float)f, (float)g, (float)nextColor.func_195900_b());
                b = MathHelper.func_219799_g((float)f, (float)b, (float)nextColor.func_195902_c());
                w = MathHelper.func_219799_g((float)f, (float)w, (float)nextWidth);
            }
            float x_2 = radius * MathHelper.func_76134_b((float)(-((float)(1 + i) * dAngle + phase)));
            float y_2 = dHeight * (float)(points - i);
            float z_2 = radius * MathHelper.func_76126_a((float)(-((float)(1 + i) * dAngle + phase)));
            this.addVertex(buffer, matrix, x_1, y_1, z_1, r, g, b, alpha, w);
            this.addVertex(buffer, matrix, x_2, y_2, z_2, r, g, b, alpha, w);
            x_1 = x_2;
            y_1 = y_2;
            z_1 = z_2;
        }
    }

    protected void drawSpokes(List<IAgriGenePair<?>> genePairs, int active, float radius, float phase1, float phase2, float dHeight, float dAngle, IRenderTypeBuffer buffer, Matrix4f matrix, float alpha, boolean color) {
        for (int spoke = 0; spoke < genePairs.size(); ++spoke) {
            int i = spoke * 10 + 5;
            float angle = (float)i * dAngle;
            float x1 = radius * MathHelper.func_76134_b((float)(-(angle + phase1)));
            float x2 = radius * MathHelper.func_76134_b((float)(-(angle + phase2)));
            float y = dHeight * (float)(10 * genePairs.size() - i);
            float z1 = radius * MathHelper.func_76126_a((float)(-(angle + phase1)));
            float z2 = radius * MathHelper.func_76126_a((float)(-(angle + phase2)));
            IAgriGene<?> gene = genePairs.get(spoke).getGene();
            Vector3f dom = this.getColor(gene, active == spoke, true, color);
            Vector3f rec = this.getColor(gene, active == spoke, false, color);
            float w = this.getLineWidth(active == spoke);
            this.addVertex(buffer, matrix, x1, y, z1, dom.func_195899_a(), dom.func_195900_b(), dom.func_195902_c(), alpha, w);
            for (int j = 1; j < 10; ++j) {
                float x = MathHelper.func_219799_g((float)(((float)j + 0.0f) / 10.0f), (float)x1, (float)x2);
                float z = MathHelper.func_219799_g((float)(((float)j + 0.0f) / 10.0f), (float)z1, (float)z2);
                float r = MathHelper.func_219799_g((float)(((float)j + 0.0f) / 10.0f), (float)dom.func_195899_a(), (float)rec.func_195899_a());
                float g = MathHelper.func_219799_g((float)(((float)j + 0.0f) / 10.0f), (float)dom.func_195900_b(), (float)rec.func_195900_b());
                float b = MathHelper.func_219799_g((float)(((float)j + 0.0f) / 10.0f), (float)dom.func_195902_c(), (float)rec.func_195902_c());
                this.addVertex(buffer, matrix, x, y, z, r, g, b, alpha, w);
                this.addVertex(buffer, matrix, x, y, z, r, g, b, alpha, w);
            }
            this.addVertex(buffer, matrix, x2, y, z2, rec.func_195899_a(), rec.func_195900_b(), rec.func_195902_c(), alpha, w);
        }
    }

    protected void addVertex(IRenderTypeBuffer buffer, Matrix4f matrix, float x, float y, float z, float r, float g, float b, float a, float w) {
        IVertexBuilder builder = this.getVertexBuilder(buffer, this.getRenderType(w));
        builder.func_227888_a_(matrix, x, y, z).func_227885_a_(r, g, b, a).func_181675_d();
    }

    protected Vector3f getColor(IAgriGene<?> gene, boolean active, boolean dominant, boolean ignoreActive) {
        if (ignoreActive || active) {
            return dominant ? gene.getDominantColor() : gene.getRecessiveColor();
        }
        return COLOR_INACTIVE;
    }

    protected float getLineWidth(boolean active) {
        return active ? 2.5f : 1.5f;
    }

    protected RenderType getRenderType(float width) {
        return LineRenderType.get(width);
    }

    protected Tuple<Style, Style> getTextFormats(IAgriGene<?> gene) {
        return this.textFormats.computeIfAbsent(gene, aGene -> new Tuple((Object)Style.field_240709_b_.func_240718_a_(this.convertColor(aGene.getDominantColor())), (Object)Style.field_240709_b_.func_240718_a_(this.convertColor(aGene.getRecessiveColor()))));
    }

    public static class LineRenderType
    extends RenderType {
        private static final Map<Float, RenderType> CACHE = Maps.newConcurrentMap();
        private static final String RENDER_TYPE_KEY = AgriCraft.instance.getModId() + ":genome_lines";

        private LineRenderType(String nameIn, VertexFormat formatIn, int drawModeIn, int bufferSizeIn, boolean useDelegateIn, boolean needsSortingIn, Runnable setupTaskIn, Runnable clearTaskIn) {
            super(nameIn, formatIn, drawModeIn, bufferSizeIn, useDelegateIn, needsSortingIn, setupTaskIn, clearTaskIn);
        }

        public static RenderType get(float width) {
            return CACHE.computeIfAbsent(Float.valueOf(width), aFloat -> LineRenderType.func_228632_a_((String)(RENDER_TYPE_KEY + "_" + aFloat), (VertexFormat)DefaultVertexFormats.field_181706_f, (int)1, (int)256, (RenderType.State)RenderType.State.func_228694_a_().func_228720_a_(new RenderState.LineState(OptionalDouble.of(aFloat.floatValue()))).func_228718_a_(field_239235_M_).func_228726_a_(field_228515_g_).func_228721_a_(field_241712_U_).func_228727_a_(field_228495_E_).func_228728_a_(false)));
        }

        public static void finish(IRenderTypeBuffer.Impl buffer) {
            CACHE.values().forEach(arg_0 -> ((IRenderTypeBuffer.Impl)buffer).func_228462_a_(arg_0));
        }
    }
}

