/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.render.items.magnfiyingglass;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.client.IMagnifyingGlassInspector;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.impl.v1.requirement.NoSoil;
import com.infinityraider.agricraft.render.items.journal.JournalDataDrawerBase;
import com.infinityraider.infinitylib.render.IRenderUtilities;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class MagnifyingGlassSoilInspector
implements IMagnifyingGlassInspector,
IRenderUtilities {
    private static final Quaternion FLIP_Y = Vector3f.field_229183_f_.func_229187_a_(180.0f);
    private static final float DELTA_Y = 0.02f;
    private static final float ICON_SCALE = 6.8359374E-4f;
    private static final float TEXT_SCALE = 0.65f;
    private IAgriSoil cachedSoil;

    public static void init() {
        IMagnifyingGlassInspector.registerInspector(new MagnifyingGlassSoilInspector());
    }

    protected MagnifyingGlassSoilInspector() {
    }

    @Override
    public boolean canInspect(World world, BlockPos pos, PlayerEntity player) {
        return AgriApi.getSoil((IBlockReader)world, pos).map(IAgriSoil::isSoil).orElse(false);
    }

    @Override
    public boolean canInspect(World world, Entity entity, PlayerEntity player) {
        return false;
    }

    @Override
    public void onInspectionStart(World world, BlockPos pos, PlayerEntity player) {
        this.cachedSoil = AgriApi.getSoil((IBlockReader)world, pos).orElse(NoSoil.getInstance());
    }

    @Override
    public void onInspectionStart(World world, Entity entity, PlayerEntity player) {
    }

    @Override
    public boolean onInspectionTick(World world, BlockPos pos, PlayerEntity player) {
        return this.cachedSoil != null && this.cachedSoil.isSoil();
    }

    @Override
    public boolean onInspectionTick(World world, Entity entity, PlayerEntity player) {
        return false;
    }

    @Override
    public void onInspectionEnd(World world, BlockPos pos, PlayerEntity player) {
        this.cachedSoil = null;
    }

    @Override
    public void onInspectionEnd(World world, @Nullable Entity entity, PlayerEntity player) {
    }

    @Override
    public void onMouseScroll(int delta) {
    }

    @Override
    public void doInspectionRender(MatrixStack transforms, float partialTick, @Nullable Entity entity) {
        IAgriSoil soil = this.cachedSoil;
        if (soil == null || !soil.isSoil()) {
            return;
        }
        transforms.func_227860_a_();
        transforms.func_227863_a_(FLIP_Y);
        transforms.func_227861_a_(0.0, (double)0.02f, 0.0);
        this.drawSoilPropertyIcons(transforms, soil);
        this.drawSoilPropertyText(transforms, soil);
        transforms.func_227865_b_();
    }

    protected void drawSoilPropertyIcons(MatrixStack transforms, IAgriSoil soil) {
        transforms.func_227860_a_();
        transforms.func_227861_a_(0.0, (double)-0.06f, 0.0);
        this.drawSoilProperty(transforms, soil.getHumidity(), IAgriSoil.Humidity.values(), JournalDataDrawerBase.Textures.HUMIDITY_FILLED, JournalDataDrawerBase.Textures.HUMIDITY_EMPTY, JournalDataDrawerBase.Textures.HUMIDITY_OFFSETS);
        transforms.func_227861_a_(0.0, (double)0.02f, 0.0);
        this.drawSoilProperty(transforms, soil.getAcidity(), IAgriSoil.Acidity.values(), JournalDataDrawerBase.Textures.ACIDITY_FILLED, JournalDataDrawerBase.Textures.ACIDITY_EMPTY, JournalDataDrawerBase.Textures.ACIDITY_OFFSETS);
        transforms.func_227861_a_(0.0, (double)0.02f, 0.0);
        this.drawSoilProperty(transforms, soil.getNutrients(), IAgriSoil.Nutrients.values(), JournalDataDrawerBase.Textures.NUTRIENTS_FILLED, JournalDataDrawerBase.Textures.NUTRIENTS_EMPTY, JournalDataDrawerBase.Textures.NUTRIENTS_OFFSETS);
        transforms.func_227865_b_();
    }

    protected void drawSoilPropertyText(MatrixStack transforms, IAgriSoil soil) {
        transforms.func_227860_a_();
        float width = this.getScaledWindowWidth();
        float height = this.getScaledWindowHeight();
        float scale = 0.65f / Math.max(width, height);
        transforms.func_227862_a_(scale, scale, scale);
        float dy = 0.02f / scale;
        transforms.func_227861_a_(0.0, -2.5 * (double)dy, 0.0);
        this.renderText(transforms, soil.getHumidity().getDescription().func_241878_f());
        transforms.func_227861_a_(0.0, (double)dy, 0.0);
        this.renderText(transforms, soil.getAcidity().getDescription().func_241878_f());
        transforms.func_227861_a_(0.0, (double)dy, 0.0);
        this.renderText(transforms, soil.getNutrients().getDescription().func_241878_f());
        transforms.func_227865_b_();
    }

    protected <T extends IAgriSoil.SoilProperty> void drawSoilProperty(MatrixStack transforms, T property, T[] properties, ResourceLocation filledTexture, ResourceLocation emptyTexture, int[] textureOffsets) {
        for (int i = 0; i < properties.length - 1; ++i) {
            int dx = textureOffsets[i];
            int w = textureOffsets[i + 1] - textureOffsets[i];
            float u1 = ((float)dx + 0.0f) / 53.0f;
            float u2 = ((float)(dx + w) + 0.0f) / 53.0f;
            if (property == properties[i]) {
                this.drawSoilPropertyTexture(transforms, filledTexture, (float)dx - 26.5f, w, u1, u2);
                continue;
            }
            this.drawSoilPropertyTexture(transforms, emptyTexture, (float)dx - 26.5f, w, u1, u2);
        }
    }

    protected void drawSoilPropertyTexture(MatrixStack transforms, ResourceLocation texture, float x, float w, float u1, float u2) {
        this.bindTexture(texture);
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        Matrix4f matrix = transforms.func_227866_c_().func_227870_a_();
        float x1 = x * 6.8359374E-4f;
        float y1 = 0.0f;
        float x2 = x1 + w * 6.8359374E-4f;
        float y2 = y1 + 0.008203125f;
        float v1 = 0.0f;
        float v2 = 1.0f;
        bufferbuilder.func_227888_a_(matrix, x1, y2, 0.0f).func_225583_a_(u1, v2).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y2, 0.0f).func_225583_a_(u2, v2).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x2, y1, 0.0f).func_225583_a_(u2, v1).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x1, y1, 0.0f).func_225583_a_(u1, v1).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public void renderText(MatrixStack transforms, IReorderingProcessor text) {
        FontRenderer fontRenderer = this.getFontRenderer();
        float x = ((float)(-fontRenderer.func_243245_a(text)) + 0.0f) / 2.0f;
        int color = 0;
        this.getFontRenderer().func_238422_b_(transforms, text, x, 0.0f, color);
    }
}

