/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.minecraft;

import com.google.common.collect.ImmutableList;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneRegistry;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import com.infinityraider.agricraft.api.v1.plugin.AgriPlugin;
import com.infinityraider.agricraft.api.v1.plugin.IAgriPlugin;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.plugins.minecraft.ChickenBreedItemInjector;
import com.infinityraider.agricraft.plugins.minecraft.GeneAnimalAttractant;
import com.infinityraider.agricraft.plugins.minecraft.GenomeWrapper;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackBrightness;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackBurn;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackBushy;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackExperience;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackFungus;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackPoisoning;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackRedstone;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackThorns;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackTree;
import com.infinityraider.agricraft.plugins.minecraft.JsonPlantCallBackWithering;
import com.infinityraider.agricraft.plugins.minecraft.SeedWrapper;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.block.ComposterBlock;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.PandaEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;

@AgriPlugin(modId="minecraft", alwaysLoad=true)
public class MinecraftPlugin
implements IAgriPlugin {
    public final IJsonPlantCallback.Factory brightness = JsonPlantCallBackBrightness.getFactory();
    public final IJsonPlantCallback.Factory burn = JsonPlantCallBackBurn.getFactory();
    public final IJsonPlantCallback.Factory bushy = JsonPlantCallBackBushy.getFactory();
    public final IJsonPlantCallback.Factory experience = JsonPlantCallBackExperience.getFactory();
    public final IJsonPlantCallback.Factory fungus = JsonPlantCallBackFungus.getFactory();
    public final IJsonPlantCallback.Factory tree = JsonPlantCallBackTree.getFactory();
    public final IJsonPlantCallback.Factory poisoning = JsonPlantCallBackPoisoning.getFactory();
    public final IJsonPlantCallback.Factory redstone = JsonPlantCallBackRedstone.getFactory();
    public final IJsonPlantCallback.Factory thorns = JsonPlantCallBackThorns.getFactory();
    public final IJsonPlantCallback.Factory withering = JsonPlantCallBackWithering.getFactory();

    protected void registerCallBackFactories() {
        Arrays.stream(this.getClass().getDeclaredFields()).map(f -> {
            try {
                return f.get(this);
            }
            catch (Exception e) {
                return null;
            }
        }).filter(obj -> obj instanceof IJsonPlantCallback.Factory).map(obj -> ((IJsonPlantCallback.Factory)obj).register()).filter(Objects::nonNull).map(IJsonPlantCallback.Factory::getId).forEach(id -> AgriCraft.instance.getLogger().info("Registered Json Callback: " + id, new Object[0]));
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String getId() {
        return "vanilla";
    }

    @Override
    public String getDescription() {
        return "Vanilla Minecraft Integration";
    }

    @Override
    public void onCommonSetupEvent(FMLCommonSetupEvent event) {
        this.registerCallBackFactories();
        float compostValue = ((Config)AgriCraft.instance.getConfig()).seedCompostValue();
        if (compostValue > 0.0f) {
            ComposterBlock.field_220299_b.put((Object)AgriCraft.instance.getModItemRegistry().seed, compostValue);
        }
        ChickenBreedItemInjector.inject();
    }

    @Override
    public void registerGenomes(@Nonnull IAgriAdapterizer<IAgriGenome> adapterizer) {
        adapterizer.registerAdapter(new SeedWrapper());
        adapterizer.registerAdapter(new GenomeWrapper());
    }

    @Override
    public void registerGenes(@Nonnull IAgriGeneRegistry geneRegistry) {
        if (((Config)AgriCraft.instance.getConfig()).enableAnimalAttractingCrops()) {
            geneRegistry.add(new GeneAnimalAttractant("cow", CowEntity.class, (List<String>)ImmutableList.of((Object)"vanilla:wheat_plant"), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
            geneRegistry.add(new GeneAnimalAttractant("pig", PigEntity.class, (List<String>)ImmutableList.of((Object)"vanilla:beet_root_plant", (Object)"vanilla:carrot_plant", (Object)"vanilla:potato_plant"), new Vector3f(1.0f, 0.0f, 0.8745098f), new Vector3f(1.0f, 0.52156866f, 0.9411765f)));
            geneRegistry.add(new GeneAnimalAttractant("sheep", SheepEntity.class, (List<String>)ImmutableList.of((Object)"vanilla:wheat_plant"), new Vector3f(1.0f, 1.0f, 1.0f), new Vector3f(0.48235294f, 0.3254902f, 0.09803922f)));
            geneRegistry.add(new GeneAnimalAttractant("chicken", ChickenEntity.class, (List<String>)ImmutableList.of((Object)"vanilla:melon_plant", (Object)"vanilla:pumpkin_plant"), new Vector3f(1.0f, 0.6666667f, 0.3764706f), new Vector3f(0.99215686f, 0.7882353f, 0.627451f)));
            geneRegistry.add(new GeneAnimalAttractant("rabbit", RabbitEntity.class, (List<String>)ImmutableList.of((Object)"vanilla:carrot_plant", (Object)"vanilla:dandelion_plant"), new Vector3f(0.3254902f, 0.18039216f, 0.0f), new Vector3f(0.48235294f, 0.3254902f, 0.09803922f)));
            geneRegistry.add(new GeneAnimalAttractant("panda", PandaEntity.class, (List<String>)ImmutableList.of((Object)"vanilla:bamboo_plant"), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(1.0f, 1.0f, 1.0f)));
            geneRegistry.add(new GeneAnimalAttractant("turtle", TurtleEntity.class, (List<String>)ImmutableList.of((Object)"vanilla:sea_grass_plant", (Object)"vanilla:kelp_plant"), new Vector3f(0.047058824f, 0.3137255f, 0.0f), new Vector3f(0.5647059f, 0.3764706f, 0.21176471f)));
        }
    }
}

