/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.agrigui.analyzer;

import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.content.items.IAgriSeedItem;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneCarrierItem;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenePair;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.content.core.TileEntitySeedAnalyzer;
import com.infinityraider.agricraft.plugins.agrigui.GuiPlugin;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class SeedAnalyzerContainer
extends Container {
    private final IItemHandler playerInventory;
    private final TileEntitySeedAnalyzer seedAnalyzer;
    private final BlockPos seedAnalyzerPos;
    private final ItemStackHandler seedHandler;
    private final ItemStackHandler journalHandler;

    public SeedAnalyzerContainer(int id, World world, PlayerInventory playerInventory, BlockPos seedAnalyzerPos) {
        super((ContainerType)GuiPlugin.SEED_ANALYZER_CONTAINER.get(), id);
        this.playerInventory = new InvWrapper((IInventory)playerInventory);
        this.seedAnalyzerPos = seedAnalyzerPos;
        this.seedAnalyzer = (TileEntitySeedAnalyzer)world.func_175625_s(seedAnalyzerPos);
        this.seedHandler = new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof IAgriSeedItem;
            }

            protected void onContentsChanged(int slot) {
                if (!SeedAnalyzerContainer.this.journalHandler.getStackInSlot(0).func_190926_b()) {
                    ItemStack journalStack = SeedAnalyzerContainer.this.journalHandler.extractItem(0, 64, false);
                    Optional<ItemStack> newJournal = TileEntitySeedAnalyzer.addSeedToJournal(this.getStackInSlot(slot).func_77946_l(), journalStack);
                    if (newJournal.isPresent()) {
                        SeedAnalyzerContainer.this.journalHandler.insertItem(0, newJournal.get(), false);
                    } else {
                        SeedAnalyzerContainer.this.journalHandler.insertItem(0, journalStack, false);
                    }
                }
                super.onContentsChanged(slot);
            }
        };
        this.journalHandler = new ItemStackHandler(1){

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return stack.func_77973_b() instanceof IAgriJournalItem;
            }
        };
        if (this.seedAnalyzer.hasSeed()) {
            this.seedHandler.insertItem(0, this.seedAnalyzer.extractSeed(), false);
        }
        if (this.seedAnalyzer.hasJournal()) {
            this.journalHandler.insertItem(0, this.seedAnalyzer.extractJournal(), false);
        }
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.seedHandler, 0, 26, 38));
        this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.journalHandler, 0, 26, 71));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new SlotItemHandler(this.playerInventory, 9 + 9 * y + x, 13 + 18 * x, 104 + 18 * y));
            }
        }
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a((Slot)new SlotItemHandler(this.playerInventory, i, 13 + 18 * i, 162));
        }
    }

    public List<IAgriGenePair<?>> getGeneToRender() {
        ItemStack seed = this.seedHandler.getStackInSlot(0).func_77946_l();
        if (seed.func_190926_b()) {
            return Collections.emptyList();
        }
        return ((IAgriGeneCarrierItem)seed.func_77973_b()).getGenome(seed).map(IAgriGenome::getGeneList).orElse(Collections.emptyList());
    }

    public boolean func_75145_c(PlayerEntity player) {
        return player.func_70092_e((double)this.seedAnalyzerPos.func_177958_n(), (double)this.seedAnalyzerPos.func_177956_o(), (double)this.seedAnalyzerPos.func_177952_p()) < 8.0;
    }

    public void func_75134_a(@Nonnull PlayerEntity player) {
        if (player instanceof ServerPlayerEntity) {
            ItemStack journalStack;
            ItemStack seedStack = this.seedHandler.extractItem(0, 64, false);
            if (!seedStack.func_190926_b()) {
                this.seedAnalyzer.insertSeed(seedStack);
            }
            if (!(journalStack = this.journalHandler.extractItem(0, 64, false)).func_190926_b()) {
                this.seedAnalyzer.insertJournal(journalStack);
            }
        }
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity playerIn, int index) {
        ItemStack itemStack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack slotStack = slot.func_75211_c();
            itemStack = slotStack.func_77946_l();
            if (index <= 1 ? !this.func_75135_a(slotStack, 2, 38, true) : index <= 38 && (slotStack.func_77973_b() instanceof IAgriSeedItem ? !this.func_75135_a(slotStack, 0, 1, false) : slotStack.func_77973_b() instanceof IAgriJournalItem && !this.func_75135_a(slotStack, 1, 2, false))) {
                return ItemStack.field_190927_a;
            }
            if (slotStack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slotStack.func_190916_E() == itemStack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(playerIn, slotStack);
        }
        return itemStack;
    }
}

