/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.plugins.agrigui;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.plugin.AgriPlugin;
import com.infinityraider.agricraft.api.v1.plugin.IAgriPlugin;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.plugins.agrigui.analyzer.SeedAnalyzerContainer;
import com.infinityraider.agricraft.plugins.agrigui.analyzer.SeedAnalyzerScreen;
import com.infinityraider.agricraft.plugins.agrigui.journal.GuiCompatClient;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@OnlyIn(value=Dist.CLIENT)
@AgriPlugin(modId="minecraft", alwaysLoad=true)
public class GuiPlugin
implements IAgriPlugin {
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"agricraft");
    public static final RegistryObject<ContainerType<SeedAnalyzerContainer>> SEED_ANALYZER_CONTAINER = CONTAINERS.register("seed_analyzer_container", () -> IForgeContainerType.create((id, inv, data) -> new SeedAnalyzerContainer(id, inv.field_70458_d.func_130014_f_(), inv, data.func_179259_c())));

    public GuiPlugin() {
        CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @Override
    public boolean isEnabled() {
        return ((Config)AgriCraft.instance.getConfig()).useGUIsInsteadOfAnimation();
    }

    @Override
    public String getId() {
        return "agrigui";
    }

    @Override
    public String getDescription() {
        return "Add guis to agricraft (journal & analyzer)";
    }

    @Override
    public void onClientSetupEvent(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a((ContainerType)((ContainerType)SEED_ANALYZER_CONTAINER.get()), SeedAnalyzerScreen::new);
    }

    @Override
    public void onCommonSetupEvent(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onSeedAnalyzerRightClick);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGHEST, this::onBookRightClick);
    }

    public void onBookRightClick(PlayerInteractEvent.RightClickItem event) {
        if (!event.getPlayer().field_70170_p.field_72995_K || event.getPlayer().func_225608_bj_()) {
            return;
        }
        if (event.getItemStack().func_77973_b() != AgriCraft.instance.getModItemRegistry().journal.toItem()) {
            return;
        }
        event.setCancellationResult(ActionResultType.SUCCESS);
        event.setCanceled(true);
        GuiCompatClient.openScreen(event.getPlayer(), event.getHand());
    }

    public void onSeedAnalyzerRightClick(final PlayerInteractEvent.RightClickBlock event) {
        final BlockPos pos = event.getPos();
        BlockState state = event.getWorld().func_180495_p(pos);
        if (event.getPlayer().func_225608_bj_()) {
            return;
        }
        if (state.func_177230_c() != AgriCraft.instance.getModBlockRegistry().seed_analyzer.getBlock()) {
            return;
        }
        event.setCancellationResult(ActionResultType.SUCCESS);
        event.setCanceled(true);
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        INamedContainerProvider containerProvider = new INamedContainerProvider(){

            @Nonnull
            public ITextComponent func_145748_c_() {
                return new TranslationTextComponent("screen.agricraft.seed_analyzer");
            }

            public Container createMenu(int id, @Nonnull PlayerInventory playerInventory, @Nonnull PlayerEntity player) {
                return new SeedAnalyzerContainer(id, event.getWorld(), playerInventory, pos);
            }
        };
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)event.getPlayer()), (INamedContainerProvider)containerProvider, (BlockPos)pos);
    }
}

