/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.agricraft.agricore.config.AgriConfigAdapter;
import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.json.AgriLoader;
import com.agricraft.agricore.plant.AgriMutation;
import com.agricraft.agricore.plant.AgriPlant;
import com.agricraft.agricore.plant.AgriSoil;
import com.agricraft.agricore.plant.AgriWeed;
import com.agricraft.agricore.plant.fertilizer.AgriFertilizer;
import com.agricraft.agricore.util.ResourceHelper;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapter;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutation;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeed;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.config.Config;
import com.infinityraider.agricraft.impl.v1.AgriConverterImpl;
import com.infinityraider.agricraft.impl.v1.AgriLoggerImpl;
import com.infinityraider.agricraft.impl.v1.AgriValidatorImpl;
import com.infinityraider.agricraft.impl.v1.JsonHelper;
import com.infinityraider.agricraft.impl.v1.fertilizer.JsonFertilizer;
import com.infinityraider.agricraft.impl.v1.plant.JsonPlant;
import com.infinityraider.agricraft.impl.v1.plant.JsonWeed;
import com.infinityraider.agricraft.impl.v1.requirement.JsonSoil;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;

public final class CoreHandler {
    public static final Pattern JSON_FILE_PATTERN = Pattern.compile(".*\\.json", 2);
    public static final Pattern AGRI_FOLDER_PATTERN = Pattern.compile("json/defaults/.*", 2);
    public static final Predicate<String> MOD_FILTER = path -> {
        String id = path.substring(path.indexOf("json/defaults/") + 14);
        if ((id = id.substring(0, id.indexOf("/"))).equalsIgnoreCase("vanilla")) {
            return true;
        }
        if (id.equalsIgnoreCase("resource")) {
            return ((Config)AgriCraft.instance.getConfig()).generateResourceCropJsons();
        }
        id = id.replace("mod_", "");
        return ModList.get().isLoaded(id);
    };
    private static Path configDir;
    private static Path jsonDir;
    private static Path defaultDir;
    private static Config config;
    private static boolean initialized;

    private CoreHandler() {
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static Config getConfig() {
        return config;
    }

    public static Path getConfigDir() {
        return configDir;
    }

    public static Path getJsonDir() {
        return jsonDir;
    }

    public static void loadJsons() {
        configDir = FMLPaths.CONFIGDIR.get().resolve("agricraft");
        config = (Config)AgriCraft.instance.getConfig();
        jsonDir = CoreHandler.getConfigDir().resolve("json");
        defaultDir = CoreHandler.getJsonDir().resolve("defaults");
        AgriCore.init(new AgriLoggerImpl(), new AgriValidatorImpl(), new AgriConverterImpl(), (AgriConfigAdapter)AgriCraft.instance.getConfig());
        if (((Config)AgriCraft.instance.getConfig()).generateMissingDefaultJsons()) {
            ResourceHelper.copyResources(ModList.get().getModFiles().stream().map(ModFileInfo::getFile).map(ModFile::getFilePath), JSON_FILE_PATTERN.asPredicate(), AGRI_FOLDER_PATTERN.asPredicate().and(MOD_FILTER), configDir::resolve, false);
        }
        AgriCore.getLogger("agricraft").info("Attempting to read AgriCraft JSONs!", new Object[0]);
        AgriLoader.loadDirectory(defaultDir, AgriCore.getSoils(), AgriCore.getPlants(), AgriCore.getWeeds(), AgriCore.getMutations(), AgriCore.getFertilizers());
        AgriCore.getLogger("agricraft").info("Finished trying to read AgriCraft JSONs!", new Object[0]);
    }

    public static void init() {
        CoreHandler.initSoils();
        CoreHandler.initPlants();
        CoreHandler.initWeeds();
        CoreHandler.initMutations();
        CoreHandler.initFertilizers();
        initialized = true;
    }

    public static void onSyncComplete() {
        initialized = true;
    }

    public static void onLogout() {
        initialized = false;
    }

    private static void initSoils() {
        AgriCore.getLogger("agricraft").info("Registering Soils!", new Object[0]);
        int raw = AgriCore.getSoils().getAll().size();
        AgriCore.getSoils().validate();
        int count = AgriCore.getSoils().getAll().size();
        AgriCore.getSoils().getAll().stream().filter(AgriSoil::isEnabled).map(JsonSoil::new).forEach(AgriApi.getSoilRegistry()::add);
        AgriCore.getLogger("agricraft").info("Registered Soils ({0}/{1}):", count, raw);
        for (IAgriSoil soil : AgriApi.getSoilRegistry().all()) {
            AgriCore.getLogger("agricraft").info(" - {0}", soil.getId());
        }
    }

    private static void initPlants() {
        AgriCore.getLogger("agricraft").info("Registering Plants!", new Object[0]);
        int raw = AgriCore.getPlants().getAllElements().size();
        AgriCore.getPlants().validate();
        int count = AgriCore.getPlants().getAllElements().size();
        AgriCore.getPlants().validate();
        AgriCore.getPlants().getAllElements().stream().filter(AgriPlant::isEnabled).map(JsonPlant::new).forEach(AgriApi.getPlantRegistry()::add);
        AgriCore.getLogger("agricraft").info("Registered Plants ({0}/{1}):", count, raw);
        for (IAgriPlant plant : AgriApi.getPlantRegistry().all()) {
            AgriCore.getLogger("agricraft").info(" - {0}", plant.getId());
        }
    }

    private static void initWeeds() {
        AgriCore.getLogger("agricraft").info("Registering Weeds!", new Object[0]);
        int raw = AgriCore.getWeeds().getAllElements().size();
        AgriCore.getWeeds().validate();
        int count = AgriCore.getWeeds().getAllElements().size();
        AgriCore.getWeeds().validate();
        AgriCore.getWeeds().getAllElements().stream().filter(AgriWeed::isEnabled).map(JsonWeed::new).forEach(AgriApi.getWeedRegistry()::add);
        AgriCore.getLogger("agricraft").info("Registered Weeds ({0}/{1}):", count, raw);
        for (IAgriWeed weed : AgriApi.getWeedRegistry().all()) {
            AgriCore.getLogger("agricraft").info(" - {0}", weed.getId());
        }
    }

    private static void initMutations() {
        AgriCore.getLogger("agricraft").info("Registering Mutations!", new Object[0]);
        int raw = AgriCore.getMutations().getAll().size();
        AgriCore.getMutations().validate();
        int count = AgriCore.getMutations().getAll().size();
        AgriCore.getMutations().getAll().stream().filter(AgriMutation::isEnabled).map(JsonHelper::wrap).filter(Optional::isPresent).map(Optional::get).forEach(AgriApi.getMutationRegistry()::add);
        AgriCore.getLogger("agricraft").info("Registered Mutations ({0}/{1}):", count, raw);
        for (IAgriMutation mutation : AgriApi.getMutationRegistry().all()) {
            AgriCore.getLogger("agricraft").info(" - {0}", mutation);
        }
    }

    private static void initFertilizers() {
        AgriCore.getLogger("agricraft").info("Registering Fertilizers!", new Object[0]);
        int raw = AgriCore.getFertilizers().getAll().size();
        AgriCore.getFertilizers().validate();
        int count = AgriCore.getFertilizers().getAll().size();
        AgriCore.getLogger("agricraft").info("Registered Fertilizers ({0}/{1}):", count, raw);
        AgriCore.getFertilizers().getAll().stream().filter(AgriFertilizer::isEnabled).map(JsonFertilizer::new).forEach(fertilizer -> {
            AgriApi.getFertilizerAdapterizer().registerAdapter((IAgriAdapter<IAgriFertilizer>)fertilizer);
            AgriCore.getLogger("agricraft").info(" - {0}", fertilizer.getId());
        });
    }

    static {
        initialized = false;
    }
}

