/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.impl.v1;

import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApiState;
import com.infinityraider.agricraft.api.v1.IAgriApiConnector;
import com.infinityraider.agricraft.api.v1.adapter.IAgriAdapterizer;
import com.infinityraider.agricraft.api.v1.client.IAgriPlantQuadGenerator;
import com.infinityraider.agricraft.api.v1.client.IJournalDataDrawer;
import com.infinityraider.agricraft.api.v1.client.IMagnifyingGlassInspector;
import com.infinityraider.agricraft.api.v1.config.IAgriConfig;
import com.infinityraider.agricraft.api.v1.content.IAgriContent;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.crop.CropCapability;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.crop.IAgriGrowthStage;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGeneRegistry;
import com.infinityraider.agricraft.api.v1.genetics.IAgriGenome;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationHandler;
import com.infinityraider.agricraft.api.v1.genetics.IAgriMutationRegistry;
import com.infinityraider.agricraft.api.v1.plant.AgriPlantIngredient;
import com.infinityraider.agricraft.api.v1.plant.IAgriGrowthRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlantRegistry;
import com.infinityraider.agricraft.api.v1.plant.IAgriWeedRegistry;
import com.infinityraider.agricraft.api.v1.plant.IJsonPlantCallback;
import com.infinityraider.agricraft.api.v1.requirement.AnySoilIngredient;
import com.infinityraider.agricraft.api.v1.requirement.IAgriGrowthRequirement;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSeasonLogic;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoil;
import com.infinityraider.agricraft.api.v1.requirement.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.v1.requirement.IDefaultGrowConditionFactory;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatRegistry;
import com.infinityraider.agricraft.capability.CapabilityCrop;
import com.infinityraider.agricraft.content.core.ItemDynamicAgriSeed;
import com.infinityraider.agricraft.handler.JournalViewPointHandler;
import com.infinityraider.agricraft.handler.MagnifyingGlassViewHandler;
import com.infinityraider.agricraft.handler.VanillaSeedConversionHandler;
import com.infinityraider.agricraft.impl.v1.AgriAdapterizer;
import com.infinityraider.agricraft.impl.v1.AgriContent;
import com.infinityraider.agricraft.impl.v1.crop.AgriGrowthRegistry;
import com.infinityraider.agricraft.impl.v1.crop.IncrementalGrowthLogic;
import com.infinityraider.agricraft.impl.v1.genetics.AgriGeneRegistry;
import com.infinityraider.agricraft.impl.v1.genetics.AgriGenome;
import com.infinityraider.agricraft.impl.v1.genetics.AgriMutationHandler;
import com.infinityraider.agricraft.impl.v1.genetics.AgriMutationRegistry;
import com.infinityraider.agricraft.impl.v1.plant.AgriPlantRegistry;
import com.infinityraider.agricraft.impl.v1.plant.AgriWeedRegistry;
import com.infinityraider.agricraft.impl.v1.plant.JsonPlantCallbackManager;
import com.infinityraider.agricraft.impl.v1.requirement.AgriGrowthRequirement;
import com.infinityraider.agricraft.impl.v1.requirement.AgriSoilRegistry;
import com.infinityraider.agricraft.impl.v1.requirement.Factory;
import com.infinityraider.agricraft.impl.v1.requirement.SeasonLogic;
import com.infinityraider.agricraft.impl.v1.stats.AgriStatRegistry;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.render.plant.AgriPlantQuadGenerator;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class AgriApiConnector
implements IAgriApiConnector {
    private final IAgriPlantRegistry plantRegistry = AgriPlantRegistry.getInstance();
    private final IAgriGrowthRegistry growthStageRegistry = AgriGrowthRegistry.getInstance();
    private final IAgriWeedRegistry weedRegistry = AgriWeedRegistry.getInstance();
    private final IAgriMutationRegistry mutationRegistry = AgriMutationRegistry.getInstance();
    private final IAgriStatRegistry statRegistry = AgriStatRegistry.getInstance();
    private final IAgriGeneRegistry geneRegistry = AgriGeneRegistry.getInstance();
    private final IAgriSoilRegistry soilRegistry = AgriSoilRegistry.getInstance();
    private final IAgriAdapterizer<IAgriGenome> genomeAdapterizer = new AgriAdapterizer<IAgriGenome>();
    private final IAgriAdapterizer<IAgriFertilizer> fertilizerAdapterizer = new AgriAdapterizer<IAgriFertilizer>();
    private final IAgriSeasonLogic seasonLogic = SeasonLogic.getInstance();
    private final AgriMutationHandler mutator = AgriMutationHandler.getInstance();

    @Override
    @Nonnull
    public AgriApiState getState() {
        return AgriApiState.VALID;
    }

    @Override
    @Nonnull
    public IAgriContent connectAgriContent() {
        return AgriContent.getInstance();
    }

    @Override
    @Nonnull
    public IAgriConfig connectAgriConfig() {
        return (IAgriConfig)AgriCraft.instance.getConfig();
    }

    @Override
    @Nonnull
    public IAgriPlantRegistry connectPlantRegistry() {
        return this.plantRegistry;
    }

    @Override
    @Nonnull
    public IAgriGrowthRegistry connectGrowthStageRegistry() {
        return this.growthStageRegistry;
    }

    @Override
    @Nonnull
    public IAgriWeedRegistry connectWeedRegistry() {
        return this.weedRegistry;
    }

    @Override
    @Nonnull
    public IAgriMutationRegistry connectMutationRegistry() {
        return this.mutationRegistry;
    }

    @Override
    @Nonnull
    public IAgriGeneRegistry connectGeneRegistry() {
        return this.geneRegistry;
    }

    @Override
    @Nonnull
    public IAgriStatRegistry connectStatRegistry() {
        return this.statRegistry;
    }

    @Override
    @Nonnull
    public IAgriSoilRegistry connectSoilRegistry() {
        return this.soilRegistry;
    }

    @Override
    @Nonnull
    public IAgriAdapterizer<IAgriGenome> connectGenomeAdapterizer() {
        return this.genomeAdapterizer;
    }

    @Override
    public IAgriAdapterizer<IAgriFertilizer> connectFertilizerRegistry() {
        return this.fertilizerAdapterizer;
    }

    @Override
    @Nonnull
    public IAgriSeasonLogic connectSeasonLogic() {
        return this.seasonLogic;
    }

    @Override
    @Nonnull
    public ItemStack plantToSeedStack(IAgriPlant plant, int amount) {
        return ItemDynamicAgriSeed.toStack(plant, amount);
    }

    @Override
    @Nonnull
    public IIngredientSerializer<AgriPlantIngredient> connectPlantIngredientSerializer() {
        return AgriCraft.instance.getModRecipeSerializerRegistry().plant_ingredient;
    }

    @Override
    @Nonnull
    public IIngredientSerializer<AnySoilIngredient> connectAnySoilIngredientSerializer() {
        return AgriCraft.instance.getModRecipeSerializerRegistry().any_soil_ingredient;
    }

    @Override
    @Nonnull
    public Optional<IAgriCrop> getCrop(IBlockReader world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IAgriCrop) {
            return Optional.of((IAgriCrop)tile);
        }
        return CapabilityCrop.getInstance().getCapability((ICapabilityProvider)tile).map(crop -> crop);
    }

    @Override
    @Nonnull
    public Optional<IAgriSoil> getSoil(IBlockReader world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        IAgriSoilRegistry registry = this.connectSoilRegistry();
        Optional<IAgriSoil> soil = registry.valueOf(state);
        return soil.isPresent() ? soil : registry.getProvider(state.func_177230_c()).getSoil(world, pos, state);
    }

    @Override
    @Nonnull
    public Optional<IAgriFertilizer> getFertilizer(ItemStack itemStack) {
        if (this.fertilizerAdapterizer.hasAdapter(itemStack)) {
            return this.fertilizerAdapterizer.valueOf(itemStack);
        }
        return Optional.empty();
    }

    @Override
    @Nonnull
    public ItemStack attemptConversionToAgriSeed(ItemStack original) {
        return VanillaSeedConversionHandler.getInstance().attemptConvert(original);
    }

    @Override
    public void registerVanillaPlantingOverrideException(Item seed) {
        VanillaSeedConversionHandler.getInstance().registerException(seed);
    }

    @Override
    public <T extends TileEntity, C extends IAgriCrop> void registerCapabilityCropInstance(CropCapability.Instance<T, C> instance) {
        CapabilityCrop.getInstance().registerInstance(instance);
    }

    @Override
    @Nonnull
    public IAgriGrowthRequirement.Builder getGrowthRequirementBuilder() {
        return AgriGrowthRequirement.getBuilder();
    }

    @Override
    @Nonnull
    public IDefaultGrowConditionFactory getDefaultGrowConditionFactory() {
        return Factory.getInstance();
    }

    @Override
    @Nonnull
    public List<IAgriGrowthStage> getDefaultGrowthStages(int stages) {
        return IncrementalGrowthLogic.getOrGenerateStages(stages);
    }

    @Override
    @Nonnull
    public IAgriMutationHandler getAgriMutationHandler() {
        return this.mutator;
    }

    @Override
    @Nonnull
    public IAgriGenome.Builder getAgriGenomeBuilder(@Nonnull IAgriPlant plant) {
        return AgriGenome.builder(plant);
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public IAgriPlantQuadGenerator getPlantQuadGenerator() {
        return AgriPlantQuadGenerator.getInstance();
    }

    @Override
    @Nonnull
    public Optional<IJsonPlantCallback.Factory> getJsonPlantCallback(String id) {
        return JsonPlantCallbackManager.get(id);
    }

    @Override
    public boolean registerJsonPlantCallback(@Nonnull IJsonPlantCallback.Factory callback) {
        return JsonPlantCallbackManager.register(callback);
    }

    @Override
    public boolean isObservingWithMagnifyingGlass(PlayerEntity player) {
        return ((IProxy)AgriCraft.instance.proxy()).isMagnifyingGlassObserving(player);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void registerMagnifyingGlassInspector(IMagnifyingGlassInspector inspector) {
        MagnifyingGlassViewHandler.getInstance().registerMagnifyingGlassInspector(inspector);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public <P extends IAgriJournalItem.IPage> void registerJournalDataDrawer(IJournalDataDrawer<P> drawer) {
        JournalViewPointHandler.registerJournalDataDrawer(drawer);
    }
}

