/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.content.core;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.infinityraider.agricraft.AgriCraft;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.content.items.IAgriJournalItem;
import com.infinityraider.agricraft.api.v1.event.JournalContentsUpdatedEvent;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.capability.CapabilityJournalData;
import com.infinityraider.agricraft.content.AgriTabs;
import com.infinityraider.agricraft.impl.v1.journal.FrontPage;
import com.infinityraider.agricraft.impl.v1.journal.GeneticsPage;
import com.infinityraider.agricraft.impl.v1.journal.GrowthReqsPage;
import com.infinityraider.agricraft.impl.v1.journal.IntroductionPage;
import com.infinityraider.agricraft.impl.v1.journal.MutationsPage;
import com.infinityraider.agricraft.impl.v1.journal.PlantPage;
import com.infinityraider.agricraft.proxy.IProxy;
import com.infinityraider.agricraft.render.items.journal.JournalItemRenderer;
import com.infinityraider.infinitylib.item.ItemBase;
import com.infinityraider.infinitylib.render.item.InfItemRenderer;
import com.infinityraider.infinitylib.utility.ISerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.loading.FMLEnvironment;

public class ItemJournal
extends ItemBase
implements IAgriJournalItem {
    public ItemJournal() {
        super("agri_journal", new Item.Properties().func_200916_a(AgriTabs.TAB_AGRICRAFT).func_200917_a(1));
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(@Nonnull World world, @Nonnull PlayerEntity player, @Nonnull Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (world.func_201670_d() && ((IProxy)AgriCraft.instance.proxy()).toggleJournalObserving(player, hand)) {
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public LazyOptional<JournalData> getJournalData(@Nonnull ItemStack journal) {
        return CapabilityJournalData.getInstance().getCapability((ICapabilityProvider)journal);
    }

    @Override
    public boolean isPlantDiscovered(@Nonnull ItemStack journal, @Nullable IAgriPlant plant) {
        return this.getJournalData(journal).map(data -> data.isPlantDiscovered(plant)).orElse(false);
    }

    @Override
    public void addEntry(@Nonnull ItemStack journal, @Nullable IAgriPlant plant) {
        if (plant == null) {
            return;
        }
        this.getJournalData(journal).ifPresent(data -> data.addEntry(plant));
    }

    @Override
    @Nonnull
    public List<IAgriPlant> getDiscoveredSeeds(@Nonnull ItemStack journal) {
        return this.getJournalData(journal).map(JournalData::getPlants).orElse(Collections.emptyList());
    }

    @Override
    public int getCurrentPageIndex(@Nonnull ItemStack journal) {
        return this.getJournalData(journal).map(JournalData::getCurrentIndex).orElse(0);
    }

    @Override
    public void setCurrentPageIndex(@Nonnull ItemStack journal, int index) {
        this.getJournalData(journal).ifPresent(data -> data.setCurrentIndex(index));
    }

    @Override
    @Nonnull
    public List<IAgriJournalItem.IPage> getPages(@Nonnull ItemStack journal) {
        return this.getJournalData(journal).map(JournalData::getPages).orElse(Collections.emptyList());
    }

    public boolean doesSneakBypassUse(ItemStack stack, IWorldReader world, BlockPos pos, PlayerEntity player) {
        return true;
    }

    public boolean func_77651_p() {
        return true;
    }

    @Nullable
    public CompoundNBT getShareTag(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            CompoundNBT tag;
            CompoundNBT compoundNBT = tag = stack.func_77942_o() ? stack.func_77978_p() : new CompoundNBT();
            if (tag != null) {
                this.getJournalData(stack).ifPresent(data -> tag.func_218657_a("agri_connections", (INBT)data.writeToNBT()));
            }
            return tag;
        }
        return super.getShareTag(stack);
    }

    public void readShareTag(ItemStack stack, @Nullable CompoundNBT tag) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            if (tag != null && tag.func_74764_b("agri_connections")) {
                this.getJournalData(stack).ifPresent(data -> data.readFromNBT(tag.func_74775_l("agri_connections")));
            }
        } else {
            super.readShareTag(stack, tag);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public InfItemRenderer getItemRenderer() {
        return JournalItemRenderer.getInstance();
    }

    public static class JournalData
    implements ISerializable {
        private final ItemStack journal;
        private int index;
        private List<IAgriPlant> plants;
        private List<IAgriJournalItem.IPage> pages;

        public JournalData(ItemStack journal, List<IAgriPlant> plants) {
            this.journal = journal;
            this.index = 0;
            this.plants = plants;
            this.initializePages();
        }

        public IAgriJournalItem getJournalItem() {
            return (IAgriJournalItem)this.getJournalStack().func_77973_b();
        }

        public ItemStack getJournalStack() {
            return this.journal;
        }

        public int getCurrentIndex() {
            return this.index;
        }

        public void setCurrentIndex(int index) {
            this.index = Math.min(this.getPages().size() - 1, Math.max(0, index));
        }

        @Nonnull
        public List<IAgriPlant> getPlants() {
            return this.plants;
        }

        @Nonnull
        public List<IAgriJournalItem.IPage> getPages() {
            return this.pages;
        }

        public void addEntry(IAgriPlant plant) {
            if (!this.isPlantDiscovered(plant)) {
                this.plants.add(plant);
                this.initializePages();
            }
        }

        public boolean isPlantDiscovered(IAgriPlant plant) {
            return this.getPlants().contains(plant);
        }

        public void readFromNBT(CompoundNBT tag) {
            this.plants = tag.func_74764_b("agri_entries") ? tag.func_150295_c("agri_entries", 10).stream().filter(plantTag -> plantTag instanceof CompoundNBT).map(plantTag -> (CompoundNBT)plantTag).map(plantTag -> AgriApi.getPlantRegistry().get(plantTag.func_74779_i("agri_plant"))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()) : new ArrayList<IAgriPlant>();
            this.initializePages();
            this.setCurrentIndex(tag.func_74764_b("agri_index") ? tag.func_74762_e("agri_index") : 0);
        }

        public CompoundNBT writeToNBT() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("agri_index", this.getCurrentIndex());
            ListNBT list = new ListNBT();
            this.getPlants().forEach(plant -> {
                CompoundNBT plantTag = new CompoundNBT();
                plantTag.func_74778_a("agri_plant", plant.getId());
                list.add((Object)plantTag);
            });
            tag.func_218657_a("agri_entries", (INBT)list);
            return tag;
        }

        protected void initializePages() {
            ArrayList pages = Lists.newArrayList();
            pages.add(FrontPage.INSTANCE);
            pages.add(IntroductionPage.INSTANCE);
            pages.add(GeneticsPage.INSTANCE);
            pages.add(GrowthReqsPage.INSTANCE);
            this.plants.stream().sorted().forEach(plant -> {
                PlantPage page = new PlantPage((IAgriPlant)plant, this.plants);
                pages.add(page);
                List<List<IAgriPlant>> mutations = page.getOffPageMutations();
                int size = mutations.size();
                if (size > 0) {
                    int remaining = size;
                    int from = 0;
                    int to = Math.min(remaining, 18);
                    while (remaining > 0) {
                        pages.add(new MutationsPage(mutations.subList(from, to)));
                        from = to;
                        to = from + Math.min(remaining -= to - from, 18);
                    }
                }
            });
            JournalContentsUpdatedEvent event = new JournalContentsUpdatedEvent(this.getJournalStack(), this.getJournalItem(), pages);
            MinecraftForge.EVENT_BUS.post((Event)event);
            this.pages = ImmutableList.copyOf(event.getPages());
        }

        public static JournalData createFromLegacyTag(ItemStack stack) {
            return new JournalData(stack, JournalData.getPlantsFromLegacyTag(stack));
        }

        private static List<IAgriPlant> getPlantsFromLegacyTag(ItemStack stack) {
            ArrayList plants = Lists.newArrayList();
            CompoundNBT existingTag = stack.func_77978_p();
            if (existingTag != null && existingTag.func_74764_b("agri_entries")) {
                plants.addAll(existingTag.func_150295_c("agri_entries", 10).stream().filter(tag -> tag instanceof CompoundNBT).map(tag -> (CompoundNBT)tag).map(tag -> AgriApi.getPlantRegistry().get(tag.func_74779_i("agri_plant"))).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()));
                existingTag.func_82580_o("agri_entries");
                if (existingTag.func_150296_c().isEmpty()) {
                    stack.func_77982_d(null);
                }
            }
            return plants;
        }
    }
}

