/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.stat;

import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.stat.IAgriStatRegistry;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;

public interface IAgriStatsMap {
    public int getValue(IAgriStat var1);

    default public int getGain() {
        return this.getValue(IAgriStatRegistry.getInstance().gainStat());
    }

    default public int getGrowth() {
        return this.getValue(IAgriStatRegistry.getInstance().growthStat());
    }

    default public int getStrength() {
        return this.getValue(IAgriStatRegistry.getInstance().strengthStat());
    }

    default public int getFertility() {
        return this.getValue(IAgriStatRegistry.getInstance().fertilityStat());
    }

    default public int getResistance() {
        return this.getValue(IAgriStatRegistry.getInstance().resistanceStat());
    }

    default public int getMutativity() {
        return this.getValue(IAgriStatRegistry.getInstance().mutativityStat());
    }

    default public int getSum() {
        return IAgriStatRegistry.getInstance().stream().mapToInt(this::getValue).sum();
    }

    default public double getAverage() {
        return ((double)this.getSum() + 0.0) / (double)IAgriStatRegistry.getInstance().count();
    }

    public boolean writeToNBT(@Nonnull CompoundNBT var1);

    public boolean readFromNBT(@Nonnull CompoundNBT var1);

    default public boolean equalStats(IAgriStatsMap other) {
        return this == other || IAgriStatRegistry.getInstance().stream().allMatch(stat -> this.getValue((IAgriStat)stat) == other.getValue((IAgriStat)stat));
    }

    default public void addTooltips(@Nonnull Consumer<ITextComponent> consumer) {
        IAgriStatRegistry.getInstance().stream().forEach(stat -> stat.addTooltip(consumer, this.getValue((IAgriStat)stat)));
    }
}

