/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.world.gen.feature;

import biomesoplenty.api.block.BOPBlocks;
import biomesoplenty.common.util.block.IBlockPosQuery;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;

public class HugeCloverFeature
extends Feature<NoFeatureConfig> {
    protected IBlockPosQuery placeOn = (world, pos) -> world.func_180495_p(pos).func_177230_c() == Blocks.field_196658_i;
    protected IBlockPosQuery replace = (world, pos) -> world.func_180495_p(pos).canBeReplacedByLeaves((IWorldReader)world, pos) || world.func_180495_p(pos).func_177230_c() instanceof BushBlock;

    public HugeCloverFeature(Codec<NoFeatureConfig> deserializer) {
        super(deserializer);
    }

    public boolean place(ISeedReader world, ChunkGenerator chunkGenerator, Random rand, BlockPos startPos, NoFeatureConfig config) {
        while (startPos.func_177956_o() > 1 && this.replace.matches((IWorld)world, startPos)) {
            startPos = startPos.func_177977_b();
        }
        if (!this.placeOn.matches((IWorld)world, startPos)) {
            return false;
        }
        if (!this.checkSpace((IWorld)world, startPos.func_177984_a())) {
            return false;
        }
        BlockPos pos = startPos.func_177984_a();
        this.setBlock((IWorld)world, pos, (BlockState)BOPBlocks.huge_clover_petal.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.NORTH));
        this.setBlock((IWorld)world, pos.func_177968_d(), (BlockState)BOPBlocks.huge_clover_petal.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.WEST));
        this.setBlock((IWorld)world, pos.func_177974_f(), (BlockState)BOPBlocks.huge_clover_petal.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.EAST));
        this.setBlock((IWorld)world, pos.func_177968_d().func_177974_f(), (BlockState)BOPBlocks.huge_clover_petal.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.SOUTH));
        return true;
    }

    public boolean setBlock(IWorld world, BlockPos pos, BlockState state) {
        if (this.replace.matches(world, pos)) {
            super.func_230367_a_((IWorldWriter)world, pos, state);
            return true;
        }
        return false;
    }

    public boolean checkSpace(IWorld world, BlockPos pos) {
        for (int x = 0; x <= 1; ++x) {
            for (int z = 0; z <= 1; ++z) {
                BlockPos pos1 = pos.func_177982_a(x, 0, z);
                if (pos1.func_177956_o() < 255 && this.replace.matches(world, pos1) && this.placeOn.matches(world, pos1.func_177977_b())) continue;
                return false;
            }
        }
        return true;
    }
}

