/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.transmitter;

import javax.annotation.Nonnull;
import mekanism.api.providers.IBlockProvider;
import mekanism.client.model.data.TransmitterModelData;
import mekanism.common.Mekanism;
import mekanism.common.block.states.TransmitterType;
import mekanism.common.content.network.transmitter.DiversionTransporter;
import mekanism.common.integration.computer.ComputerCapabilityHelper;
import mekanism.common.integration.computer.IComputerTile;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.transmitter.TileEntityLogisticalTransporterBase;
import net.minecraft.util.Direction;

public class TileEntityDiversionTransporter
extends TileEntityLogisticalTransporterBase
implements IComputerTile {
    public TileEntityDiversionTransporter() {
        super(MekanismBlocks.DIVERSION_TRANSPORTER);
        if (Mekanism.hooks.computerCompatEnabled()) {
            ComputerCapabilityHelper.addComputerCapabilities(this, this::addCapabilityResolver);
        }
    }

    @Override
    protected DiversionTransporter createTransmitter(IBlockProvider blockProvider) {
        return new DiversionTransporter(this);
    }

    @Override
    public DiversionTransporter getTransmitter() {
        return (DiversionTransporter)super.getTransmitter();
    }

    @Override
    public TransmitterType getTransmitterType() {
        return TransmitterType.DIVERSION_TRANSPORTER;
    }

    @Override
    @Nonnull
    protected TransmitterModelData initModelData() {
        return new TransmitterModelData.Diversion();
    }

    @Override
    public String getComputerName() {
        return "diversionTransporter";
    }

    @ComputerMethod
    private DiversionTransporter.DiversionControl getMode(Direction side) {
        return this.getTransmitter().modes[side.ordinal()];
    }

    @ComputerMethod
    private void setMode(Direction side, DiversionTransporter.DiversionControl mode) {
        this.getTransmitter().updateMode(side, mode);
    }

    @ComputerMethod
    private void incrementMode(Direction side) {
        DiversionTransporter transmitter = this.getTransmitter();
        transmitter.updateMode(side, (DiversionTransporter.DiversionControl)transmitter.modes[side.ordinal()].getNext());
    }

    @ComputerMethod
    private void decrementMode(Direction side) {
        DiversionTransporter transmitter = this.getTransmitter();
        transmitter.updateMode(side, (DiversionTransporter.DiversionControl)transmitter.modes[side.ordinal()].getPrevious());
    }
}

