/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import java.util.Arrays;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.api.Upgrade;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.inventory.AutomationType;
import mekanism.api.math.FloatingLong;
import mekanism.api.math.MathUtils;
import mekanism.api.recipes.RotaryRecipe;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.cache.RotaryCachedRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.InputHelper;
import mekanism.api.recipes.outputs.IOutputHandler;
import mekanism.api.recipes.outputs.OutputHelper;
import mekanism.common.capabilities.energy.MachineEnergyContainer;
import mekanism.common.capabilities.fluid.BasicFluidTank;
import mekanism.common.capabilities.holder.chemical.ChemicalTankHelper;
import mekanism.common.capabilities.holder.chemical.IChemicalTankHolder;
import mekanism.common.capabilities.holder.energy.EnergyContainerHelper;
import mekanism.common.capabilities.holder.energy.IEnergyContainerHolder;
import mekanism.common.capabilities.holder.fluid.FluidTankHelper;
import mekanism.common.capabilities.holder.fluid.IFluidTankHolder;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.slot.ContainerSlotType;
import mekanism.common.inventory.container.slot.SlotOverlay;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.SyncableFloatingLong;
import mekanism.common.inventory.slot.EnergyInventorySlot;
import mekanism.common.inventory.slot.FluidInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.inventory.slot.chemical.GasInventorySlot;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.RotaryInputRecipeCache;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.IHasMode;
import mekanism.common.tile.prefab.TileEntityRecipeMachine;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.NBTUtils;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.fluids.FluidStack;

public class TileEntityRotaryCondensentrator
extends TileEntityRecipeMachine<RotaryRecipe>
implements IHasMode {
    private static final int CAPACITY = 10000;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerChemicalTankWrapper.class, methodNames={"getGas", "getGasCapacity", "getGasNeeded", "getGasFilledPercentage"})
    public IGasTank gasTank;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerFluidTankWrapper.class, methodNames={"getFluid", "getFluidCapacity", "getFluidNeeded", "getFluidFilledPercentage"})
    public BasicFluidTank fluidTank;
    public boolean mode;
    private final IOutputHandler<@NonNull GasStack> gasOutputHandler;
    private final IOutputHandler<@NonNull FluidStack> fluidOutputHandler;
    private final IInputHandler<@NonNull FluidStack> fluidInputHandler;
    private final IInputHandler<@NonNull GasStack> gasInputHandler;
    private FloatingLong clientEnergyUsed = FloatingLong.ZERO;
    private MachineEnergyContainer<TileEntityRotaryCondensentrator> energyContainer;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getGasItemInput"})
    private GasInventorySlot gasInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getGasItemOutput"})
    private GasInventorySlot gasOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFluidItemInput"})
    private FluidInventorySlot fluidInputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getFluidItemOutput"})
    private OutputInventorySlot fluidOutputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getEnergyItem"})
    private EnergyInventorySlot energySlot;

    public TileEntityRotaryCondensentrator() {
        super(MekanismBlocks.ROTARY_CONDENSENTRATOR);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.FLUID, TransmissionType.ENERGY);
        this.configComponent.setupItemIOConfig(Arrays.asList(this.gasInputSlot, this.fluidInputSlot), Arrays.asList(this.gasOutputSlot, this.fluidOutputSlot), this.energySlot, true);
        this.configComponent.setupIOConfig(TransmissionType.GAS, (Object)this.gasTank, RelativeSide.LEFT, true).setEjecting(true);
        this.configComponent.setupIOConfig(TransmissionType.FLUID, (Object)this.fluidTank, RelativeSide.RIGHT, true).setEjecting(true);
        this.configComponent.setupInputConfig(TransmissionType.ENERGY, this.energyContainer);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM, TransmissionType.GAS, TransmissionType.FLUID).setCanEject(transmissionType -> {
            if (transmissionType == TransmissionType.GAS) {
                return this.mode;
            }
            if (transmissionType == TransmissionType.FLUID) {
                return !this.mode;
            }
            return true;
        });
        this.gasInputHandler = InputHelper.getInputHandler(this.gasTank);
        this.fluidInputHandler = InputHelper.getInputHandler(this.fluidTank);
        this.gasOutputHandler = OutputHelper.getOutputHandler(this.gasTank);
        this.fluidOutputHandler = OutputHelper.getOutputHandler(this.fluidTank);
    }

    @Override
    @Nonnull
    public IChemicalTankHolder<Gas, GasStack, IGasTank> getInitialGasTanks() {
        ChemicalTankHelper<Gas, GasStack, IGasTank> builder = ChemicalTankHelper.forSideGasWithConfig(this::getDirection, this::getConfig);
        this.gasTank = ChemicalTankBuilder.GAS.create(10000L, (gas, automationType) -> automationType == AutomationType.MANUAL || this.mode, (gas, automationType) -> automationType == AutomationType.INTERNAL || !this.mode, this::isValidGas, (IContentsListener)this.recipeCacheLookupMonitor);
        builder.addTank(this.gasTank);
        return builder.build();
    }

    private boolean isValidGas(@Nonnull Gas gas) {
        return this.getRecipeType().getInputCache().containsInput(this.field_145850_b, gas.getStack(1L));
    }

    @Override
    @Nonnull
    protected IFluidTankHolder getInitialFluidTanks() {
        FluidTankHelper builder = FluidTankHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.fluidTank = BasicFluidTank.create(10000, (fluid, automationType) -> automationType == AutomationType.MANUAL || !this.mode, (fluid, automationType) -> automationType == AutomationType.INTERNAL || this.mode, this::isValidFluid, (IContentsListener)this.recipeCacheLookupMonitor);
        builder.addTank(this.fluidTank);
        return builder.build();
    }

    private boolean isValidFluid(@Nonnull FluidStack fluidStack) {
        return this.getRecipeType().getInputCache().containsInput(this.field_145850_b, fluidStack);
    }

    @Override
    @Nonnull
    protected IEnergyContainerHolder getInitialEnergyContainers() {
        EnergyContainerHelper builder = EnergyContainerHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.energyContainer = MachineEnergyContainer.input(this);
        builder.addContainer(this.energyContainer);
        return builder.build();
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        BooleanSupplier modeSupplier = () -> this.mode;
        this.gasInputSlot = GasInventorySlot.rotaryDrain(this.gasTank, modeSupplier, this, 5, 25);
        builder.addSlot(this.gasInputSlot);
        this.gasOutputSlot = GasInventorySlot.rotaryFill(this.gasTank, modeSupplier, this, 5, 56);
        builder.addSlot(this.gasOutputSlot);
        this.fluidInputSlot = FluidInventorySlot.rotary(this.fluidTank, modeSupplier, this, 155, 25);
        builder.addSlot(this.fluidInputSlot);
        this.fluidOutputSlot = OutputInventorySlot.at(this, 155, 56);
        builder.addSlot(this.fluidOutputSlot);
        this.energySlot = EnergyInventorySlot.fillOrConvert(this.energyContainer, () -> ((TileEntityRotaryCondensentrator)this).func_145831_w(), this, 155, 5);
        builder.addSlot(this.energySlot);
        this.gasInputSlot.setSlotType(ContainerSlotType.INPUT);
        this.gasInputSlot.setSlotOverlay(SlotOverlay.PLUS);
        this.gasOutputSlot.setSlotType(ContainerSlotType.OUTPUT);
        this.gasOutputSlot.setSlotOverlay(SlotOverlay.MINUS);
        this.fluidInputSlot.setSlotType(ContainerSlotType.INPUT);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        super.onUpdateServer();
        this.energySlot.fillContainerOrConvert();
        if (this.mode) {
            this.fluidInputSlot.fillTank(this.fluidOutputSlot);
            this.gasInputSlot.drainTank();
        } else {
            this.gasOutputSlot.fillTank();
            this.fluidInputSlot.drainTank(this.fluidOutputSlot);
        }
        this.clientEnergyUsed = this.recipeCacheLookupMonitor.updateAndProcess(this.energyContainer);
    }

    @Override
    public void nextMode() {
        this.mode = !this.mode;
        this.markDirty(false);
    }

    @Nonnull
    @ComputerMethod(nameOverride="getEnergyUsage")
    public FloatingLong getEnergyUsed() {
        return this.clientEnergyUsed;
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        NBTUtils.setBooleanIfPresent(data, "mode", value -> {
            this.mode = value;
        });
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        data.func_74757_a("mode", this.mode);
    }

    @Override
    public int getRedstoneLevel() {
        if (this.mode) {
            return MekanismUtils.redstoneLevelFromContents(this.fluidTank.getFluidAmount(), this.fluidTank.getCapacity());
        }
        return MekanismUtils.redstoneLevelFromContents(this.gasTank.getStored(), this.gasTank.getCapacity());
    }

    @Override
    @Nonnull
    public MekanismRecipeType<RotaryRecipe, RotaryInputRecipeCache> getRecipeType() {
        return MekanismRecipeType.ROTARY;
    }

    @Override
    @Nullable
    public RotaryRecipe getRecipe(int cacheIndex) {
        RotaryInputRecipeCache inputCache = this.getRecipeType().getInputCache();
        return this.mode ? inputCache.findFirstRecipe(this.field_145850_b, this.fluidInputHandler.getInput()) : inputCache.findFirstRecipe(this.field_145850_b, this.gasInputHandler.getInput());
    }

    public MachineEnergyContainer<TileEntityRotaryCondensentrator> getEnergyContainer() {
        return this.energyContainer;
    }

    @Override
    @Nonnull
    public CachedRecipe<RotaryRecipe> createNewCachedRecipe(@Nonnull RotaryRecipe recipe, int cacheIndex) {
        return new RotaryCachedRecipe(recipe, this.fluidInputHandler, this.gasInputHandler, this.gasOutputHandler, this.fluidOutputHandler, () -> this.mode).setCanHolderFunction(() -> MekanismUtils.canFunction(this)).setActive(this::setActive).setEnergyRequirements(this.energyContainer::getEnergyPerTick, this.energyContainer).setOnFinish(() -> this.markDirty(false)).setPostProcessOperations(currentMax -> {
            if (currentMax <= 0) {
                return currentMax;
            }
            int possibleProcess = Math.min((int)Math.pow(2.0, this.upgradeComponent.getUpgrades(Upgrade.SPEED)), currentMax);
            if (this.mode) {
                return Math.min(Math.min(this.fluidTank.getFluidAmount(), MathUtils.clampToInt(this.gasTank.getNeeded())), possibleProcess);
            }
            return Math.min(Math.min(MathUtils.clampToInt(this.gasTank.getStored()), this.fluidTank.getNeeded()), possibleProcess);
        });
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.mode, value -> {
            this.mode = value;
        }));
        container.track(SyncableFloatingLong.create(this::getEnergyUsed, value -> {
            this.clientEnergyUsed = value;
        }));
    }

    @ComputerMethod
    private boolean isCondensentrating() {
        return !this.mode;
    }

    @ComputerMethod
    private void setCondensentrating(boolean value) throws ComputerException {
        this.validateSecurityIsPublic();
        if (this.mode != value) {
            this.mode = value;
            this.markDirty(false);
        }
    }
}

