/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile.machine;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.Action;
import mekanism.api.IContentsListener;
import mekanism.api.RelativeSide;
import mekanism.common.CommonWorldTickHandler;
import mekanism.common.capabilities.holder.slot.IInventorySlotHolder;
import mekanism.common.capabilities.holder.slot.InventorySlotHelper;
import mekanism.common.config.MekanismConfig;
import mekanism.common.config.value.CachedValue;
import mekanism.common.content.filter.BaseFilter;
import mekanism.common.content.filter.IFilter;
import mekanism.common.content.oredictionificator.OredictionificatorFilter;
import mekanism.common.content.oredictionificator.OredictionificatorItemFilter;
import mekanism.common.integration.computer.ComputerException;
import mekanism.common.integration.computer.SpecialComputerMethodWrapper;
import mekanism.common.integration.computer.annotation.ComputerMethod;
import mekanism.common.integration.computer.annotation.WrappingComputerMethod;
import mekanism.common.inventory.container.MekanismContainer;
import mekanism.common.inventory.container.sync.SyncableBoolean;
import mekanism.common.inventory.container.sync.list.SyncableFilterList;
import mekanism.common.inventory.slot.InputInventorySlot;
import mekanism.common.inventory.slot.OutputInventorySlot;
import mekanism.common.lib.collection.HashList;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.tile.component.TileComponentConfig;
import mekanism.common.tile.component.TileComponentEjector;
import mekanism.common.tile.interfaces.ISustainedData;
import mekanism.common.tile.interfaces.ITileFilterHolder;
import mekanism.common.tile.prefab.TileEntityConfigurableMachine;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityOredictionificator
extends TileEntityConfigurableMachine
implements ISustainedData,
ITileFilterHolder<OredictionificatorItemFilter> {
    private HashList<OredictionificatorItemFilter> filters = new HashList();
    public boolean didProcess;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getInputItem"})
    private InputInventorySlot inputSlot;
    @WrappingComputerMethod(wrapper=SpecialComputerMethodWrapper.ComputerIInventorySlotWrapper.class, methodNames={"getOutputItem"})
    private OutputInventorySlot outputSlot;
    private final CachedValue.IConfigValueInvalidationListener validFiltersListener = () -> {
        for (OredictionificatorItemFilter filter : this.filters) {
            filter.checkValidity();
        }
    };

    public TileEntityOredictionificator() {
        super(MekanismBlocks.OREDICTIONIFICATOR);
        this.configComponent = new TileComponentConfig(this, TransmissionType.ITEM);
        this.configComponent.setupIOConfig(TransmissionType.ITEM, (Object)this.inputSlot, this.outputSlot, RelativeSide.RIGHT);
        this.ejectorComponent = new TileComponentEjector(this);
        this.ejectorComponent.setOutputData(this.configComponent, TransmissionType.ITEM);
    }

    @Override
    @Nonnull
    protected IInventorySlotHolder getInitialInventory() {
        InventorySlotHelper builder = InventorySlotHelper.forSideWithConfig(this::getDirection, this::getConfig);
        this.inputSlot = InputInventorySlot.at(item -> !this.getResult((ItemStack)item).func_190926_b(), this::hasFilterableTags, (IContentsListener)this, 26, 115);
        builder.addSlot(this.inputSlot);
        this.outputSlot = OutputInventorySlot.at(this, 134, 115);
        builder.addSlot(this.outputSlot);
        return builder.build();
    }

    @Override
    protected void onUpdateServer() {
        ItemStack result;
        super.onUpdateServer();
        if (CommonWorldTickHandler.flushTagAndRecipeCaches) {
            for (OredictionificatorFilter oredictionificatorFilter : this.filters) {
                oredictionificatorFilter.flushCachedTag();
            }
        }
        this.didProcess = false;
        if (MekanismUtils.canFunction(this) && !this.inputSlot.isEmpty() && !(result = this.getResult(this.inputSlot.getStack())).func_190926_b()) {
            ItemStack itemStack = this.outputSlot.getStack();
            if (itemStack.func_190926_b()) {
                this.inputSlot.shrinkStack(1, Action.EXECUTE);
                this.outputSlot.setStack(result);
                this.didProcess = true;
            } else if (ItemHandlerHelper.canItemStacksStack((ItemStack)itemStack, (ItemStack)result) && itemStack.func_190916_E() < this.outputSlot.getLimit(itemStack)) {
                this.inputSlot.shrinkStack(1, Action.EXECUTE);
                this.outputSlot.growStack(1, Action.EXECUTE);
                this.didProcess = true;
            }
            this.markDirty(false);
        }
    }

    public void onLoad() {
        super.onLoad();
        MekanismConfig.general.validOredictionificatorFilters.addInvalidationListener(this.validFiltersListener);
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.removeInvalidationListener();
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.removeInvalidationListener();
    }

    public void removeInvalidationListener() {
        MekanismConfig.general.validOredictionificatorFilters.removeInvalidationListener(this.validFiltersListener);
    }

    private List<ResourceLocation> getFilterableTags(ItemStack stack) {
        Set tags = stack.func_77973_b().getTags();
        if (tags.isEmpty()) {
            return Collections.emptyList();
        }
        Map possibleFilters = (Map)MekanismConfig.general.validOredictionificatorFilters.get();
        ArrayList<ResourceLocation> filterableTags = new ArrayList<ResourceLocation>();
        for (ResourceLocation resource : tags) {
            if (!possibleFilters.getOrDefault(resource.func_110624_b(), Collections.emptyList()).stream().anyMatch(pre -> resource.func_110623_a().startsWith((String)pre))) continue;
            filterableTags.add(resource);
        }
        return filterableTags;
    }

    private boolean hasFilterableTags(ItemStack stack) {
        Set tags = stack.func_77973_b().getTags();
        if (!tags.isEmpty()) {
            Map possibleFilters = (Map)MekanismConfig.general.validOredictionificatorFilters.get();
            for (ResourceLocation resource : tags) {
                if (!possibleFilters.getOrDefault(resource.func_110624_b(), Collections.emptyList()).stream().anyMatch(pre -> resource.func_110623_a().startsWith((String)pre))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValidTarget(ResourceLocation tag) {
        if (ItemTags.func_199903_a().func_199908_a().contains(tag)) {
            for (String filter : ((Map)MekanismConfig.general.validOredictionificatorFilters.get()).getOrDefault(tag.func_110624_b(), Collections.emptyList())) {
                if (!tag.func_110623_a().startsWith(filter)) continue;
                return true;
            }
        }
        return false;
    }

    private ItemStack getResult(ItemStack stack) {
        if (!this.filters.isEmpty()) {
            for (ResourceLocation filterableTag : this.getFilterableTags(stack)) {
                for (OredictionificatorItemFilter filter : this.filters) {
                    ItemStack result;
                    if (!filter.filterMatches(filterableTag) || (result = (ItemStack)filter.getResult()).func_190926_b()) continue;
                    return result;
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    protected void addGeneralPersistentData(CompoundNBT data) {
        super.addGeneralPersistentData(data);
        if (!this.filters.isEmpty()) {
            data.func_218657_a("filters", (INBT)this.writeFilters());
        }
    }

    @Override
    protected void loadGeneralPersistentData(CompoundNBT data) {
        super.loadGeneralPersistentData(data);
        if (data.func_150297_b("filters", 9)) {
            this.setFilters(data.func_150295_c("filters", 10));
        }
    }

    @Override
    public void writeSustainedData(ItemStack itemStack) {
        if (!this.filters.isEmpty()) {
            ItemDataUtils.setList(itemStack, "filters", this.writeFilters());
        }
    }

    @Override
    public void readSustainedData(ItemStack itemStack) {
        if (ItemDataUtils.hasData(itemStack, "filters", 9)) {
            this.setFilters(ItemDataUtils.getList(itemStack, "filters"));
        }
    }

    private ListNBT writeFilters() {
        ListNBT filterList = new ListNBT();
        for (OredictionificatorFilter oredictionificatorFilter : this.filters) {
            filterList.add((Object)oredictionificatorFilter.write(new CompoundNBT()));
        }
        return filterList;
    }

    private void setFilters(ListNBT filterList) {
        for (int i = 0; i < filterList.size(); ++i) {
            IFilter<?> filter = BaseFilter.readFromNBT(filterList.func_150305_b(i));
            if (!(filter instanceof OredictionificatorItemFilter)) continue;
            this.filters.add((OredictionificatorItemFilter)filter);
        }
    }

    @Override
    public Map<String, String> getTileDataRemap() {
        Object2ObjectOpenHashMap remap = new Object2ObjectOpenHashMap();
        remap.put("filters", "filters");
        return remap;
    }

    @Override
    public boolean canPulse() {
        return true;
    }

    @Override
    @ComputerMethod
    public HashList<OredictionificatorItemFilter> getFilters() {
        return this.filters;
    }

    @Override
    public void addContainerTrackers(MekanismContainer container) {
        super.addContainerTrackers(container);
        container.track(SyncableBoolean.create(() -> this.didProcess, value -> {
            this.didProcess = value;
        }));
        container.track(SyncableFilterList.create(this::getFilters, value -> {
            this.filters = value instanceof HashList ? (HashList)value : new HashList(value);
        }));
    }

    @ComputerMethod
    private boolean addFilter(OredictionificatorItemFilter filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.add(filter);
    }

    @ComputerMethod
    private boolean removeFilter(OredictionificatorItemFilter filter) throws ComputerException {
        this.validateSecurityIsPublic();
        return this.filters.remove(filter);
    }
}

