/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network.to_server;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectArrayMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.QIOCraftingTransferHelper;
import mekanism.common.content.qio.QIOServerCraftingTransferHandler;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.network.IMekanismPacket;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketQIOFillCraftingWindow
implements IMekanismPacket {
    private final Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources;
    private final ResourceLocation recipeID;
    private final boolean maxTransfer;

    public PacketQIOFillCraftingWindow(ResourceLocation recipeID, boolean maxTransfer, Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>> sources) {
        this.recipeID = recipeID;
        this.sources = sources;
        this.maxTransfer = maxTransfer;
    }

    @Override
    public void handle(NetworkEvent.Context context) {
        ServerPlayerEntity player = context.getSender();
        if (player != null && player.field_71070_bA instanceof QIOItemViewerContainer) {
            QIOItemViewerContainer container = (QIOItemViewerContainer)player.field_71070_bA;
            byte selectedCraftingGrid = container.getSelectedCraftingGrid(player.func_110124_au());
            if (selectedCraftingGrid == -1) {
                Mekanism.logger.warn("Received transfer request from: {}, but they do not currently have a crafting window open.", (Object)player);
            } else {
                Optional optionalRecipe = player.field_70170_p.func_199532_z().func_215367_a(this.recipeID);
                if (optionalRecipe.isPresent()) {
                    IRecipe recipe = (IRecipe)optionalRecipe.get();
                    if (recipe instanceof ICraftingRecipe) {
                        QIOServerCraftingTransferHandler.tryTransfer(container, selectedCraftingGrid, (PlayerEntity)player, this.recipeID, (ICraftingRecipe)recipe, this.sources);
                    } else {
                        Mekanism.logger.warn("Received transfer request from: {}, but the type ({}) of the specified recipe was not a crafting recipe.", (Object)player, recipe.getClass());
                    }
                } else {
                    Mekanism.logger.warn("Received transfer request from: {}, but could not find specified recipe.", (Object)player);
                }
            }
        }
    }

    @Override
    public void encode(PacketBuffer buffer) {
        buffer.func_192572_a(this.recipeID);
        buffer.writeBoolean(this.maxTransfer);
        buffer.writeByte((int)((byte)this.sources.size()));
        for (Byte2ObjectMap.Entry entry : this.sources.byte2ObjectEntrySet()) {
            buffer.writeByte((int)entry.getByteKey());
            List slotSources = (List)entry.getValue();
            if (this.maxTransfer) {
                buffer.func_150787_b(slotSources.size());
            }
            for (QIOCraftingTransferHelper.SingularHashedItemSource source : slotSources) {
                byte sourceSlot = source.getSlot();
                buffer.writeByte((int)sourceSlot);
                if (this.maxTransfer) {
                    buffer.func_150787_b(source.getUsed());
                }
                if (sourceSlot != -1) continue;
                UUID qioSource = source.getQioSource();
                if (qioSource == null) {
                    throw new IllegalStateException("Invalid QIO crafting window transfer source.");
                }
                buffer.func_179252_a(qioSource);
            }
        }
    }

    public static PacketQIOFillCraftingWindow decode(PacketBuffer buffer) {
        ResourceLocation recipeID = buffer.func_192575_l();
        boolean maxTransfer = buffer.readBoolean();
        byte slotCount = buffer.readByte();
        Byte2ObjectArrayMap sources = new Byte2ObjectArrayMap((int)slotCount);
        for (byte slot = 0; slot < slotCount; slot = (byte)(slot + 1)) {
            byte targetSlot = buffer.readByte();
            int subSourceCount = maxTransfer ? buffer.func_150792_a() : 1;
            ArrayList<QIOCraftingTransferHelper.SingularHashedItemSource> slotSources = new ArrayList<QIOCraftingTransferHelper.SingularHashedItemSource>(subSourceCount);
            sources.put(targetSlot, slotSources);
            for (int i = 0; i < subSourceCount; ++i) {
                int count;
                byte sourceSlot = buffer.readByte();
                int n = count = maxTransfer ? buffer.func_150792_a() : 1;
                if (sourceSlot == -1) {
                    slotSources.add(new QIOCraftingTransferHelper.SingularHashedItemSource(buffer.func_179253_g(), count));
                    continue;
                }
                slotSources.add(new QIOCraftingTransferHelper.SingularHashedItemSource(sourceSlot, count));
            }
        }
        return new PacketQIOFillCraftingWindow(recipeID, maxTransfer, (Byte2ObjectMap<List<QIOCraftingTransferHelper.SingularHashedItemSource>>)sources);
    }
}

