/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.CrTChemicalStack;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.MekanismRecipeManager;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.impl.ActivatingIRecipe;
import mekanism.common.recipe.impl.CentrifugingIRecipe;
import net.minecraft.util.ResourceLocation;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.GasToGas")
public abstract class GasToGasRecipeManager
extends MekanismRecipeManager<GasToGasRecipe> {
    protected GasToGasRecipeManager(MekanismRecipeType<GasToGasRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, GasStackIngredient input, ICrTChemicalStack.ICrTGasStack output) {
        this.addRecipe(this.makeRecipe(this.getAndValidateName(name), input, this.getAndValidateNotEmpty(output)));
    }

    protected abstract GasToGasRecipe makeRecipe(ResourceLocation var1, GasStackIngredient var2, GasStack var3);

    @Override
    protected MekanismRecipeManager.ActionAddMekanismRecipe getAction(GasToGasRecipe recipe) {
        return new MekanismRecipeManager.ActionAddMekanismRecipe(recipe){

            @Override
            protected String describeOutputs() {
                return CrTUtils.describeOutputs(((GasToGasRecipe)this.getRecipe()).getOutputDefinition(), CrTChemicalStack.CrTGasStack::new);
            }
        };
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.GasToGas.Centrifuging")
    public static class IsotopicCentrifugeRecipeManager
    extends GasToGasRecipeManager {
        public static final IsotopicCentrifugeRecipeManager INSTANCE = new IsotopicCentrifugeRecipeManager();

        private IsotopicCentrifugeRecipeManager() {
            super(MekanismRecipeType.CENTRIFUGING);
        }

        @Override
        protected GasToGasRecipe makeRecipe(ResourceLocation id, GasStackIngredient ingredient, GasStack output) {
            return new CentrifugingIRecipe(id, ingredient, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.GasToGas.Activating")
    public static class SolarNeutronActivatorRecipeManager
    extends GasToGasRecipeManager {
        public static final SolarNeutronActivatorRecipeManager INSTANCE = new SolarNeutronActivatorRecipeManager();

        private SolarNeutronActivatorRecipeManager() {
            super(MekanismRecipeType.ACTIVATING);
        }

        @Override
        protected GasToGasRecipe makeRecipe(ResourceLocation id, GasStackIngredient ingredient, GasStack output) {
            return new ActivatingIRecipe(id, ingredient, output);
        }
    }
}

