/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.command.builders;

import mekanism.common.command.builders.StructureBuilder;
import mekanism.common.registries.MekanismBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Builders {
    private Builders() {
    }

    public static class SPSBuilder
    extends StructureBuilder {
        public SPSBuilder() {
            super(7, 7, 7);
        }

        @Override
        protected void build(World world, BlockPos start) {
            this.buildPartialFrame(world, start, 1);
            this.buildWalls(world, start);
            this.buildInteriorLayers(world, start, 1, 5, Blocks.field_150350_a);
            for (int x = -2; x < 2; ++x) {
                for (int y = -2; y < 2; ++y) {
                    for (int z = -2; z < 2; ++z) {
                        if (x == -1 == (y == -1) == (z == -1) == (x == 0) == (y == 0) == (z == 0) || !(x != -1 && x != 0 || y != -1 && y != 0) && (z == -1 || z == 0)) continue;
                        world.func_175656_a(start.func_177982_a(x < 0 ? this.sizeX + x : x, y < 0 ? this.sizeY + y : y, z < 0 ? this.sizeZ + z : z), this.getCasing().func_176223_P());
                    }
                }
            }
        }

        @Override
        protected Block getCasing() {
            return MekanismBlocks.SPS_CASING.getBlock();
        }
    }

    public static class EvaporationBuilder
    extends StructureBuilder {
        public EvaporationBuilder() {
            super(4, 18, 4);
        }

        @Override
        public void build(World world, BlockPos start) {
            this.buildFrame(world, start);
            this.buildWalls(world, start);
            this.buildInteriorLayers(world, start, 1, 17, Blocks.field_150350_a);
            world.func_175656_a(start.func_177982_a(1, 1, 0), MekanismBlocks.THERMAL_EVAPORATION_CONTROLLER.getBlock().func_176223_P());
        }

        @Override
        protected Block getCasing() {
            return MekanismBlocks.THERMAL_EVAPORATION_BLOCK.getBlock();
        }
    }

    public static class MatrixBuilder
    extends StructureBuilder {
        public MatrixBuilder() {
            super(18, 18, 18);
        }

        @Override
        public void build(World world, BlockPos start) {
            this.buildFrame(world, start);
            this.buildWalls(world, start);
            this.buildInteriorLayers(world, start, 1, 15, MekanismBlocks.ULTIMATE_INDUCTION_CELL.getBlock());
            this.buildInteriorLayer(world, start, 16, MekanismBlocks.ULTIMATE_INDUCTION_PROVIDER.getBlock());
        }

        @Override
        protected Block getCasing() {
            return MekanismBlocks.INDUCTION_CASING.getBlock();
        }
    }

    public static class TankBuilder
    extends StructureBuilder {
        public TankBuilder() {
            super(18, 18, 18);
        }

        @Override
        public void build(World world, BlockPos start) {
            this.buildFrame(world, start);
            this.buildWalls(world, start);
            this.buildInteriorLayers(world, start, 1, 16, Blocks.field_150350_a);
        }

        @Override
        protected Block getCasing() {
            return MekanismBlocks.DYNAMIC_TANK.getBlock();
        }
    }

    public static class BoilerBuilder
    extends StructureBuilder {
        public BoilerBuilder() {
            super(18, 18, 18);
        }

        @Override
        public void build(World world, BlockPos start) {
            this.buildFrame(world, start);
            this.buildWalls(world, start);
            this.buildInteriorLayer(world, start, 1, MekanismBlocks.SUPERHEATING_ELEMENT.getBlock());
            this.buildInteriorLayers(world, start, 2, 14, Blocks.field_150350_a);
            this.buildInteriorLayer(world, start, 15, MekanismBlocks.PRESSURE_DISPERSER.getBlock());
            this.buildInteriorLayer(world, start, 16, Blocks.field_150350_a);
        }

        @Override
        protected Block getCasing() {
            return MekanismBlocks.BOILER_CASING.getBlock();
        }
    }
}

