/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nonnull;
import mekanism.api.RelativeSide;
import mekanism.api.text.EnumColor;
import mekanism.client.model.MekanismJavaModel;
import mekanism.client.render.MekanismRenderType;
import mekanism.common.lib.transmitter.TransmissionType;
import mekanism.common.tier.EnergyCubeTier;
import mekanism.common.tile.TileEntityEnergyCube;
import mekanism.common.tile.component.config.ConfigInfo;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.tile.component.config.slot.ISlotInfo;
import mekanism.common.util.EnumUtils;
import mekanism.common.util.ItemDataUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public class ModelEnergyCube
extends MekanismJavaModel {
    private static final ResourceLocation CUBE_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube.png");
    private static final ResourceLocation OVERLAY_ON = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube_overlay_on.png");
    private static final ResourceLocation OVERLAY_OFF = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube_overlay_off.png");
    private static final ResourceLocation BASE_OVERLAY = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_cube_overlay_base.png");
    private static final RenderType RENDER_TYPE_ON = MekanismRenderType.mekStandard(OVERLAY_ON);
    private static final RenderType RENDER_TYPE_OFF = MekanismRenderType.mekStandard(OVERLAY_OFF);
    private static final RenderType RENDER_TYPE_BASE = MekanismRenderType.mekStandard(BASE_OVERLAY);
    private final RenderType RENDER_TYPE = this.func_228282_a_(CUBE_TEXTURE);
    private final ModelRenderer[] leds1;
    private final ModelRenderer[] leds2;
    private final ModelRenderer[] ports;
    private final ModelRenderer[] connectors;
    private final ModelRenderer frame12;
    private final ModelRenderer frame11;
    private final ModelRenderer frame10;
    private final ModelRenderer frame9;
    private final ModelRenderer frame8;
    private final ModelRenderer frame7;
    private final ModelRenderer frame6;
    private final ModelRenderer frame5;
    private final ModelRenderer frame4;
    private final ModelRenderer frame3;
    private final ModelRenderer frame2;
    private final ModelRenderer frame1;
    private final ModelRenderer corner8;
    private final ModelRenderer corner7;
    private final ModelRenderer corner6;
    private final ModelRenderer corner5;
    private final ModelRenderer corner4;
    private final ModelRenderer corner3;
    private final ModelRenderer corner2;
    private final ModelRenderer corner1;

    public ModelEnergyCube() {
        super(RenderType::func_228634_a_);
        this.field_78090_t = 64;
        this.field_78089_u = 64;
        this.frame12 = new ModelRenderer((Model)this, 0, 0);
        this.frame12.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, false);
        this.frame12.func_78793_a(-8.0f, 11.0f, 5.0f);
        this.frame12.func_78787_b(64, 64);
        this.frame12.field_78809_i = true;
        this.setRotation(this.frame12, 0.0f, 0.0f, 0.0f);
        this.frame11 = new ModelRenderer((Model)this, 0, 0);
        this.frame11.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, false);
        this.frame11.func_78793_a(5.0f, 11.0f, -8.0f);
        this.frame11.func_78787_b(64, 64);
        this.frame11.field_78809_i = true;
        this.setRotation(this.frame11, 0.0f, 0.0f, 0.0f);
        this.frame10 = new ModelRenderer((Model)this, 0, 13);
        this.frame10.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f, false);
        this.frame10.func_78793_a(-5.0f, 21.0f, 5.0f);
        this.frame10.func_78787_b(64, 64);
        this.frame10.field_78809_i = true;
        this.setRotation(this.frame10, 0.0f, 0.0f, 0.0f);
        this.frame9 = new ModelRenderer((Model)this, 12, 0);
        this.frame9.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f, false);
        this.frame9.func_78793_a(5.0f, 21.0f, -5.0f);
        this.frame9.func_78787_b(64, 64);
        this.frame9.field_78809_i = true;
        this.setRotation(this.frame9, 0.0f, 0.0f, 0.0f);
        this.frame8 = new ModelRenderer((Model)this, 0, 13);
        this.frame8.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f, false);
        this.frame8.func_78793_a(-5.0f, 8.0f, 5.0f);
        this.frame8.func_78787_b(64, 64);
        this.frame8.field_78809_i = true;
        this.setRotation(this.frame8, 0.0f, 0.0f, 0.0f);
        this.frame7 = new ModelRenderer((Model)this, 0, 13);
        this.frame7.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f, false);
        this.frame7.func_78793_a(-5.0f, 21.0f, -8.0f);
        this.frame7.func_78787_b(64, 64);
        this.frame7.field_78809_i = true;
        this.setRotation(this.frame7, 0.0f, 0.0f, 0.0f);
        this.frame6 = new ModelRenderer((Model)this, 0, 0);
        this.frame6.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, false);
        this.frame6.func_78793_a(5.0f, 11.0f, 5.0f);
        this.frame6.func_78787_b(64, 64);
        this.frame6.field_78809_i = true;
        this.setRotation(this.frame6, 0.0f, 0.0f, 0.0f);
        this.frame5 = new ModelRenderer((Model)this, 0, 0);
        this.frame5.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 10.0f, 3.0f, false);
        this.frame5.func_78793_a(-8.0f, 11.0f, -8.0f);
        this.frame5.func_78787_b(64, 64);
        this.frame5.field_78809_i = true;
        this.setRotation(this.frame5, 0.0f, 0.0f, 0.0f);
        this.frame4 = new ModelRenderer((Model)this, 12, 0);
        this.frame4.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f, false);
        this.frame4.func_78793_a(5.0f, 8.0f, -5.0f);
        this.frame4.func_78787_b(64, 64);
        this.frame4.field_78809_i = true;
        this.setRotation(this.frame4, 0.0f, 0.0f, 0.0f);
        this.frame3 = new ModelRenderer((Model)this, 12, 0);
        this.frame3.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f, false);
        this.frame3.func_78793_a(-8.0f, 21.0f, -5.0f);
        this.frame3.func_78787_b(64, 64);
        this.frame3.field_78809_i = true;
        this.setRotation(this.frame3, 0.0f, 0.0f, 0.0f);
        this.frame2 = new ModelRenderer((Model)this, 12, 0);
        this.frame2.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 10.0f, false);
        this.frame2.func_78793_a(-8.0f, 8.0f, -5.0f);
        this.frame2.func_78787_b(64, 64);
        this.frame2.field_78809_i = true;
        this.setRotation(this.frame2, 0.0f, 0.0f, 0.0f);
        this.frame1 = new ModelRenderer((Model)this, 0, 13);
        this.frame1.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 3.0f, 3.0f, false);
        this.frame1.func_78793_a(-5.0f, 8.0f, -8.0f);
        this.frame1.func_78787_b(64, 64);
        this.frame1.field_78809_i = true;
        this.setRotation(this.frame1, 0.0f, 0.0f, 0.0f);
        this.corner8 = new ModelRenderer((Model)this, 26, 13);
        this.corner8.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner8.func_78793_a(5.0f, 21.0f, 5.0f);
        this.corner8.func_78787_b(64, 64);
        this.corner8.field_78809_i = true;
        this.setRotation(this.corner8, 0.0f, 0.0f, 0.0f);
        this.corner7 = new ModelRenderer((Model)this, 26, 13);
        this.corner7.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner7.func_78793_a(5.0f, 21.0f, -8.0f);
        this.corner7.func_78787_b(64, 64);
        this.corner7.field_78809_i = true;
        this.setRotation(this.corner7, 0.0f, 0.0f, 0.0f);
        this.corner6 = new ModelRenderer((Model)this, 26, 13);
        this.corner6.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner6.func_78793_a(-8.0f, 21.0f, 5.0f);
        this.corner6.func_78787_b(64, 64);
        this.corner6.field_78809_i = true;
        this.setRotation(this.corner6, 0.0f, 0.0f, 0.0f);
        this.corner5 = new ModelRenderer((Model)this, 26, 13);
        this.corner5.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner5.func_78793_a(-8.0f, 21.0f, -8.0f);
        this.corner5.func_78787_b(64, 64);
        this.corner5.field_78809_i = true;
        this.setRotation(this.corner5, 0.0f, 0.0f, 0.0f);
        this.corner4 = new ModelRenderer((Model)this, 26, 13);
        this.corner4.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner4.func_78793_a(5.0f, 8.0f, 5.0f);
        this.corner4.func_78787_b(64, 64);
        this.corner4.field_78809_i = true;
        this.setRotation(this.corner4, 0.0f, 0.0f, 0.0f);
        this.corner3 = new ModelRenderer((Model)this, 26, 13);
        this.corner3.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner3.func_78793_a(5.0f, 8.0f, -8.0f);
        this.corner3.func_78787_b(64, 64);
        this.corner3.field_78809_i = true;
        this.setRotation(this.corner3, 0.0f, 0.0f, 0.0f);
        this.corner2 = new ModelRenderer((Model)this, 26, 13);
        this.corner2.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner2.func_78793_a(-8.0f, 8.0f, 5.0f);
        this.corner2.func_78787_b(64, 64);
        this.corner2.field_78809_i = true;
        this.setRotation(this.corner2, 0.0f, 0.0f, 0.0f);
        this.corner1 = new ModelRenderer((Model)this, 26, 13);
        this.corner1.func_228304_a_(0.0f, 0.0f, 0.0f, 3.0f, 3.0f, 3.0f, false);
        this.corner1.func_78793_a(-8.0f, 8.0f, -8.0f);
        this.corner1.func_78787_b(64, 64);
        this.corner1.field_78809_i = true;
        this.setRotation(this.corner1, 0.0f, 0.0f, 0.0f);
        ModelRenderer connectorBackToggle = new ModelRenderer((Model)this, 38, 16);
        connectorBackToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 6.0f, 1.0f, false);
        connectorBackToggle.func_78793_a(-5.0f, 13.0f, 6.0f);
        connectorBackToggle.func_78787_b(64, 64);
        connectorBackToggle.field_78809_i = true;
        this.setRotation(connectorBackToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer connectorRightToggle = new ModelRenderer((Model)this, 38, 0);
        connectorRightToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 6.0f, 10.0f, false);
        connectorRightToggle.func_78793_a(6.0f, 13.0f, -5.0f);
        connectorRightToggle.func_78787_b(64, 64);
        connectorRightToggle.field_78809_i = true;
        this.setRotation(connectorRightToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer connectorBottomToggle = new ModelRenderer((Model)this, 0, 19);
        connectorBottomToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 1.0f, 6.0f, false);
        connectorBottomToggle.func_78793_a(-5.0f, 22.0f, -3.0f);
        connectorBottomToggle.func_78787_b(64, 64);
        connectorBottomToggle.field_78809_i = true;
        this.setRotation(connectorBottomToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer connectorLeftToggle = new ModelRenderer((Model)this, 38, 0);
        connectorLeftToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 6.0f, 10.0f, false);
        connectorLeftToggle.func_78793_a(-7.0f, 13.0f, -5.0f);
        connectorLeftToggle.func_78787_b(64, 64);
        connectorLeftToggle.field_78809_i = true;
        this.setRotation(connectorLeftToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer connectorFrontToggle = new ModelRenderer((Model)this, 38, 16);
        connectorFrontToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 6.0f, 1.0f, false);
        connectorFrontToggle.func_78793_a(-5.0f, 13.0f, -7.0f);
        connectorFrontToggle.func_78787_b(64, 64);
        connectorFrontToggle.field_78809_i = true;
        this.setRotation(connectorFrontToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer connectorTopToggle = new ModelRenderer((Model)this, 0, 19);
        connectorTopToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 10.0f, 1.0f, 6.0f, false);
        connectorTopToggle.func_78793_a(-5.0f, 9.0f, -3.0f);
        connectorTopToggle.func_78787_b(64, 64);
        connectorTopToggle.field_78809_i = true;
        this.setRotation(connectorTopToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer portBackToggle = new ModelRenderer((Model)this, 18, 35);
        portBackToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 1.0f, false);
        portBackToggle.func_78793_a(-4.0f, 12.0f, 7.0f);
        portBackToggle.func_78787_b(64, 64);
        portBackToggle.field_78809_i = true;
        this.setRotation(portBackToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer portBottomToggle = new ModelRenderer((Model)this, 0, 26);
        portBottomToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 8.0f, false);
        portBottomToggle.func_78793_a(-4.0f, 23.0f, -4.0f);
        portBottomToggle.func_78787_b(64, 64);
        portBottomToggle.field_78809_i = true;
        this.setRotation(portBottomToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer portFrontToggle = new ModelRenderer((Model)this, 18, 35);
        portFrontToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 8.0f, 8.0f, 1.0f, false);
        portFrontToggle.func_78793_a(-4.0f, 12.0f, -8.0f);
        portFrontToggle.func_78787_b(64, 64);
        portFrontToggle.field_78809_i = true;
        this.setRotation(portFrontToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer portLeftToggle = new ModelRenderer((Model)this, 0, 35);
        portLeftToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 8.0f, false);
        portLeftToggle.func_78793_a(-8.0f, 12.0f, -4.0f);
        portLeftToggle.func_78787_b(64, 64);
        portLeftToggle.field_78809_i = true;
        this.setRotation(portLeftToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer portRightToggle = new ModelRenderer((Model)this, 0, 35);
        portRightToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 8.0f, 8.0f, false);
        portRightToggle.func_78793_a(7.0f, 12.0f, -4.0f);
        portRightToggle.func_78787_b(64, 64);
        portRightToggle.field_78809_i = true;
        this.setRotation(portRightToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer portTopToggle = new ModelRenderer((Model)this, 0, 26);
        portTopToggle.func_228304_a_(0.0f, 0.0f, 0.0f, 8.0f, 1.0f, 8.0f, false);
        portTopToggle.func_78793_a(-4.0f, 8.0f, -4.0f);
        portTopToggle.func_78787_b(64, 64);
        portTopToggle.field_78809_i = true;
        this.setRotation(portTopToggle, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledTop1 = new ModelRenderer((Model)this, 0, 51);
        ledTop1.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledTop1.func_78793_a(-5.5f, 8.1f, -0.5f);
        ledTop1.func_78787_b(64, 64);
        ledTop1.field_78809_i = true;
        this.setRotation(ledTop1, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledTop2 = new ModelRenderer((Model)this, 0, 51);
        ledTop2.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledTop2.func_78793_a(4.5f, 8.1f, -0.5f);
        ledTop2.func_78787_b(64, 64);
        ledTop2.field_78809_i = true;
        this.setRotation(ledTop2, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledBack1 = new ModelRenderer((Model)this, 0, 51);
        ledBack1.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledBack1.func_78793_a(-5.5f, 15.5f, 6.9f);
        ledBack1.func_78787_b(64, 64);
        ledBack1.field_78809_i = true;
        this.setRotation(ledBack1, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledBack2 = new ModelRenderer((Model)this, 0, 51);
        ledBack2.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledBack2.func_78793_a(4.5f, 15.5f, 6.9f);
        ledBack2.func_78787_b(64, 64);
        ledBack2.field_78809_i = true;
        this.setRotation(ledBack2, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledBottom2 = new ModelRenderer((Model)this, 0, 51);
        ledBottom2.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledBottom2.func_78793_a(4.5f, 22.9f, -0.5f);
        ledBottom2.func_78787_b(64, 64);
        ledBottom2.field_78809_i = true;
        this.setRotation(ledBottom2, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledBottom1 = new ModelRenderer((Model)this, 0, 51);
        ledBottom1.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledBottom1.func_78793_a(-5.5f, 22.9f, -0.5f);
        ledBottom1.func_78787_b(64, 64);
        ledBottom1.field_78809_i = true;
        this.setRotation(ledBottom1, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledFront1 = new ModelRenderer((Model)this, 0, 51);
        ledFront1.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledFront1.func_78793_a(-5.5f, 15.5f, -7.9f);
        ledFront1.func_78787_b(64, 64);
        ledFront1.field_78809_i = true;
        this.setRotation(ledFront1, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledFront2 = new ModelRenderer((Model)this, 0, 51);
        ledFront2.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledFront2.func_78793_a(4.5f, 15.5f, -7.9f);
        ledFront2.func_78787_b(64, 64);
        ledFront2.field_78809_i = true;
        this.setRotation(ledFront2, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledRight2 = new ModelRenderer((Model)this, 0, 51);
        ledRight2.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledRight2.func_78793_a(6.9f, 15.5f, 4.5f);
        ledRight2.func_78787_b(64, 64);
        ledRight2.field_78809_i = true;
        this.setRotation(ledRight2, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledRight1 = new ModelRenderer((Model)this, 0, 51);
        ledRight1.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledRight1.func_78793_a(6.9f, 15.5f, -5.5f);
        ledRight1.func_78787_b(64, 64);
        ledRight1.field_78809_i = true;
        this.setRotation(ledRight1, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledLeft1 = new ModelRenderer((Model)this, 0, 51);
        ledLeft1.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledLeft1.func_78793_a(-7.9f, 15.5f, 4.5f);
        ledLeft1.func_78787_b(64, 64);
        ledLeft1.field_78809_i = true;
        this.setRotation(ledLeft1, 0.0f, 0.0f, 0.0f);
        ModelRenderer ledLeft2 = new ModelRenderer((Model)this, 0, 51);
        ledLeft2.func_228304_a_(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, false);
        ledLeft2.func_78793_a(-7.9f, 15.5f, -5.5f);
        ledLeft2.func_78787_b(64, 64);
        ledLeft2.field_78809_i = true;
        this.setRotation(ledLeft2, 0.0f, 0.0f, 0.0f);
        this.leds1 = new ModelRenderer[]{ledFront1, ledLeft1, ledRight1, ledBack1, ledTop1, ledBottom1};
        this.leds2 = new ModelRenderer[]{ledFront2, ledLeft2, ledRight2, ledBack2, ledTop2, ledBottom2};
        this.ports = new ModelRenderer[]{portFrontToggle, portLeftToggle, portRightToggle, portBackToggle, portTopToggle, portBottomToggle};
        this.connectors = new ModelRenderer[]{connectorFrontToggle, connectorLeftToggle, connectorRightToggle, connectorBackToggle, connectorTopToggle, connectorBottomToggle};
    }

    public void render(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, EnergyCubeTier tier, boolean renderMain, boolean hasEffect) {
        if (renderMain) {
            this.func_225598_a_(matrix, this.getVertexBuilder(renderer, this.RENDER_TYPE, hasEffect), light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
        }
        EnumColor color = tier.getBaseTier().getColor();
        this.renderCorners(matrix, this.getVertexBuilder(renderer, RENDER_TYPE_BASE, hasEffect), 0xF000F0, overlayLight, color.getColor(0), color.getColor(1), color.getColor(2), 1.0f);
    }

    public void func_225598_a_(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha) {
        this.frame12.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame11.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame10.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame9.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame8.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame7.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame6.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame5.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame4.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame3.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame2.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.frame1.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner8.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner7.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner6.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner5.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner4.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner3.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner2.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner1.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
    }

    private void renderCorners(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha) {
        matrix.func_227860_a_();
        matrix.func_227862_a_(1.001f, 1.005f, 1.001f);
        matrix.func_227861_a_(0.0, -0.0061, 0.0);
        this.corner8.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner7.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner6.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner5.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner4.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner3.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner2.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        this.corner1.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        matrix.func_227865_b_();
    }

    public void renderSidesBatched(@Nonnull TileEntityEnergyCube tile, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight) {
        EnumSet<RelativeSide> enabledSides = EnumSet.noneOf(RelativeSide.class);
        EnumSet<RelativeSide> outputSides = EnumSet.noneOf(RelativeSide.class);
        ConfigInfo config = tile.getConfig().getConfig(TransmissionType.ENERGY);
        if (config != null) {
            for (RelativeSide side : EnumUtils.SIDES) {
                ISlotInfo slotInfo = config.getSlotInfo(side);
                if (slotInfo == null) continue;
                if (slotInfo.canInput()) {
                    enabledSides.add(side);
                    continue;
                }
                if (!slotInfo.canOutput()) continue;
                enabledSides.add(side);
                outputSides.add(side);
            }
        }
        this.renderSidesBatched(matrix, renderer, light, overlayLight, enabledSides, outputSides, false);
    }

    public void renderSidesBatched(@Nonnull ItemStack stack, EnergyCubeTier tier, @Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, boolean hasEffect) {
        Set<RelativeSide> outputSides;
        EnumSet<RelativeSide> enabledSides;
        CompoundNBT configData = ItemDataUtils.getDataMapIfPresent(stack);
        if (configData != null && configData.func_150297_b("componentConfig", 10)) {
            enabledSides = EnumSet.noneOf(RelativeSide.class);
            outputSides = EnumSet.noneOf(RelativeSide.class);
            CompoundNBT sideConfig = configData.func_74775_l("componentConfig").func_74775_l("config" + TransmissionType.ENERGY.ordinal());
            for (RelativeSide side : EnumUtils.SIDES) {
                DataType dataType = DataType.byIndexStatic(sideConfig.func_74762_e("side" + side.ordinal()));
                if (dataType.equals(DataType.INPUT)) {
                    enabledSides.add(side);
                    continue;
                }
                if (!dataType.equals(DataType.OUTPUT)) continue;
                enabledSides.add(side);
                outputSides.add(side);
            }
        } else {
            enabledSides = EnumSet.allOf(RelativeSide.class);
            outputSides = tier == EnergyCubeTier.CREATIVE ? EnumSet.allOf(RelativeSide.class) : Collections.singleton(RelativeSide.FRONT);
        }
        this.renderSidesBatched(matrix, renderer, light, overlayLight, enabledSides, outputSides, hasEffect);
    }

    private void renderSidesBatched(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, Set<RelativeSide> enabledSides, Set<RelativeSide> outputSides, boolean hasEffect) {
        if (!enabledSides.isEmpty()) {
            IVertexBuilder buffer = this.getVertexBuilder(renderer, this.RENDER_TYPE, hasEffect);
            for (RelativeSide enabledSide : enabledSides) {
                int sideOrdinal = enabledSide.ordinal();
                this.connectors[sideOrdinal].func_228309_a_(matrix, buffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
                this.ports[sideOrdinal].func_228309_a_(matrix, buffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            if (!outputSides.isEmpty()) {
                buffer = this.getVertexBuilder(renderer, RENDER_TYPE_BASE, hasEffect);
                for (RelativeSide outputSide : outputSides) {
                    this.ports[outputSide.ordinal()].func_228309_a_(matrix, buffer, 0xF000F0, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
                }
                this.renderLEDS(outputSides, this.getVertexBuilder(renderer, RENDER_TYPE_ON, hasEffect), matrix, 0xF000F0, overlayLight);
            }
        }
        if (outputSides.size() < EnumUtils.SIDES.length) {
            EnumSet<RelativeSide> remainingSides = EnumSet.allOf(RelativeSide.class);
            remainingSides.removeAll(outputSides);
            this.renderLEDS(remainingSides, this.getVertexBuilder(renderer, RENDER_TYPE_OFF, hasEffect), matrix, light, overlayLight);
        }
    }

    private void renderLEDS(Set<RelativeSide> sides, IVertexBuilder ledBuffer, MatrixStack matrix, int light, int overlayLight) {
        for (RelativeSide side : sides) {
            int sideOrdinal = side.ordinal();
            this.leds1[sideOrdinal].func_228309_a_(matrix, ledBuffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
            this.leds2[sideOrdinal].func_228309_a_(matrix, ledBuffer, light, overlayLight, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public static class ModelEnergyCore
    extends MekanismJavaModel {
        private static final ResourceLocation CORE_TEXTURE = MekanismUtils.getResource(MekanismUtils.ResourceType.RENDER, "energy_core.png");
        private final RenderType RENDER_TYPE = this.func_228282_a_(CORE_TEXTURE);
        private final ModelRenderer cube;

        public ModelEnergyCore() {
            super(MekanismRenderType::mekStandard);
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            this.cube = new ModelRenderer((Model)this, 0, 0);
            this.cube.func_228304_a_(-8.0f, -8.0f, -8.0f, 16.0f, 16.0f, 16.0f, false);
            this.cube.func_78793_a(0.0f, 0.0f, 0.0f);
            this.cube.func_78787_b(32, 32);
            this.cube.field_78809_i = true;
        }

        public IVertexBuilder getBuffer(@Nonnull IRenderTypeBuffer renderer) {
            return renderer.getBuffer(this.RENDER_TYPE);
        }

        public void render(@Nonnull MatrixStack matrix, @Nonnull IRenderTypeBuffer renderer, int light, int overlayLight, EnumColor color, float energyPercentage) {
            this.func_225598_a_(matrix, this.getBuffer(renderer), light, overlayLight, color.getColor(0), color.getColor(1), color.getColor(2), energyPercentage);
        }

        public void render(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder buffer, int light, int overlayLight, EnumColor color, float energyPercentage) {
            this.cube.func_228309_a_(matrix, buffer, light, overlayLight, color.getColor(0), color.getColor(1), color.getColor(2), energyPercentage);
        }

        public void func_225598_a_(@Nonnull MatrixStack matrix, @Nonnull IVertexBuilder vertexBuilder, int light, int overlayLight, float red, float green, float blue, float alpha) {
            this.cube.func_228309_a_(matrix, vertexBuilder, light, overlayLight, red, green, blue, alpha);
        }
    }
}

