/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.window.filter;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.functions.CharPredicate;
import mekanism.api.text.ILangEntry;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.window.filter.GuiTextFilter;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.common.MekanismLang;
import mekanism.common.base.TagCache;
import mekanism.common.content.filter.IModIDFilter;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.InputValidator;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.IForgeRegistryEntry;

public abstract class GuiModIDFilter<FILTER extends IModIDFilter<FILTER>, TILE extends TileEntityMekanism>
extends GuiTextFilter<FILTER, TILE> {
    protected GuiModIDFilter(IGuiWrapper gui, int x, int y, int width, int height, TILE tile, @Nullable FILTER origFilter) {
        super(gui, x, y, width, height, (ITextComponent)MekanismLang.MODID_FILTER.translate(new Object[0]), tile, origFilter);
    }

    @Override
    protected CharPredicate getInputValidator() {
        return InputValidator.RL_NAMESPACE.or(InputValidator.WILDCARD_CHARS);
    }

    @Override
    protected List<ITextComponent> getScreenText() {
        List<ITextComponent> list = super.getScreenText();
        list.add((ITextComponent)MekanismLang.MODID_FILTER_ID.translate(((IModIDFilter)this.filter).getModID()));
        return list;
    }

    @Override
    protected ILangEntry getNoFilterSaveError() {
        return MekanismLang.MODID_FILTER_NO_ID;
    }

    @Override
    protected boolean setText() {
        return this.setFilterName(this.text.getText(), false);
    }

    @Override
    @Nonnull
    protected List<ItemStack> getRenderStacks() {
        if (((IModIDFilter)this.filter).hasFilter()) {
            return TagCache.getModIDStacks(((IModIDFilter)this.filter).getModID(), false);
        }
        return Collections.emptyList();
    }

    @Override
    @Nullable
    protected IJEIGhostTarget.IGhostIngredientConsumer getGhostHandler() {
        return new IJEIGhostTarget.IGhostIngredientConsumer(){

            @Override
            public boolean supportsIngredient(Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    return !((ItemStack)ingredient).func_190926_b();
                }
                if (ingredient instanceof FluidStack) {
                    return !((FluidStack)ingredient).isEmpty();
                }
                if (ingredient instanceof ChemicalStack) {
                    return !((ChemicalStack)ingredient).isEmpty();
                }
                return ingredient instanceof IForgeRegistryEntry;
            }

            @Override
            public void accept(Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    GuiModIDFilter.this.setFilterName((ItemStack)ingredient);
                } else if (ingredient instanceof FluidStack) {
                    GuiModIDFilter.this.setFilterName((IForgeRegistryEntry)((FluidStack)ingredient).getFluid());
                } else if (ingredient instanceof ChemicalStack) {
                    GuiModIDFilter.this.setFilterName(((ChemicalStack)ingredient).getType());
                } else if (ingredient instanceof IForgeRegistryEntry) {
                    GuiModIDFilter.this.setFilterName((IForgeRegistryEntry)ingredient);
                }
            }
        };
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return GuiModIDFilter.mouseClickSlot(this.gui(), button, mouseX, mouseY, this.relativeX + 8, this.relativeY + this.getSlotOffset() + 1, NOT_EMPTY, this::setFilterName) || super.func_231044_a_(mouseX, mouseY, button);
    }

    private void setFilterName(ItemStack stack) {
        this.setFilterName(MekanismUtils.getModId(stack), true);
    }

    private void setFilterName(IForgeRegistryEntry<?> registryEntry) {
        this.setFilterName(registryEntry.getRegistryName().func_110624_b(), true);
    }

    private boolean setFilterName(String name, boolean click) {
        boolean success = false;
        if (name.isEmpty()) {
            this.filterSaveFailed(this.getNoFilterSaveError(), new Object[0]);
        } else if (name.equals(((IModIDFilter)this.filter).getModID())) {
            this.filterSaveFailed(MekanismLang.MODID_FILTER_SAME_ID, new Object[0]);
        } else {
            ((IModIDFilter)this.filter).setModID(name);
            this.slotDisplay.updateStackList();
            this.text.setText("");
            success = true;
        }
        if (click) {
            this.playClickSound();
        }
        return success;
    }
}

