/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import mekanism.api.chemical.gas.IGasTank;
import mekanism.api.fluid.IExtendedFluidTank;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiFluidGauge;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.gui.element.gauge.GuiGauge;
import mekanism.client.jei.interfaces.IJEIIngredientHelper;
import mekanism.common.lib.transmitter.TransmissionType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.text.ITextComponent;

public class GuiHybridGauge
extends GuiGauge<Void>
implements IJEIIngredientHelper {
    private final Supplier<IGasTank> gasTankSupplier;
    private final GuiGasGauge gasGauge;
    private final GuiFluidGauge fluidGauge;
    private ITextComponent label;

    public GuiHybridGauge(Supplier<IGasTank> gasTankSupplier, Supplier<List<IGasTank>> gasTanksSupplier, Supplier<IExtendedFluidTank> fluidTankSupplier, Supplier<List<IExtendedFluidTank>> fluidTanksSupplier, GaugeType type, IGuiWrapper gui, int x, int y) {
        this(gasTankSupplier, gasTanksSupplier, fluidTankSupplier, fluidTanksSupplier, type, gui, x, y, type.getGaugeOverlay().getWidth() + 2, type.getGaugeOverlay().getHeight() + 2);
    }

    public GuiHybridGauge(Supplier<IGasTank> gasTankSupplier, Supplier<List<IGasTank>> gasTanksSupplier, Supplier<IExtendedFluidTank> fluidTankSupplier, Supplier<List<IExtendedFluidTank>> fluidTanksSupplier, GaugeType type, IGuiWrapper gui, int x, int y, int width, int height) {
        super(type, gui, x, y, width, height);
        this.gasTankSupplier = gasTankSupplier;
        this.gasGauge = this.addPositionOnlyChild(new GuiGasGauge(gasTankSupplier, gasTanksSupplier, type, gui, x, y, width, height));
        this.fluidGauge = this.addPositionOnlyChild(new GuiFluidGauge(fluidTankSupplier, fluidTanksSupplier, type, gui, x, y, width, height));
    }

    public GuiHybridGauge setLabel(ITextComponent label) {
        this.label = label;
        return this;
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        return this.gasGauge.func_231044_a_(mouseX, mouseY, button) | this.fluidGauge.func_231044_a_(mouseX, mouseY, button);
    }

    @Override
    protected void applyRenderColor() {
        this.gasGauge.applyRenderColor();
        this.fluidGauge.applyRenderColor();
    }

    @Override
    @Nullable
    public Object getIngredient(double mouseX, double mouseY) {
        Object gasIngredient = this.gasGauge.getIngredient(mouseX, mouseY);
        return gasIngredient == null ? this.fluidGauge.getIngredient(mouseX, mouseY) : gasIngredient;
    }

    @Override
    public int getScaledLevel() {
        return Math.max(this.gasGauge.getScaledLevel(), this.fluidGauge.getScaledLevel());
    }

    @Override
    public TextureAtlasSprite getIcon() {
        return this.gasTankSupplier.get() == null || this.gasTankSupplier.get().isEmpty() ? this.fluidGauge.getIcon() : this.gasGauge.getIcon();
    }

    @Override
    public List<ITextComponent> getTooltipText() {
        return this.gasTankSupplier.get() == null || this.gasTankSupplier.get().isEmpty() ? this.fluidGauge.getTooltipText() : this.gasGauge.getTooltipText();
    }

    @Override
    public ITextComponent getLabel() {
        return this.label;
    }

    @Override
    public TransmissionType getTransmission() {
        return this.gasTankSupplier.get() == null || !this.gasTankSupplier.get().isEmpty() ? TransmissionType.GAS : TransmissionType.FLUID;
    }
}

