/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.gauge;

import javax.annotation.Nullable;
import mekanism.api.text.EnumColor;
import mekanism.common.tile.component.config.DataType;
import mekanism.common.util.MekanismUtils;
import net.minecraft.util.ResourceLocation;

public enum GaugeInfo {
    STANDARD("normal.png", 2, 2, null),
    BLUE("blue.png", 2, 2, EnumColor.DARK_BLUE),
    RED("red.png", 2, 2, EnumColor.DARK_RED),
    YELLOW("yellow.png", 2, 2, EnumColor.YELLOW),
    ORANGE("orange.png", 2, 2, EnumColor.ORANGE),
    AQUA("aqua.png", 2, 2, EnumColor.AQUA);

    @Nullable
    private final EnumColor color;
    private final int sideWidth;
    private final int sideHeight;
    private final ResourceLocation resourceLocation;

    private GaugeInfo(String texture, @Nullable int sideWidth, int sideHeight, EnumColor color) {
        this.resourceLocation = MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_GAUGE, texture);
        this.sideWidth = sideWidth;
        this.sideHeight = sideHeight;
        this.color = color;
    }

    @Nullable
    public EnumColor getColor() {
        return this.color;
    }

    public int getSideWidth() {
        return this.sideWidth;
    }

    public int getSideHeight() {
        return this.sideHeight;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public static GaugeInfo get(DataType type) {
        switch (type) {
            case OUTPUT: 
            case OUTPUT_1: {
                return BLUE;
            }
            case INPUT: 
            case INPUT_1: {
                return RED;
            }
            case OUTPUT_2: {
                return AQUA;
            }
            case INPUT_2: {
                return ORANGE;
            }
        }
        return STANDARD;
    }
}

