/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.ToLongFunction;
import javax.annotation.Nonnull;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalTank;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiDownArrow;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.GuiSideHolder;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiMergedTankGauge;
import mekanism.client.gui.element.slot.GuiSlot;
import mekanism.client.gui.element.slot.SlotType;
import mekanism.client.gui.element.tab.GuiContainerEditModeTab;
import mekanism.common.MekanismLang;
import mekanism.common.content.tank.TankMultiblockData;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.tile.base.TileEntityMekanism;
import mekanism.common.tile.multiblock.TileEntityDynamicTank;
import mekanism.common.util.text.TextUtils;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;

public class GuiDynamicTank
extends GuiMekanismTile<TileEntityDynamicTank, MekanismTileContainer<TileEntityDynamicTank>> {
    public GuiDynamicTank(MekanismTileContainer<TileEntityDynamicTank> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_238745_s_ += 2;
        this.dynamicSlots = true;
    }

    @Override
    protected void addGuiElements() {
        this.func_230480_a_(GuiSideHolder.armorHolder(this));
        this.func_230480_a_(new GuiElementHolder(this, 141, 16, 26, 56));
        super.addGuiElements();
        this.func_230480_a_(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 20));
        this.func_230480_a_(new GuiSlot(SlotType.INNER_HOLDER_SLOT, this, 145, 50));
        this.func_230480_a_(new GuiInnerScreen((IGuiWrapper)this, 49, 21, 84, 46, () -> {
            ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
            TankMultiblockData multiblock = (TankMultiblockData)((TileEntityDynamicTank)this.tile).getMultiblock();
            long capacity = multiblock.getChemicalTankCapacity();
            switch (multiblock.mergedTank.getCurrentType()) {
                case EMPTY: {
                    ret.add((ITextComponent)MekanismLang.EMPTY.translate(new Object[0]));
                    break;
                }
                case FLUID: {
                    this.addStored(ret, multiblock.getFluidTank().getFluid(), FluidStack::getAmount);
                    capacity = multiblock.getTankCapacity();
                    break;
                }
                case GAS: {
                    this.addStored(ret, multiblock.getGasTank());
                    break;
                }
                case INFUSION: {
                    this.addStored(ret, multiblock.getInfusionTank());
                    break;
                }
                case PIGMENT: {
                    this.addStored(ret, multiblock.getPigmentTank());
                    break;
                }
                case SLURRY: {
                    this.addStored(ret, multiblock.getSlurryTank());
                }
            }
            ret.add((ITextComponent)MekanismLang.CAPACITY.translate(""));
            ret.add((ITextComponent)MekanismLang.GENERIC_MB.translate(TextUtils.format(capacity)));
            return ret;
        }).spacing(2));
        this.func_230480_a_(new GuiDownArrow(this, 150, 39));
        this.func_230480_a_(new GuiContainerEditModeTab<TileEntityMekanism>(this, this.tile));
        this.func_230480_a_(new GuiMergedTankGauge<TankMultiblockData>(() -> ((TankMultiblockData)((TileEntityDynamicTank)this.tile).getMultiblock()).mergedTank, ((TileEntityDynamicTank)this.tile)::getMultiblock, GaugeType.MEDIUM, this, 7, 16, 34, 56));
    }

    private void addStored(List<ITextComponent> ret, IChemicalTank<?, ?> tank) {
        this.addStored(ret, tank.getStack(), ChemicalStack::getAmount);
    }

    private <STACK> void addStored(List<ITextComponent> ret, STACK stack, ToLongFunction<STACK> amountGetter) {
        ret.add((ITextComponent)MekanismLang.GENERIC_PRE_COLON.translate(stack));
        ret.add((ITextComponent)MekanismLang.GENERIC_MB.translate(TextUtils.format(amountGetter.applyAsLong(stack))));
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }
}

