/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.robit;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.providers.IRobitSkinProvider;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import mekanism.api.text.TextComponentUtil;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistryEntry;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class RobitSkin
extends ForgeRegistryEntry<RobitSkin>
implements IRobitSkinProvider,
IHasTranslationKey,
IHasTextComponent {
    private final List<ResourceLocation> textures;
    private String translationKey;

    public RobitSkin(ResourceLocation ... textures) {
        Objects.requireNonNull(textures, "Textures cannot be null.");
        this.textures = textures.length == 0 ? Collections.emptyList() : ImmutableList.copyOf((Object[])textures);
    }

    @Nullable
    public ResourceLocation getCustomModel() {
        return null;
    }

    public List<ResourceLocation> getTextures() {
        return this.textures;
    }

    public boolean isUnlocked(@Nonnull PlayerEntity player) {
        return true;
    }

    @Override
    @Nonnull
    public final RobitSkin getSkin() {
        return this;
    }

    @Override
    public String getTranslationKey() {
        if (this.translationKey == null) {
            this.translationKey = Util.func_200697_a((String)"robit_skin", (ResourceLocation)this.getRegistryName());
        }
        return this.translationKey;
    }

    @Override
    public ITextComponent getTextComponent() {
        return TextComponentUtil.translate(this.getTranslationKey(), new Object[0]);
    }
}

