/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.chemical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiPredicate;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.inputs.FluidStackIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.Contract;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public abstract class FluidChemicalToChemicalRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>>
extends MekanismRecipe
implements BiPredicate<FluidStack, STACK> {
    private final FluidStackIngredient fluidInput;
    private final INGREDIENT chemicalInput;
    protected final STACK output;

    public FluidChemicalToChemicalRecipe(ResourceLocation id, FluidStackIngredient fluidInput, INGREDIENT chemicalInput, STACK output) {
        super(id);
        this.fluidInput = Objects.requireNonNull(fluidInput, "Fluid input cannot be null.");
        this.chemicalInput = (IChemicalStackIngredient)Objects.requireNonNull(chemicalInput, "Chemical input cannot be null.");
        Objects.requireNonNull(output, "Output cannot be null.");
        if (((ChemicalStack)output).isEmpty()) {
            throw new IllegalArgumentException("Output cannot be empty.");
        }
        this.output = ((ChemicalStack)output).copy();
    }

    @Override
    public boolean test(FluidStack fluidStack, STACK chemicalStack) {
        return this.fluidInput.test(fluidStack) && this.chemicalInput.test(chemicalStack);
    }

    public FluidStackIngredient getFluidInput() {
        return this.fluidInput;
    }

    public INGREDIENT getChemicalInput() {
        return this.chemicalInput;
    }

    @Deprecated
    public STACK getOutputRepresentation() {
        return this.output;
    }

    public List<STACK> getOutputDefinition() {
        return Collections.singletonList(this.output);
    }

    @Contract(value="_, _ -> new", pure=true)
    public STACK getOutput(FluidStack fluidStack, STACK chemicalStack) {
        return (STACK)((ChemicalStack)this.output).copy();
    }

    @Override
    public void write(PacketBuffer buffer) {
        this.fluidInput.write(buffer);
        this.chemicalInput.write(buffer);
        ((ChemicalStack)this.output).writeToPacket(buffer);
    }
}

