/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.lib.TeleportUtils;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;

public class TargetPos {
    private Vector3 pos;
    private float yaw;
    private float pitch;
    private boolean includeHeading = true;
    private RegistryKey<World> dimension;

    public TargetPos() {
    }

    public TargetPos(Entity entity) {
        this(entity, true);
    }

    public TargetPos(CompoundNBT nbt) {
        this.readFromNBT(nbt);
    }

    public TargetPos(Entity entity, boolean includeHeading) {
        this.update(entity);
        this.includeHeading = includeHeading;
    }

    public TargetPos(double x, double y, double z, RegistryKey<World> dimension) {
        this(new Vector3(x, y, z), dimension);
    }

    public TargetPos(double x, double y, double z, RegistryKey<World> dimension, float pitch, float yaw) {
        this(new Vector3(x, y, z), dimension, pitch, yaw);
    }

    public TargetPos(Vector3 pos, RegistryKey<World> dimension) {
        this(pos, dimension, 0.0f, 0.0f);
    }

    public TargetPos(Vector3 pos, RegistryKey<World> dimension, float pitch, float yaw) {
        this.pos = pos;
        this.dimension = dimension;
        this.pitch = pitch;
        this.yaw = yaw;
    }

    public void update(Entity player) {
        this.pos = Vector3.fromEntity((Entity)player);
        this.dimension = player.field_70170_p.func_234923_W_();
        this.pitch = player.field_70125_A;
        this.yaw = player.field_70177_z;
    }

    public double getX() {
        return this.pos.x;
    }

    public double getY() {
        return this.pos.y;
    }

    public double getZ() {
        return this.pos.z;
    }

    public Vector3 getPos() {
        return this.pos;
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    public float getPitch() {
        return this.pitch;
    }

    public float getYaw() {
        return this.yaw;
    }

    public String getReadableName(boolean fullDim) {
        return "X: " + (int)Math.floor(this.pos.x) + ", Y: " + (int)Math.floor(this.pos.y) + ", Z: " + (int)Math.floor(this.pos.z) + ", " + (fullDim ? this.dimension.func_240901_a_() : this.dimension.func_240901_a_().func_110623_a());
    }

    public TargetPos setIncludeHeading(boolean includeHeading) {
        this.includeHeading = includeHeading;
        return this;
    }

    public TargetPos setX(double x) {
        this.pos.x = x;
        return this;
    }

    public TargetPos setY(double y) {
        this.pos.y = y;
        return this;
    }

    public TargetPos setZ(double z) {
        this.pos.z = z;
        return this;
    }

    public TargetPos setPos(Vector3 pos) {
        this.pos = pos;
        return this;
    }

    public TargetPos setDimension(RegistryKey<World> d) {
        this.dimension = d;
        return this;
    }

    public TargetPos setPitch(float p) {
        this.pitch = p;
        return this;
    }

    public TargetPos setYaw(float y) {
        this.yaw = y;
        return this;
    }

    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        this.pos.writeToNBT(nbt);
        nbt.func_74778_a("dim", this.dimension.func_240901_a_().toString());
        nbt.func_74757_a("heading", this.includeHeading);
        if (this.includeHeading) {
            nbt.func_74776_a("pitch", this.pitch);
            nbt.func_74776_a("yaw", this.yaw);
        }
        return nbt;
    }

    public CompoundNBT writeToNBT() {
        return this.writeToNBT(new CompoundNBT());
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.pos = Vector3.fromNBT((CompoundNBT)nbt);
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(nbt.func_74779_i("dim")));
        this.includeHeading = nbt.func_74767_n("heading");
        if (this.includeHeading) {
            this.pitch = nbt.func_74760_g("pitch");
            this.yaw = nbt.func_74760_g("yaw");
        }
    }

    public void write(MCDataOutput output) {
        output.writeVector(this.pos);
        output.writeResourceLocation(this.dimension.func_240901_a_());
        output.writeBoolean(this.includeHeading);
        if (this.includeHeading) {
            output.writeFloat(this.pitch);
            output.writeFloat(this.yaw);
        }
    }

    public void read(MCDataInput input) {
        this.pos = input.readVector();
        this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)input.readResourceLocation());
        this.includeHeading = input.readBoolean();
        if (this.includeHeading) {
            this.pitch = input.readFloat();
            this.yaw = input.readFloat();
        }
    }

    public Entity teleport(Entity entity) {
        if (this.includeHeading) {
            return TeleportUtils.teleportEntity(entity, this.dimension, this.pos, this.yaw, this.pitch);
        }
        return TeleportUtils.teleportEntity(entity, this.dimension, this.pos);
    }
}

