/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterBase;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import com.mojang.authlib.GameProfile;
import java.util.regex.Pattern;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.MinecraftServer;

public class FilterPlayer
extends FilterBase {
    public static Pattern namePattern = Pattern.compile("^[\\w]*$");
    protected boolean whitelistPlayers = true;
    private String playerName = "";
    private String playerUUID = "";

    public FilterPlayer(EntityFilter filter) {
        super(filter);
    }

    public void setWhitelistPlayers(boolean whitelistPlayers) {
        boolean prev = this.whitelistPlayers;
        this.whitelistPlayers = whitelistPlayers;
        this.getFilter().nodeModified(this);
        this.whitelistPlayers = prev;
    }

    public void setPlayerName(String playerName) {
        this.playerName = playerName;
        this.playerUUID = "";
        this.getFilter().nodeModified(this);
    }

    public boolean isWhitelistPlayers() {
        return this.whitelistPlayers;
    }

    public String getPlayerName() {
        return this.playerName;
    }

    @Override
    public boolean test(Entity entity) {
        boolean isPlayer = entity instanceof PlayerEntity;
        if (isPlayer) {
            if (this.playerName.isEmpty()) {
                return this.whitelistPlayers;
            }
            return this.isPlayerMatch((PlayerEntity)entity) == this.whitelistPlayers;
        }
        return !this.whitelistPlayers;
    }

    private boolean isPlayerMatch(PlayerEntity player) {
        GameProfile profile;
        if (!(player instanceof ServerPlayerEntity)) {
            return player.func_146103_bH().getName().equalsIgnoreCase(this.playerName);
        }
        if (!this.playerUUID.isEmpty()) {
            return player.func_110124_au().toString().equals(this.playerUUID);
        }
        MinecraftServer server = player.func_184102_h();
        if (server != null && (profile = server.func_152358_ax().func_152655_a(this.playerName)) != null) {
            this.playerUUID = profile.getId().toString();
            return player.func_110124_au().toString().equals(this.playerUUID);
        }
        return player.func_146103_bH().getName().equalsIgnoreCase(this.playerName);
    }

    @Override
    public FilterType getType() {
        return FilterType.PLAYER;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT compound = super.serializeNBT();
        compound.func_74757_a("include", this.whitelistPlayers);
        compound.func_74778_a("name", this.playerName);
        compound.func_74778_a("uuid", this.playerUUID);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        super.deserializeNBT(nbt);
        this.whitelistPlayers = nbt.func_74767_n("include");
        this.playerName = nbt.func_74779_i("name");
        this.playerUUID = nbt.func_74779_i("uuid");
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        super.serializeMCD(output);
        output.writeBoolean(this.whitelistPlayers);
        output.writeString(this.playerName);
        output.writeString(this.playerUUID);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        super.deSerializeMCD(input);
        this.whitelistPlayers = input.readBoolean();
        this.playerName = input.readString();
        this.playerUUID = input.readString();
        if (!namePattern.matcher(this.playerName).find()) {
            this.playerName = "";
        }
    }
}

