/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.entityfilter;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.IMCDataSerializable;
import com.brandon3055.brandonscore.lib.entityfilter.EntityFilter;
import com.brandon3055.brandonscore.lib.entityfilter.FilterGroup;
import com.brandon3055.brandonscore.lib.entityfilter.FilterType;
import java.util.Locale;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraftforge.common.util.INBTSerializable;

public abstract class FilterBase
implements INBTSerializable<CompoundNBT>,
IMCDataSerializable {
    private final EntityFilter filter;
    protected int nodeID = -1;
    private FilterGroup parent;

    public FilterBase(EntityFilter filter) {
        this.filter = filter;
    }

    public abstract boolean test(Entity var1);

    public int getNodeId() {
        return this.nodeID;
    }

    protected void initNode(FilterGroup parent) {
        this.parent = parent;
        this.nodeID = this.getFilter().getNextNodeID();
        this.getFilter().trackNode(this);
    }

    public void onLoaded(FilterGroup parent) {
        this.parent = parent;
    }

    public FilterGroup getParent() {
        return this.parent;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT compound = new CompoundNBT();
        compound.func_74768_a("node_id", this.nodeID);
        return compound;
    }

    public void deserializeNBT(CompoundNBT compound) {
        this.nodeID = compound.func_74762_e("node_id");
        this.getFilter().trackNode(this);
    }

    @Override
    public void serializeMCD(MCDataOutput output) {
        output.writeVarInt(this.nodeID);
    }

    @Override
    public void deSerializeMCD(MCDataInput input) {
        this.nodeID = input.readVarInt();
        this.getFilter().trackNode(this);
    }

    public abstract FilterType getType();

    public EntityFilter getFilter() {
        return this.filter;
    }

    public String getTranslationKey() {
        return "mod_gui.brandonscore.entity_filter." + this.getType().name().toLowerCase(Locale.ENGLISH);
    }
}

