/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import com.google.common.annotations.Beta;

public class DataFlags {
    public static DataFlags NONE = new DataFlags(false, false, false, false, false, false, false);
    public static DataFlags SAVE_NBT = new DataFlags(true, false, false, false, false, false, false);
    public static DataFlags SAVE_ITEM = new DataFlags(false, true, false, false, false, false, false);
    public static DataFlags SYNC_TILE = new DataFlags(false, false, true, false, false, false, false);
    public static DataFlags SYNC_CONTAINER = new DataFlags(false, false, false, true, false, false, false);
    public static DataFlags TRIGGER_UPDATE = new DataFlags(false, false, false, false, true, false, false);
    public static DataFlags SYNC_ON_SET = new DataFlags(false, false, false, false, false, true, false);
    @Beta
    public static DataFlags CLIENT_CONTROL = new DataFlags(false, false, false, false, false, false, true);
    public static DataFlags SAVE_BOTH = new DataFlags(SAVE_NBT, SAVE_ITEM);
    public static DataFlags SAVE_NBT_SYNC_TILE = new DataFlags(SAVE_NBT, SYNC_TILE);
    public static DataFlags SAVE_NBT_SYNC_CONTAINER = new DataFlags(SAVE_NBT, SYNC_CONTAINER);
    public static DataFlags SAVE_BOTH_SYNC_TILE = new DataFlags(SAVE_BOTH, SYNC_TILE);
    public static DataFlags SAVE_BOTH_SYNC_CONTAINER = new DataFlags(SAVE_BOTH, SYNC_CONTAINER);
    public final boolean saveNBT;
    public final boolean saveItem;
    public final boolean syncTile;
    public final boolean syncContainer;
    public final boolean triggerUpdate;
    public final boolean syncOnSet;
    public final boolean allowClientControl;

    DataFlags(boolean saveNBT, boolean saveItem, boolean syncTile, boolean syncContainer, boolean triggerUpdate, boolean syncOnSet, boolean allowClientControl) {
        this.saveNBT = saveNBT;
        this.saveItem = saveItem;
        this.syncTile = syncTile;
        this.syncContainer = syncContainer;
        this.triggerUpdate = triggerUpdate;
        this.syncOnSet = syncOnSet;
        this.allowClientControl = allowClientControl;
    }

    DataFlags(DataFlags[] combine) {
        this(NONE, combine);
    }

    DataFlags(DataFlags base, DataFlags ... combine) {
        boolean saveNBT = base.saveNBT;
        boolean saveItem = base.saveItem;
        boolean syncTile = base.syncTile;
        boolean syncContainer = base.syncContainer;
        boolean triggerUpdate = base.triggerUpdate;
        boolean syncOnSet = base.syncOnSet;
        boolean allowClientControl = base.allowClientControl;
        for (DataFlags flag : combine) {
            saveNBT |= flag.saveNBT;
            saveItem |= flag.saveItem;
            syncTile |= flag.syncTile;
            syncContainer |= flag.syncContainer;
            triggerUpdate |= flag.triggerUpdate;
            syncOnSet |= flag.syncOnSet;
            allowClientControl |= flag.allowClientControl;
        }
        this.saveNBT = saveNBT;
        this.saveItem = saveItem;
        this.syncTile = syncTile;
        this.syncContainer = syncContainer;
        this.triggerUpdate = triggerUpdate;
        this.syncOnSet = syncOnSet;
        this.allowClientControl = allowClientControl;
    }
}

