/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import io.netty.buffer.ByteBuf;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PlayerSlot {
    private int slot;
    private EnumInvCategory category;

    public PlayerSlot(int slot, EnumInvCategory category) {
        this.slot = slot;
        this.category = category;
    }

    public PlayerSlot(PlayerEntity player, Hand hand) {
        if (hand == Hand.OFF_HAND) {
            this.slot = 0;
            this.category = EnumInvCategory.OFF_HAND;
        } else {
            this.slot = player.field_71071_by.field_70461_c;
            this.category = EnumInvCategory.MAIN;
        }
    }

    public void toBuff(ByteBuf buf) {
        buf.writeByte(this.category.getIndex());
        buf.writeByte(this.slot);
    }

    public static PlayerSlot fromBuff(ByteBuf buf) {
        EnumInvCategory category = EnumInvCategory.fromIndex(buf.readByte());
        byte slot = buf.readByte();
        return new PlayerSlot(slot, category);
    }

    public int getSlotIndex() {
        return this.slot;
    }

    public int getCatIndex() {
        return this.category.getIndex();
    }

    public static PlayerSlot fromIndexes(int slotIndex, int catIndex) {
        EnumInvCategory category = EnumInvCategory.fromIndex(catIndex);
        return new PlayerSlot(slotIndex, category);
    }

    public String toString() {
        return this.category.getIndex() + ":" + this.slot;
    }

    public static PlayerSlot fromString(String slot) {
        try {
            return new PlayerSlot(Integer.parseInt(slot.substring(slot.indexOf(":") + 1)), EnumInvCategory.fromIndex(Integer.parseInt(slot.substring(0, slot.indexOf(":")))));
        }
        catch (Exception e) {
            LogHelperBC.error("Error loading slot reference from string! - " + slot);
            LogHelperBC.error("Required format \"inventory:slot\" Where inventory ether 0 (main), 1 (Armor) or 2 (Off Hand) and slot is the index in that inventory.");
            e.printStackTrace();
            return new PlayerSlot(0, EnumInvCategory.MAIN);
        }
    }

    public void setStackInSlot(PlayerEntity player, ItemStack stack) {
        LazyOptional<IItemHandlerModifiable> optional;
        if (this.category == EnumInvCategory.ARMOR) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_70460_b.size()) {
                LogHelperBC.error("PlayerSlot: Could not insert into the specified slot because the specified slot does not exist! Slot: " + this.slot + ", Inventory: " + (Object)((Object)this.category) + ", Stack: " + stack);
                return;
            }
            player.field_71071_by.field_70460_b.set(this.slot, (Object)stack);
        } else if (this.category == EnumInvCategory.MAIN) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_70462_a.size()) {
                LogHelperBC.error("PlayerSlot: Could not insert into the specified slot because the specified slot does not exist! Slot: " + this.slot + ", Inventory: " + (Object)((Object)this.category) + ", Stack: " + stack);
                return;
            }
            player.field_71071_by.field_70462_a.set(this.slot, (Object)stack);
        } else if (this.category == EnumInvCategory.OFF_HAND) {
            if (this.slot < 0 || this.slot >= player.field_71071_by.field_184439_c.size()) {
                LogHelperBC.error("PlayerSlot: Could not insert into the specified slot because the specified slot does not exist! Slot: " + this.slot + ", Inventory: " + (Object)((Object)this.category) + ", Stack: " + stack);
                return;
            }
            player.field_71071_by.field_184439_c.set(this.slot, (Object)stack);
        } else if (this.category == EnumInvCategory.EQUIPMENT && BrandonsCore.equipmentManager != null && (optional = BrandonsCore.equipmentManager.getInventory((LivingEntity)player)).isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optional.orElseThrow(IllegalStateException::new);
            if (this.slot < 0 || this.slot >= handler.getSlots()) {
                LogHelperBC.error("PlayerSlot: Could not insert into the specified slot because the specified slot does not exist! Slot: " + this.slot + ", Inventory: " + (Object)((Object)this.category) + ", Stack: " + stack);
                return;
            }
            handler.setStackInSlot(this.slot, stack);
        }
    }

    public static PlayerSlot findStack(PlayerInventory inv, Predicate<ItemStack> check) {
        LazyOptional<IItemHandlerModifiable> optional;
        ItemStack stack;
        int i;
        for (i = 0; i < inv.field_70462_a.size(); ++i) {
            stack = (ItemStack)inv.field_70462_a.get(i);
            if (stack.func_190926_b() || !check.test(stack)) continue;
            return new PlayerSlot(i, EnumInvCategory.MAIN);
        }
        for (i = 0; i < inv.field_70460_b.size(); ++i) {
            stack = (ItemStack)inv.field_70460_b.get(i);
            if (stack.func_190926_b() || !check.test(stack)) continue;
            return new PlayerSlot(i, EnumInvCategory.ARMOR);
        }
        for (i = 0; i < inv.field_184439_c.size(); ++i) {
            stack = (ItemStack)inv.field_184439_c.get(i);
            if (stack.func_190926_b() || !check.test(stack)) continue;
            return new PlayerSlot(i, EnumInvCategory.OFF_HAND);
        }
        if (BrandonsCore.equipmentManager != null && (optional = BrandonsCore.equipmentManager.getInventory((LivingEntity)inv.field_70458_d)).isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optional.orElseThrow(IllegalStateException::new);
            for (int i2 = 0; i2 < handler.getSlots(); ++i2) {
                ItemStack stack2 = handler.getStackInSlot(i2);
                if (stack2.func_190926_b() || !check.test(stack2)) continue;
                return new PlayerSlot(i2, EnumInvCategory.EQUIPMENT);
            }
        }
        return null;
    }

    public static PlayerSlot findStackActiveFirst(PlayerInventory inv, Predicate<ItemStack> check) {
        LazyOptional<IItemHandlerModifiable> optional;
        ItemStack stack;
        int i;
        if (!inv.func_70448_g().func_190926_b() && check.test(inv.func_70448_g())) {
            return new PlayerSlot(inv.field_70461_c, EnumInvCategory.MAIN);
        }
        for (i = 0; i < inv.field_184439_c.size(); ++i) {
            stack = (ItemStack)inv.field_184439_c.get(i);
            if (stack.func_190926_b() || !check.test(stack)) continue;
            return new PlayerSlot(i, EnumInvCategory.OFF_HAND);
        }
        for (i = 0; i < inv.field_70460_b.size(); ++i) {
            stack = (ItemStack)inv.field_70460_b.get(i);
            if (stack.func_190926_b() || !check.test(stack)) continue;
            return new PlayerSlot(i, EnumInvCategory.ARMOR);
        }
        for (i = 0; i < inv.field_70462_a.size(); ++i) {
            stack = (ItemStack)inv.field_70462_a.get(i);
            if (stack.func_190926_b() || !check.test(stack)) continue;
            return new PlayerSlot(i, EnumInvCategory.MAIN);
        }
        if (BrandonsCore.equipmentManager != null && (optional = BrandonsCore.equipmentManager.getInventory((LivingEntity)inv.field_70458_d)).isPresent()) {
            IItemHandlerModifiable handler = (IItemHandlerModifiable)optional.orElseThrow(IllegalStateException::new);
            for (int i2 = 0; i2 < handler.getSlots(); ++i2) {
                ItemStack stack2 = handler.getStackInSlot(i2);
                if (stack2.func_190926_b() || !check.test(stack2)) continue;
                return new PlayerSlot(i2, EnumInvCategory.EQUIPMENT);
            }
        }
        return null;
    }

    @Nullable
    public EquipmentSlotType getEquipmentSlot() {
        if (this.category == EnumInvCategory.ARMOR) {
            switch (this.slot) {
                case 0: {
                    return EquipmentSlotType.FEET;
                }
                case 1: {
                    return EquipmentSlotType.LEGS;
                }
                case 2: {
                    return EquipmentSlotType.CHEST;
                }
                case 3: {
                    return EquipmentSlotType.HEAD;
                }
            }
        } else if (this.category == EnumInvCategory.OFF_HAND) {
            return EquipmentSlotType.OFFHAND;
        }
        return null;
    }

    public ItemStack getStackInSlot(PlayerEntity player) {
        if (this.category == EnumInvCategory.ARMOR) {
            return (ItemStack)player.field_71071_by.field_70460_b.get(this.slot);
        }
        if (this.category == EnumInvCategory.MAIN) {
            return (ItemStack)player.field_71071_by.field_70462_a.get(this.slot);
        }
        if (this.category == EnumInvCategory.OFF_HAND) {
            return (ItemStack)player.field_71071_by.field_184439_c.get(this.slot);
        }
        if (this.category == EnumInvCategory.EQUIPMENT && BrandonsCore.equipmentManager != null) {
            LazyOptional<IItemHandlerModifiable> optional = BrandonsCore.equipmentManager.getInventory((LivingEntity)player);
            if (optional.isPresent()) {
                IItemHandlerModifiable handler = (IItemHandlerModifiable)optional.orElseThrow(IllegalStateException::new);
                return handler.getSlots() > this.slot ? handler.getStackInSlot(this.slot) : ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        LogHelperBC.bigError("PlayerSlot#getStackInSlot Invalid or null category! This should not be possible! [%s]... Fix your Shit!", new Object[]{this.category});
        return ItemStack.field_190927_a;
    }

    public static enum EnumInvCategory {
        MAIN(0),
        ARMOR(1),
        OFF_HAND(2),
        EQUIPMENT(3);

        private int index;
        private static EnumInvCategory[] indexMap;

        private EnumInvCategory(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public static EnumInvCategory fromIndex(int index) {
            if (index > 3 || index < 0) {
                LogHelperBC.bigError("PlayerSlot.EnumInvCategory#fromIndex Attempt to read invalid index! [%s]", index);
                return indexMap[0];
            }
            return indexMap[index];
        }

        static {
            indexMap = new EnumInvCategory[4];
            EnumInvCategory.indexMap[0] = MAIN;
            EnumInvCategory.indexMap[1] = ARMOR;
            EnumInvCategory.indexMap[2] = OFF_HAND;
            EnumInvCategory.indexMap[3] = EQUIPMENT;
        }
    }
}

