/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.inventory;

import codechicken.lib.inventory.InventorySimple;
import com.brandon3055.brandonscore.BCContent;
import com.brandon3055.brandonscore.network.BCoreNetwork;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ContainerPlayerAccess
extends Container {
    private static final EquipmentSlotType[] VALID_EQUIPMENT_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    public PlayerEntity player;
    public PlayerEntity playerAccess;
    private IInventory targetInventory;
    private MinecraftServer server;
    private int tick = 0;

    public ContainerPlayerAccess(int id, PlayerInventory playerInv) {
        super(BCContent.containerPlayerAccess, id);
        this.player = playerInv.field_70458_d;
        this.playerAccess = null;
        this.targetInventory = new InventorySimple(41);
        this.layoutSlots();
    }

    public ContainerPlayerAccess(int id, PlayerInventory playerInv, PlayerEntity playerAccess, MinecraftServer server) {
        super(BCContent.containerPlayerAccess, id);
        this.player = playerInv.field_70458_d;
        this.playerAccess = playerAccess;
        this.targetInventory = playerAccess.field_71071_by;
        this.server = server;
        this.layoutSlots();
    }

    public void func_75142_b() {
        if (this.tick++ % 10 == 0 && this.player instanceof ServerPlayerEntity && this.playerAccess != null) {
            BCoreNetwork.sendPlayerAccessUIUpdate((ServerPlayerEntity)this.player, this.playerAccess);
        }
        super.func_75142_b();
    }

    public void layoutSlots() {
        int i;
        int x;
        int y;
        int x2;
        int xPos = 9;
        int yPos = 21;
        for (x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot(this.targetInventory, x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot(this.targetInventory, x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new ArmorSlot(this.targetInventory, 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.func_75146_a(new OffhandSlot(this.targetInventory, 40, xPos + 186, yPos + 54 + 3));
        xPos = 9;
        yPos = 168;
        for (x2 = 0; x2 < 9; ++x2) {
            this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, x2, xPos + 21 + 18 * x2, yPos + 54 + 3));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)this.player.field_71071_by, x + y * 9 + 9, xPos + 21 + 18 * x, yPos + y * 18));
            }
        }
        for (i = 0; i < 4; ++i) {
            this.func_75146_a(new ArmorSlot((IInventory)this.player.field_71071_by, 36 + (3 - i), xPos, yPos + i * 19, VALID_EQUIPMENT_SLOTS[i], this.player));
        }
        this.func_75146_a(new OffhandSlot((IInventory)this.player.field_71071_by, 40, xPos + 186, yPos + 54 + 3));
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    private static class OffhandSlot
    extends Slot {
        public OffhandSlot(IInventory inventoryIn, int index, int xPosition, int yPosition) {
            super(inventoryIn, index, xPosition, yPosition);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public String getSlotTexture() {
            return "minecraft:items/empty_armor_slot_shield";
        }
    }

    private static class ArmorSlot
    extends Slot {
        private final EquipmentSlotType eSlot;
        private final PlayerEntity aPlayer;

        public ArmorSlot(IInventory inventoryIn, int index, int xPosition, int yPosition, EquipmentSlotType eSlot, PlayerEntity aPlayer) {
            super(inventoryIn, index, xPosition, yPosition);
            this.eSlot = eSlot;
            this.aPlayer = aPlayer;
        }

        public int func_75219_a() {
            return 64;
        }

        public boolean func_75214_a(ItemStack stack) {
            return true;
        }

        public boolean func_82869_a(PlayerEntity playerIn) {
            ItemStack itemstack = this.func_75211_c();
            return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
        }

        @Nullable
        @OnlyIn(value=Dist.CLIENT)
        public String getSlotTexture() {
            return PlayerContainer.field_226619_g_.toString();
        }
    }
}

