/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.guielements;

import com.brandon3055.brandonscore.client.gui.modulargui.GuiElement;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.guielements.GuiSlotRender;
import com.brandon3055.brandonscore.lib.StringyStacks;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiStackIcon
extends GuiElement<GuiStackIcon>
implements IModularGui.JEITargetAdapter {
    public static Map<String, ItemStack> stackCache = new HashMap<String, ItemStack>();
    public boolean drawCount = true;
    public boolean drawToolTip = true;
    public boolean drawHoverHighlight = false;
    private GuiElement background = null;
    protected List<ITextComponent> toolTipOverride = null;
    private String stackString;
    private ItemStack stack = ItemStack.field_190927_a;
    private Runnable clickListener = null;
    private Consumer<Object> ingredientDropListener = null;

    public GuiStackIcon() {
        this(ItemStack.field_190927_a);
    }

    @Deprecated
    public GuiStackIcon(String stackString) {
        this.stackString = stackString;
        this.setSize(18, 18);
    }

    public GuiStackIcon(ItemStack stack) {
        this.stack = stack;
        this.setSize(18, 18);
    }

    @Deprecated
    public GuiStackIcon(int xPos, int yPos, String stackString) {
        super(xPos, yPos);
        this.stackString = stackString;
        this.setSize(18, 18);
    }

    @Deprecated
    public GuiStackIcon(int xPos, int yPos, int xSize, int ySize, String stackString) {
        super(xPos, yPos, xSize, ySize);
        this.stackString = stackString;
    }

    @Override
    public void renderElement(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderElement(minecraft, mouseX, mouseY, partialTicks);
        if (this.drawHoverHighlight && this.isMouseOver(mouseX, mouseY)) {
            this.drawColouredRect(this.xPos(), this.yPos(), this.xSize(), this.ySize(), -2130706433);
        }
        RenderSystem.pushMatrix();
        this.renderStack(minecraft);
        RenderSystem.popMatrix();
    }

    public GuiStackIcon setDrawCount(boolean drawCount) {
        this.drawCount = drawCount;
        return this;
    }

    private void renderStack(Minecraft minecraft) {
        if (this.getStack().func_190926_b()) {
            return;
        }
        double scaledWidth = (double)this.xSize() / 18.0;
        double scaledHeight = (double)this.ySize() / 18.0;
        RenderSystem.translated((double)((double)this.xPos() + scaledWidth + (double)this.getInsets().left), (double)((double)this.yPos() + scaledHeight + (double)this.getInsets().top), (double)(this.getRenderZLevel() - 80.0f));
        RenderSystem.scaled((double)scaledWidth, (double)scaledHeight, (double)1.0);
        minecraft.func_175599_af().func_175042_a(this.getStack(), 0, 0);
        if (this.getStack().func_77973_b().showDurabilityBar(this.getStack())) {
            double health = this.getStack().func_77973_b().getDurabilityForDisplay(this.getStack());
            int rgbfordisplay = this.getStack().func_77973_b().getRGBDurabilityForDisplay(this.getStack());
            int i = Math.round(13.0f - (float)health * 13.0f);
            RenderSystem.translated((double)0.0, (double)0.0, (double)(-(this.getRenderZLevel() - 80.0f)));
            this.zOffset += 45.0;
            this.drawColouredRect(2.0, 13.0, 13.0, 2.0, -16777216);
            this.drawColouredRect(2.0, 13.0, i, 1.0, rgbfordisplay | 0xFF000000);
            this.zOffset -= 45.0;
            RenderSystem.translated((double)0.0, (double)0.0, (double)(this.getRenderZLevel() - 80.0f));
        }
        if (this.drawCount && this.getStack().func_190916_E() > 1) {
            String s = this.getStack().func_190916_E() + "";
            RenderSystem.translated((double)0.0, (double)0.0, (double)(-(this.getRenderZLevel() - 80.0f)));
            this.zOffset += 45.0;
            float f = (float)((double)this.xSize() / scaledWidth) - (float)this.fontRenderer.func_78256_a(s) - 1.0f;
            ((Object)((Object)this.fontRenderer)).getClass();
            this.drawString((FontRenderer)this.fontRenderer, s, f, 9.0f, 0xFFFFFF, true);
            this.zOffset -= 45.0;
        }
        RenderHelper.func_74518_a();
    }

    @Override
    public boolean renderOverlayLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.getInsetRect().contains(mouseX, mouseY) && (this.drawToolTip || this.toolTipOverride != null) && !this.getStack().func_190926_b()) {
            List<ITextComponent> list = this.toolTipOverride != null ? this.toolTipOverride : this.getTooltipFromItem(this.getStack());
            this.drawHoveringText(list, mouseX, mouseY, this.fontRenderer);
            return true;
        }
        return super.renderOverlayLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.clickListener != null && this.isMouseOver(mouseX, mouseY)) {
            this.clickListener.run();
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void setClickListener(Runnable clickListener) {
        this.clickListener = clickListener;
    }

    @Deprecated
    public GuiStackIcon setStack(@Nullable String stackString) {
        this.stackString = stackString;
        return this;
    }

    public GuiStackIcon setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    public GuiStackIcon setBackground(GuiElement background) {
        if (background == null) {
            if (this.background != null) {
                this.removeChild(this.background);
                this.background = null;
            }
        } else {
            if (this.background != null) {
                this.removeChild(this.background);
            }
            this.background = background;
            background.setPos(this);
            background.setSize(this);
            this.addChild(background);
        }
        return this;
    }

    public GuiStackIcon setToolTip(boolean drawToolTip) {
        this.drawToolTip = drawToolTip;
        return this;
    }

    public ItemStack getStack() {
        if (this.stackString == null) {
            return this.stack;
        }
        if (this.stackString.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        if (!stackCache.containsKey(this.stackString)) {
            ItemStack stack = StringyStacks.fromString(this.stackString, null);
            if (stack == null) {
                stack = new ItemStack((IItemProvider)Blocks.field_180401_cv);
                this.toolTipOverride = new ArrayList<ITextComponent>();
                this.toolTipOverride.add((ITextComponent)new StringTextComponent("Failed to load Item Stack"));
                this.toolTipOverride.add((ITextComponent)new StringTextComponent("This may mean the mod the stack belongs to is not installed"));
                this.toolTipOverride.add((ITextComponent)new StringTextComponent("Or its just broken..."));
            }
            stackCache.put(this.stackString, stack);
        }
        return stackCache.get(this.stackString);
    }

    @Deprecated
    public GuiStackIcon setToolTipOverride(List<String> toolTipOverride) {
        this.toolTipOverride = toolTipOverride == null ? null : toolTipOverride.stream().map(StringTextComponent::new).collect(Collectors.toList());
        return this;
    }

    public GuiStackIcon setHoverOverride(List<ITextComponent> toolTipOverride) {
        this.toolTipOverride = toolTipOverride;
        return this;
    }

    public GuiStackIcon setDrawHoverHighlight(boolean drawHoverHighlight) {
        this.drawHoverHighlight = drawHoverHighlight;
        return this;
    }

    public GuiStackIcon addSlotBackground() {
        this.setBackground(null);
        this.background = ((GuiSlotRender)new GuiSlotRender().setPos(this)).setSizeModifiers((E guiSlotRender, Integer integer) -> this.xSize(), (E guiSlotRender, Integer integer) -> this.ySize());
        this.addChild(this.background);
        return this;
    }

    public GuiElement getBackground() {
        return this.background;
    }

    @Override
    public Rectangle getArea() {
        return this.getRect();
    }

    public void setIngredientDropListener(Consumer<Object> ingredientDropListener) {
        this.ingredientDropListener = ingredientDropListener;
    }

    @Override
    public void accept(Object ingredient) {
        if (this.ingredientDropListener != null) {
            this.ingredientDropListener.accept(ingredient);
        }
    }
}

